/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util.collection;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.collection.IdSet;
import org.apache.hugegraph.util.collection.IntMap;
import org.apache.hugegraph.util.collection.IntSet;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

public class CollectionFactory {
    private final CollectionType type;

    public CollectionFactory() {
        this.type = CollectionType.EC;
    }

    public CollectionFactory(CollectionType type) {
        this.type = type;
    }

    public <V> List<V> newList() {
        return CollectionFactory.newList(this.type);
    }

    public <V> List<V> newList(int initialCapacity) {
        return CollectionFactory.newList(this.type, initialCapacity);
    }

    public <V> List<V> newList(Collection<V> collection) {
        return CollectionFactory.newList(this.type, collection);
    }

    public static <V> List<V> newList(CollectionType type) {
        switch (type) {
            case EC: {
                return new FastList();
            }
            case JCF: {
                return new ArrayList();
            }
            case FU: {
                return new ObjectArrayList();
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <V> List<V> newList(CollectionType type, int initialCapacity) {
        switch (type) {
            case EC: {
                return new FastList(initialCapacity);
            }
            case JCF: {
                return new ArrayList(initialCapacity);
            }
            case FU: {
                return new ObjectArrayList(initialCapacity);
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <V> List<V> newList(CollectionType type, Collection<V> collection) {
        switch (type) {
            case EC: {
                return new FastList(collection);
            }
            case JCF: {
                return new ArrayList<V>(collection);
            }
            case FU: {
                return new ObjectArrayList(collection);
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public <V> Set<V> newSet() {
        return CollectionFactory.newSet(this.type);
    }

    public <V> Set<V> newSet(int initialCapacity) {
        return CollectionFactory.newSet(this.type, initialCapacity);
    }

    public <V> Set<V> newSet(Collection<V> collection) {
        return CollectionFactory.newSet(this.type, collection);
    }

    public static <V> Set<V> newSet(CollectionType type) {
        switch (type) {
            case EC: {
                return new UnifiedSet();
            }
            case JCF: {
                return new HashSet();
            }
            case FU: {
                return new ObjectOpenHashSet();
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <V> Set<V> newSet(CollectionType type, int initialCapacity) {
        switch (type) {
            case EC: {
                return new UnifiedSet(initialCapacity);
            }
            case JCF: {
                return new HashSet(initialCapacity);
            }
            case FU: {
                return new ObjectOpenHashSet(initialCapacity);
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <V> Set<V> newSet(CollectionType type, Collection<V> collection) {
        switch (type) {
            case EC: {
                return new UnifiedSet(collection);
            }
            case JCF: {
                return new HashSet<V>(collection);
            }
            case FU: {
                return new ObjectOpenHashSet(collection);
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public <K, V> Map<K, V> newMap() {
        return CollectionFactory.newMap(this.type);
    }

    public <K, V> Map<K, V> newMap(int initialCapacity) {
        return CollectionFactory.newMap(this.type, initialCapacity);
    }

    public <K, V> Map<K, V> newMap(Map<? extends K, ? extends V> map) {
        return CollectionFactory.newMap(this.type, map);
    }

    public static <K, V> Map<K, V> newMap(CollectionType type) {
        switch (type) {
            case EC: {
                return new UnifiedMap();
            }
            case JCF: {
                return new HashMap();
            }
            case FU: {
                return new Object2ObjectOpenHashMap();
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <K, V> Map<K, V> newMap(CollectionType type, int initialCapacity) {
        switch (type) {
            case EC: {
                return new UnifiedMap(initialCapacity);
            }
            case JCF: {
                return new HashMap(initialCapacity);
            }
            case FU: {
                return new Object2ObjectOpenHashMap(initialCapacity);
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <K, V> Map<K, V> newMap(CollectionType type, Map<? extends K, ? extends V> map) {
        switch (type) {
            case EC: {
                return new UnifiedMap(map);
            }
            case JCF: {
                return new HashMap<K, V>(map);
            }
            case FU: {
                return new Object2ObjectOpenHashMap(map);
            }
        }
        throw new AssertionError((Object)("Unsupported collection type: " + type));
    }

    public static <V> MutableIntObjectMap<V> newIntObjectMap() {
        return new IntObjectHashMap();
    }

    public static <V> MutableIntObjectMap<V> newIntObjectMap(int initialCapacity) {
        return new IntObjectHashMap(initialCapacity);
    }

    public static <V> MutableIntObjectMap<V> newIntObjectMap(IntObjectMap<? extends V> map) {
        return new IntObjectHashMap(map);
    }

    public static <V> MutableIntObjectMap<V> newIntObjectMap(Object ... objects) {
        IntObjectHashMap map = IntObjectHashMap.newMap();
        E.checkArgument((objects.length % 2 == 0 ? 1 : 0) != 0, (String)"Must provide even arguments for CollectionFactory.newIntObjectMap", (Object[])new Object[0]);
        for (int i = 0; i < objects.length; i += 2) {
            int key = objects[i] instanceof Id ? (int)((Id)objects[i]).asLong() : (Integer)objects[i];
            map.put(key, objects[i + 1]);
        }
        return map;
    }

    public IdSet newIdSet() {
        return CollectionFactory.newIdSet(this.type);
    }

    public static IdSet newIdSet(CollectionType type) {
        return new IdSet(type);
    }

    public static IntSet newIntSet() {
        return new IntSet.IntSetBySegments(Integer.MAX_VALUE);
    }

    public static IntMap newIntMap() {
        return new IntMap.IntMapBySegments(Integer.MAX_VALUE);
    }
}

