/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class Vertices {
    @JsonProperty(value="ids")
    public Set<Object> ids;
    @JsonProperty(value="label")
    public String label;
    @JsonProperty(value="properties")
    public Map<String, Object> properties;

    public Iterator<Vertex> vertices(HugeGraph g) {
        Iterator iterator;
        Map<String, Object> props = this.properties;
        E.checkArgument((this.ids != null && !this.ids.isEmpty() || props != null && !props.isEmpty() || this.label != null ? 1 : 0) != 0, (String)"No source vertices provided", (Object[])new Object[0]);
        if (this.ids != null && !this.ids.isEmpty()) {
            ArrayList<Id> sourceIds = new ArrayList<Id>(this.ids.size());
            for (Object id : this.ids) {
                sourceIds.add(HugeVertex.getIdValue((Object)id));
            }
            iterator = g.vertices(sourceIds.toArray());
            E.checkArgument((boolean)iterator.hasNext(), (String)"Not exist source vertices with ids %s", (Object[])new Object[]{this.ids});
        } else {
            ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
            if (this.label != null) {
                Id label = g.vertexLabel(this.label).id();
                query.eq(HugeKeys.LABEL, (Object)label);
            }
            if (props != null && !props.isEmpty()) {
                Map pks = TraversalUtil.transProperties((HugeGraph)g, props);
                TraversalUtil.fillConditionQuery((ConditionQuery)query, (Map)pks, (HugeGraph)g);
            }
            assert (!query.empty());
            iterator = g.vertices((Query)query);
            E.checkArgument((boolean)iterator.hasNext(), (String)"Not exist source vertex with label '%s' and properties '%s'", (Object[])new Object[]{this.label, props});
        }
        return iterator;
    }

    public String toString() {
        return String.format("SourceVertex{ids=%s,label=%s,properties=%s}", this.ids, this.label, this.properties);
    }
}

