/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.KneighborTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KneighborRecords;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/kneighbor")
@Singleton
@Tag(name="KneighborAPI")
public class KneighborAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(KneighborAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String sourceV, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="limit") @DefaultValue(value="10000000") int limit) {
        Set ids;
        LOG.debug("Graph [{}] get k-neighbor from '{}' with direction '{}', edge label '{}', max depth '{}', max degree '{}' and limit '{}'", new Object[]{graph, sourceV, direction, edgeLabel, depth, maxDegree, limit});
        Id source = VertexAPI.checkAndParseVertexId(sourceV);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = KneighborAPI.graph(manager, graph);
        try (KneighborTraverser traverser = new KneighborTraverser(g);){
            ids = traverser.kneighbor(source, dir, edgeLabel, depth, maxDegree, (long)limit);
        }
        return manager.serializer((Graph)g).writeList("vertices", ids);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        KneighborRecords results;
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.source, (String)"The source of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.step != null ? 1 : 0) != 0, (String)"The steps of request can't be null", (Object[])new Object[0]);
        if (request.countOnly) {
            E.checkArgument((!request.withVertex && !request.withPath ? 1 : 0) != 0, (String)"Can't return vertex or path when count only", (Object[])new Object[0]);
        }
        LOG.debug("Graph [{}] get customized kneighbor from source vertex '{}', with step '{}', limit '{}', count_only '{}', with_vertex '{}' and with_path '{}'", new Object[]{graph, request.source, request.step, request.limit, request.countOnly, request.withVertex, request.withPath});
        HugeGraph g = KneighborAPI.graph(manager, graph);
        Id sourceId = HugeVertex.getIdValue((Object)request.source);
        EdgeStep step = KneighborAPI.step(g, request.step);
        try (KneighborTraverser traverser = new KneighborTraverser(g);){
            results = traverser.customizedKneighbor(sourceId, step, request.maxDepth, (long)request.limit);
        }
        long size = results.size();
        if ((long)request.limit != Long.MAX_VALUE && size > (long)request.limit) {
            size = request.limit;
        }
        ImmutableList neighbors = request.countOnly ? ImmutableList.of() : results.ids((long)request.limit);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        if (request.withPath) {
            paths.addAll(results.paths((long)request.limit));
        }
        Iterator iter = QueryResults.emptyIterator();
        if (request.withVertex && !request.countOnly) {
            HashSet ids = new HashSet(neighbors);
            if (request.withPath) {
                for (HugeTraverser.Path p : paths) {
                    ids.addAll(p.vertices());
                }
            }
            if (!ids.isEmpty()) {
                iter = g.vertices(ids.toArray());
            }
        }
        return manager.serializer((Graph)g).writeNodesWithPath("kneighbor", (List<Id>)neighbors, size, (Collection<HugeTraverser.Path>)paths, iter);
    }

    private static class Request {
        @JsonProperty(value="source")
        public Object source;
        @JsonProperty(value="step")
        public TraverserAPI.Step step;
        @JsonProperty(value="max_depth")
        public int maxDepth;
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10000000");
        @JsonProperty(value="count_only")
        public boolean countOnly = false;
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;
        @JsonProperty(value="with_path")
        public boolean withPath = false;

        private Request() {
        }

        public String toString() {
            return String.format("PathRequest{source=%s,step=%s,maxDepth=%slimit=%s,countOnly=%s,withVertex=%s,withPath=%s}", this.source, this.step, this.maxDepth, this.limit, this.countOnly, this.withVertex, this.withPath);
        }
    }
}

