/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.CustomizedCrosspointsTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/customizedcrosspoints")
@Singleton
@Tag(name="CustomizedCrosspointsAPI")
public class CustomizedCrosspointsAPI
extends API {
    private static final Logger LOG = Log.logger(CustomizedCrosspointsAPI.class);

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, CrosspointsRequest request) {
        E.checkArgumentNotNull((Object)request, (String)"The crosspoints request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.sources, (String)"The sources of crosspoints request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.pathPatterns != null && !request.pathPatterns.isEmpty() ? 1 : 0) != 0, (String)"The steps of crosspoints request can't be empty", (Object[])new Object[0]);
        LOG.debug("Graph [{}] get customized crosspoints from source vertex '{}', with path_pattern '{}', with_path '{}', with_vertex '{}', capacity '{}' and limit '{}'", new Object[]{graph, request.sources, request.pathPatterns, request.withPath, request.withVertex, request.capacity, request.limit});
        HugeGraph g = CustomizedCrosspointsAPI.graph(manager, graph);
        Iterator<Vertex> sources = request.sources.vertices(g);
        List<CustomizedCrosspointsTraverser.PathPattern> patterns = CustomizedCrosspointsAPI.pathPatterns(g, request);
        CustomizedCrosspointsTraverser traverser = new CustomizedCrosspointsTraverser(g);
        CustomizedCrosspointsTraverser.CrosspointsPaths paths = traverser.crosspointsPaths(sources, patterns, request.capacity, (long)request.limit);
        Iterator iter = QueryResults.emptyIterator();
        if (!request.withVertex) {
            return manager.serializer((Graph)g).writeCrosspoints(paths, iter, request.withPath);
        }
        Set ids = new HashSet();
        if (request.withPath) {
            for (HugeTraverser.Path p : paths.paths()) {
                ids.addAll(p.vertices());
            }
        } else {
            ids = paths.crosspoints();
        }
        if (!ids.isEmpty()) {
            iter = g.vertices(ids.toArray());
        }
        return manager.serializer((Graph)g).writeCrosspoints(paths, iter, request.withPath);
    }

    private static List<CustomizedCrosspointsTraverser.PathPattern> pathPatterns(HugeGraph graph, CrosspointsRequest request) {
        int stepSize = request.pathPatterns.size();
        ArrayList<CustomizedCrosspointsTraverser.PathPattern> pathPatterns = new ArrayList<CustomizedCrosspointsTraverser.PathPattern>(stepSize);
        for (PathPattern pattern : request.pathPatterns) {
            CustomizedCrosspointsTraverser.PathPattern pathPattern = new CustomizedCrosspointsTraverser.PathPattern();
            for (Step step : pattern.steps) {
                pathPattern.add(step.jsonToStep(graph));
            }
            pathPatterns.add(pathPattern);
        }
        return pathPatterns;
    }

    private static class Step {
        @JsonProperty(value="direction")
        public Directions direction;
        @JsonProperty(value="labels")
        public List<String> labels;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;
        @JsonAlias(value={"degree"})
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="skip_degree")
        public long skipDegree = 0L;

        private Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,properties=%s,maxDegree=%s,skipDegree=%s}", this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree);
        }

        private CustomizedCrosspointsTraverser.Step jsonToStep(HugeGraph g) {
            return new CustomizedCrosspointsTraverser.Step(g, this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree);
        }
    }

    private static class PathPattern {
        @JsonProperty(value="steps")
        public List<Step> steps;

        private PathPattern() {
        }

        public String toString() {
            return String.format("PathPattern{steps=%s", this.steps);
        }
    }

    private static class CrosspointsRequest {
        @JsonProperty(value="sources")
        public Vertices sources;
        @JsonProperty(value="path_patterns")
        public List<PathPattern> pathPatterns;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10");
        @JsonProperty(value="with_path")
        public boolean withPath = false;
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;

        private CrosspointsRequest() {
        }

        public String toString() {
            return String.format("CrosspointsRequest{sourceVertex=%s,pathPatterns=%s,withPath=%s,withVertex=%s,capacity=%s,limit=%s}", this.sources, this.pathPatterns, this.withPath, this.withVertex, this.capacity, this.limit);
        }
    }
}

