/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.ShortestPathTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/allshortestpaths")
@Singleton
@Tag(name="AllShortestPathsAPI")
public class AllShortestPathsAPI
extends API {
    private static final Logger LOG = Log.logger(AllShortestPathsAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="skip_degree") @DefaultValue(value="0") long skipDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity) {
        LOG.debug("Graph [{}] get shortest path from '{}', to '{}' with direction {}, edge label {}, max depth '{}', max degree '{}', skipped degree '{}' and capacity '{}'", new Object[]{graph, source, target, direction, edgeLabel, depth, maxDegree, skipDegree, capacity});
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = AllShortestPathsAPI.graph(manager, graph);
        ShortestPathTraverser traverser = new ShortestPathTraverser(g);
        ImmutableList edgeLabels = edgeLabel == null ? ImmutableList.of() : ImmutableList.of((Object)edgeLabel);
        HugeTraverser.PathSet paths = traverser.allShortestPaths(sourceId, targetId, dir, (List)edgeLabels, depth, maxDegree, skipDegree, capacity);
        return manager.serializer((Graph)g).writePaths("paths", (Collection<HugeTraverser.Path>)paths, false);
    }
}

