/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

public final class CharSequenceImpl
implements CharSequence {
    private final char[] buffer;
    private final int start;
    private final int end;

    public CharSequenceImpl(char[] buffer, int start, int end) {
        this.buffer = buffer;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[this.start + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSequenceImpl(this.buffer, this.start + start, this.start + end);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CharSequence)) {
            return false;
        }
        CharSequence cs = (CharSequence)o;
        if (cs.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        if (this.start < this.end) {
            char[] val = this.buffer;
            for (int i = this.start; i < this.end; ++i) {
                h = 31 * h + val[i];
            }
        }
        return h;
    }

    @Override
    public String toString() {
        return String.valueOf(this.buffer, this.start, this.end - this.start);
    }
}

