/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.crypto.NativeCodeLoader;
import org.apache.commons.crypto.OpenSslInfoNative;
import org.apache.commons.crypto.cipher.CryptoCipherFactory;
import org.apache.commons.crypto.random.CryptoRandomFactory;

public final class Crypto {
    public static final String CONF_PREFIX = "commons.crypto.";
    public static final String LIB_PATH_KEY = "commons.crypto.lib.path";
    public static final String LIB_NAME_KEY = "commons.crypto.lib.name";
    public static final String LIB_TEMPDIR_KEY = "commons.crypto.lib.tempdir";

    public static boolean isNativeCodeLoaded() {
        return NativeCodeLoader.isNativeCodeLoaded();
    }

    public static Throwable getLoadingError() {
        return NativeCodeLoader.getLoadingError();
    }

    public static String getComponentVersion() {
        return ComponentPropertiesHolder.PROPERTIES.getProperty("VERSION");
    }

    public static String getComponentName() {
        return ComponentPropertiesHolder.PROPERTIES.getProperty("NAME");
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Crypto.getComponentName() + " " + Crypto.getComponentVersion());
        if (Crypto.isNativeCodeLoaded()) {
            System.out.println("Native code loaded OK " + OpenSslInfoNative.NativeVersion());
            System.out.println("Native Name " + OpenSslInfoNative.NativeName());
            System.out.println("Native Built " + OpenSslInfoNative.NativeTimeStamp());
            System.out.println("OpenSSL library loaded OK, version: 0x" + Long.toHexString(OpenSslInfoNative.SSLeay()));
            System.out.println(OpenSslInfoNative.SSLeayVersion(0));
            Properties props = new Properties();
            props.setProperty("commons.crypto.secure.random.classes", CryptoRandomFactory.RandomProvider.OPENSSL.getClassName());
            CryptoRandomFactory.getCryptoRandom(props);
            System.out.println("Random instance created OK");
            props = new Properties();
            props.setProperty("commons.crypto.cipher.classes", CryptoCipherFactory.CipherProvider.OPENSSL.getClassName());
            CryptoCipherFactory.getCryptoCipher("AES/CTR/NoPadding", props);
            System.out.println("Cipher instance created OK");
            System.out.println("Additional SSLeay_version(n) details:");
            for (int j = 1; j < 6; ++j) {
                System.out.println(j + ": " + OpenSslInfoNative.SSLeayVersion(j));
            }
        } else {
            System.out.println("Native load failed: " + Crypto.getLoadingError());
        }
    }

    private static class ComponentPropertiesHolder {
        static final Properties PROPERTIES = ComponentPropertiesHolder.getComponentProperties();

        private ComponentPropertiesHolder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Properties getComponentProperties() {
            URL url = Crypto.class.getResource("/org/apache/commons/crypto/component.properties");
            if (url == null) return new Properties();
            Properties versionData = new Properties();
            try (InputStream openStream = url.openStream();){
                versionData.load(openStream);
                Properties properties = versionData;
                return properties;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new Properties();
        }
    }
}

