/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.bag;

import java.io.Externalizable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.bag.AbstractMutableBagMultimap;
import org.eclipse.collections.impl.utility.Iterate;

public final class HashBagMultimap<K, V>
extends AbstractMutableBagMultimap<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;

    public HashBagMultimap() {
    }

    public HashBagMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Math.max(multimap.keysView().size() * 2, 16));
        this.putAll(multimap);
    }

    public HashBagMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    public HashBagMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new HashBagMultimap<K, V>(multimap);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap() {
        return new HashBagMultimap<K, V>();
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new HashBagMultimap<K, V>(pairs);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new HashBagMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableMap<K, MutableBag<V>> createMap() {
        return Maps.mutable.empty();
    }

    @Override
    protected MutableMap<K, MutableBag<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected MutableBag<V> createCollection() {
        return HashBag.newBag();
    }

    public HashBagMultimap<K, V> newEmpty() {
        return new HashBagMultimap<K, V>();
    }

    public MutableBagMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    public <V2> HashBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, HashBagMultimap.newMultimap());
    }

    public HashBagMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (HashBagMultimap)this.selectKeysValues(predicate, this.newEmpty());
    }

    public HashBagMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (HashBagMultimap)this.rejectKeysValues(predicate, this.newEmpty());
    }

    public HashBagMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        return (HashBagMultimap)this.selectKeysMultiValues(predicate, this.newEmpty());
    }

    public HashBagMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        return (HashBagMultimap)this.rejectKeysMultiValues(predicate, this.newEmpty());
    }
}

