/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Maps;
import com.lancedb.lance.namespace.model.CreateEmptyTableRequest;
import com.lancedb.lance.namespace.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DeregisterTableRequest;
import com.lancedb.lance.namespace.model.DeregisterTableResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.RegisterTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableResponse;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.gravitino.lance.common.ops.NamespaceWrapper;
import org.apache.gravitino.lance.common.utils.SerializationUtils;
import org.apache.gravitino.lance.service.LanceExceptionMapper;

@Path(value="/v1/table/{id}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LanceTableOperations {
    private final NamespaceWrapper lanceNamespace;

    @Inject
    public LanceTableOperations(NamespaceWrapper lanceNamespace) {
        this.lanceNamespace = lanceNamespace;
    }

    @POST
    @Path(value="/describe")
    @Timed(name="describe-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="describe-table", absolute=true)
    public Response describeTable(@PathParam(value="id") String tableId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter, DescribeTableRequest request) {
        try {
            this.validateDescribeTableRequest(request);
            DescribeTableResponse response = this.lanceNamespace.asTableOps().describeTable(tableId, delimiter, Optional.ofNullable(request.getVersion()));
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/vnd.apache.arrow.stream"})
    @Produces(value={"application/json"})
    @Timed(name="create-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-table", absolute=true)
    public Response createTable(@PathParam(value="id") String tableId, @QueryParam(value="mode") @DefaultValue(value="create") String mode, @QueryParam(value="delimiter") @DefaultValue(value="$") String delimiter, @Context HttpHeaders headers, byte[] arrowStreamBody) {
        try {
            MultivaluedMap headersMap = headers.getRequestHeaders();
            String tableLocation = (String)headersMap.getFirst((Object)"x-lance-table-location");
            String tableProperties = (String)headersMap.getFirst((Object)"x-lance-table-properties");
            CreateTableRequest.ModeEnum modeEnum = CreateTableRequest.ModeEnum.fromValue((String)mode);
            Map props = SerializationUtils.deserializeProperties((String)tableProperties);
            CreateTableResponse response = this.lanceNamespace.asTableOps().createTable(tableId, modeEnum, delimiter, tableLocation, props, arrowStreamBody);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    @POST
    @Path(value="/create-empty")
    @Produces(value={"application/json"})
    @Timed(name="create-empty-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-empty-table", absolute=true)
    public Response createEmptyTable(@PathParam(value="id") String tableId, @QueryParam(value="delimiter") @DefaultValue(value="$") String delimiter, CreateEmptyTableRequest request, @Context HttpHeaders headers) {
        try {
            this.validateCreateEmptyTableRequest(request);
            String tableLocation = request.getLocation();
            HashMap props = request.getProperties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)request.getProperties());
            CreateEmptyTableResponse response = this.lanceNamespace.asTableOps().createEmptyTable(tableId, delimiter, tableLocation, (Map)props);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    @POST
    @Path(value="/register")
    @Timed(name="register-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-table", absolute=true)
    public Response registerTable(@PathParam(value="id") String tableId, @QueryParam(value="delimiter") @DefaultValue(value="$") String delimiter, @Context HttpHeaders headers, RegisterTableRequest registerTableRequest) {
        try {
            this.validateRegisterTableRequest(registerTableRequest);
            HashMap props = registerTableRequest.getProperties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)registerTableRequest.getProperties());
            props.put("location", registerTableRequest.getLocation());
            props.put("lance.register", "true");
            RegisterTableRequest.ModeEnum mode = registerTableRequest.getMode();
            RegisterTableResponse response = this.lanceNamespace.asTableOps().registerTable(tableId, mode, delimiter, (Map)props);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    @POST
    @Path(value="/deregister")
    @Timed(name="deregister-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="deregister-table", absolute=true)
    public Response deregisterTable(@PathParam(value="id") String tableId, @QueryParam(value="delimiter") @DefaultValue(value="$") String delimiter, @Context HttpHeaders headers, DeregisterTableRequest deregisterTableRequest) {
        try {
            this.validateDeregisterTableRequest(deregisterTableRequest);
            DeregisterTableResponse response = this.lanceNamespace.asTableOps().deregisterTable(tableId, delimiter);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    @POST
    @Path(value="/exists")
    @Timed(name="table-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="table-exists", absolute=true)
    public Response tableExists(@PathParam(value="id") String tableId, @QueryParam(value="delimiter") @DefaultValue(value="$") String delimiter, @Context HttpHeaders headers, TableExistsRequest tableExistsRequest) {
        try {
            this.validateTableExists(tableExistsRequest);
            boolean exists = this.lanceNamespace.asTableOps().tableExists(tableId, delimiter);
            if (exists) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    @POST
    @Path(value="/drop")
    @Timed(name="drop-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-table", absolute=true)
    public Response dropTable(@PathParam(value="id") String tableId, @QueryParam(value="delimiter") @DefaultValue(value="$") String delimiter, @Context HttpHeaders headers, DropTableRequest dropTableRequest) {
        try {
            this.validateDropTableRequest(dropTableRequest);
            DropTableResponse response = this.lanceNamespace.asTableOps().dropTable(tableId, delimiter);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(tableId, e);
        }
    }

    private void validateCreateEmptyTableRequest(CreateEmptyTableRequest request) {
    }

    private void validateRegisterTableRequest(RegisterTableRequest request) {
    }

    private void validateDeregisterTableRequest(DeregisterTableRequest request) {
    }

    private void validateDescribeTableRequest(DescribeTableRequest request) {
    }

    private void validateTableExists(TableExistsRequest request) {
    }

    private void validateDropTableRequest(DropTableRequest request) {
    }
}

