/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionBase;
import org.apache.flink.table.runtime.util.StateConfigUtil;

abstract class SyncStateDeduplicateFunctionBase<T, K, IN, OUT>
extends DeduplicateFunctionBase<T, K, IN, OUT> {
    private static final long serialVersionUID = 1L;
    protected ValueState<T> state;

    public SyncStateDeduplicateFunctionBase(TypeInformation<T> typeInfo, TypeSerializer<OUT> serializer, long stateRetentionTime) {
        super(typeInfo, serializer, stateRetentionTime);
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("deduplicate-state", this.typeInfo);
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(this.stateRetentionTime);
        if (ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(ttlConfig);
        }
        this.state = this.getRuntimeContext().getState(stateDesc);
    }
}

