package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.DeletePaymentTypesPaymentTypeIdResponse;
import org.apache.fineract.client.models.PaymentTypeData;
import org.apache.fineract.client.models.PaymentTypeRequest;
import org.apache.fineract.client.models.PostPaymentTypesResponse;
import org.apache.fineract.client.models.PutPaymentTypesPaymentTypeIdRequest;
import org.apache.fineract.client.models.PutPaymentTypesPaymentTypeIdResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface PaymentTypeApi {
    /**
    * Create a Payment Type
    * Creates a new Payment type  Mandatory Fields: name  Optional Fields: Description, isCashPayment,Position
        * @param paymentTypeRequest  (required)
    * @return Call&lt;PostPaymentTypesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/paymenttypes")
    Call<PostPaymentTypesResponse> createPaymentType(@retrofit2.http.Body PaymentTypeRequest paymentTypeRequest);

    /**
    * Delete a Payment Type
    * Deletes payment type
        * @param paymentTypeId paymentTypeId (required)
    * @return Call&lt;DeletePaymentTypesPaymentTypeIdResponse&gt;
    */
    @DELETE("v1/paymenttypes/{paymentTypeId}")
    Call<DeletePaymentTypesPaymentTypeIdResponse> deleteCode1(@retrofit2.http.Path("paymentTypeId") Long paymentTypeId);

    /**
    * Retrieve all Payment Types
    * Retrieve list of payment types
        * @param onlyWithCode onlyWithCode (optional)
    * @return Call&lt;List&lt;PaymentTypeData&gt;&gt;
    */
    @GET("v1/paymenttypes")
    Call<List<PaymentTypeData>> getAllPaymentTypes(@retrofit2.http.Query("onlyWithCode") Boolean onlyWithCode);

    /**
    * Retrieve a Payment Type
    * Retrieves a payment type
        * @param paymentTypeId paymentTypeId (required)
    * @return Call&lt;PaymentTypeData&gt;
    */
    @GET("v1/paymenttypes/{paymentTypeId}")
    Call<PaymentTypeData> retrieveOnePaymentType(@retrofit2.http.Path("paymentTypeId") Long paymentTypeId);

    /**
    * Update a Payment Type
    * Updates a Payment Type
        * @param paymentTypeId paymentTypeId (required)
        * @param putPaymentTypesPaymentTypeIdRequest  (required)
    * @return Call&lt;PutPaymentTypesPaymentTypeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/paymenttypes/{paymentTypeId}")
    Call<PutPaymentTypesPaymentTypeIdResponse> updatePaymentType(@retrofit2.http.Path("paymentTypeId") Long paymentTypeId, @retrofit2.http.Body PutPaymentTypesPaymentTypeIdRequest putPaymentTypesPaymentTypeIdRequest);



        /**
        * Create a Payment Type
        * Creates a new Payment type  Mandatory Fields: name  Optional Fields: Description, isCashPayment,Position
            * @param paymentTypeRequest  (required)
        * @return Call&lt;PostPaymentTypesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/paymenttypes")
    Call<PostPaymentTypesResponse> createPaymentType(@retrofit2.http.Body PaymentTypeRequest paymentTypeRequest, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Payment Type
        * Deletes payment type
            * @param paymentTypeId paymentTypeId (required)
        * @return Call&lt;DeletePaymentTypesPaymentTypeIdResponse&gt;
        */
    @DELETE("v1/paymenttypes/{paymentTypeId}")
    Call<DeletePaymentTypesPaymentTypeIdResponse> deleteCode1(@retrofit2.http.Path("paymentTypeId") Long paymentTypeId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve all Payment Types
        * Retrieve list of payment types
            * @param onlyWithCode onlyWithCode (optional)
        * @return Call&lt;List&lt;PaymentTypeData&gt;&gt;
        */
    @GET("v1/paymenttypes")
    Call<List<PaymentTypeData>> getAllPaymentTypes(@retrofit2.http.Query("onlyWithCode") Boolean onlyWithCode, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Payment Type
        * Retrieves a payment type
            * @param paymentTypeId paymentTypeId (required)
        * @return Call&lt;PaymentTypeData&gt;
        */
    @GET("v1/paymenttypes/{paymentTypeId}")
    Call<PaymentTypeData> retrieveOnePaymentType(@retrofit2.http.Path("paymentTypeId") Long paymentTypeId, @HeaderMap Map<String, String> headers);

        /**
        * Update a Payment Type
        * Updates a Payment Type
            * @param paymentTypeId paymentTypeId (required)
            * @param putPaymentTypesPaymentTypeIdRequest  (required)
        * @return Call&lt;PutPaymentTypesPaymentTypeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/paymenttypes/{paymentTypeId}")
    Call<PutPaymentTypesPaymentTypeIdResponse> updatePaymentType(@retrofit2.http.Path("paymentTypeId") Long paymentTypeId, @retrofit2.http.Body PutPaymentTypesPaymentTypeIdRequest putPaymentTypesPaymentTypeIdRequest, @HeaderMap Map<String, String> headers);


}
