package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CommandProcessingResult;
import org.apache.fineract.client.models.InterestPauseRequestDto;
import org.apache.fineract.client.models.InterestPauseResponseDto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanInterestPauseApi {
    /**
    * Create a new interest pause period for a loan
    * Allows users to define a period during which no interest will be accrued for a specific loan.
        * @param loanId loanId (required)
        * @param interestPauseRequestDto  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/interest-pauses")
    Call<CommandProcessingResult> createInterestPause(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto);

    /**
    * Create a new interest pause for a loan using external ID
    * Allows users to define a period during which no interest will be accrued for a specific loan using the external loan ID.
        * @param loanExternalId loanExternalId (required)
        * @param interestPauseRequestDto  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/interest-pauses")
    Call<CommandProcessingResult> createInterestPauseByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto);

    /**
    * Delete an interest pause period
    * Deletes a specific interest pause period by its variation ID.
        * @param loanId loanId (required)
        * @param variationId variationId (required)
    * @return Call&lt;Void&gt;
    */
    @DELETE("v1/loans/{loanId}/interest-pauses/{variationId}")
    Call<Void> deleteInterestPause(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("variationId") Long variationId);

    /**
    * Delete an interest pause period by external id
    * Deletes a specific interest pause period by its variation ID.
        * @param loanExternalId loanExternalId (required)
        * @param variationId variationId (required)
    * @return Call&lt;Void&gt;
    */
    @DELETE("v1/loans/external-id/{loanExternalId}/interest-pauses/{variationId}")
    Call<Void> deleteInterestPauseByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("variationId") Long variationId);

    /**
    * Retrieve all interest pause periods for a loan
    * Fetches a list of all active interest pause periods for a specific loan.
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;InterestPauseResponseDto&gt;&gt;
    */
    @GET("v1/loans/{loanId}/interest-pauses")
    Call<List<InterestPauseResponseDto>> retrieveInterestPauses(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Retrieve all interest pause periods for a loan using external ID
    * Fetches a list of all active interest pause periods for a specific loan using the external loan ID.
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;InterestPauseResponseDto&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/interest-pauses")
    Call<List<InterestPauseResponseDto>> retrieveInterestPausesByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Update an interest pause period
    * Updates a specific interest pause period by its variation ID.
        * @param loanId loanId (required)
        * @param variationId variationId (required)
        * @param interestPauseRequestDto  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/interest-pauses/{variationId}")
    Call<CommandProcessingResult> updateInterestPause(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("variationId") Long variationId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto);

    /**
    * Update an interest pause period by external id
    * Updates a specific interest pause period by its variation ID.
        * @param loanExternalId loanExternalId (required)
        * @param variationId variationId (required)
        * @param interestPauseRequestDto  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/interest-pauses/{variationId}")
    Call<CommandProcessingResult> updateInterestPauseByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("variationId") Long variationId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto);



        /**
        * Create a new interest pause period for a loan
        * Allows users to define a period during which no interest will be accrued for a specific loan.
            * @param loanId loanId (required)
            * @param interestPauseRequestDto  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/interest-pauses")
    Call<CommandProcessingResult> createInterestPause(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto, @HeaderMap Map<String, String> headers);

        /**
        * Create a new interest pause for a loan using external ID
        * Allows users to define a period during which no interest will be accrued for a specific loan using the external loan ID.
            * @param loanExternalId loanExternalId (required)
            * @param interestPauseRequestDto  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/interest-pauses")
    Call<CommandProcessingResult> createInterestPauseByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto, @HeaderMap Map<String, String> headers);

        /**
        * Delete an interest pause period
        * Deletes a specific interest pause period by its variation ID.
            * @param loanId loanId (required)
            * @param variationId variationId (required)
        * @return Call&lt;Void&gt;
        */
    @DELETE("v1/loans/{loanId}/interest-pauses/{variationId}")
    Call<Void> deleteInterestPause(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("variationId") Long variationId, @HeaderMap Map<String, String> headers);

        /**
        * Delete an interest pause period by external id
        * Deletes a specific interest pause period by its variation ID.
            * @param loanExternalId loanExternalId (required)
            * @param variationId variationId (required)
        * @return Call&lt;Void&gt;
        */
    @DELETE("v1/loans/external-id/{loanExternalId}/interest-pauses/{variationId}")
    Call<Void> deleteInterestPauseByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("variationId") Long variationId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve all interest pause periods for a loan
        * Fetches a list of all active interest pause periods for a specific loan.
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;InterestPauseResponseDto&gt;&gt;
        */
    @GET("v1/loans/{loanId}/interest-pauses")
    Call<List<InterestPauseResponseDto>> retrieveInterestPauses(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve all interest pause periods for a loan using external ID
        * Fetches a list of all active interest pause periods for a specific loan using the external loan ID.
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;InterestPauseResponseDto&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/interest-pauses")
    Call<List<InterestPauseResponseDto>> retrieveInterestPausesByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Update an interest pause period
        * Updates a specific interest pause period by its variation ID.
            * @param loanId loanId (required)
            * @param variationId variationId (required)
            * @param interestPauseRequestDto  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/interest-pauses/{variationId}")
    Call<CommandProcessingResult> updateInterestPause(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("variationId") Long variationId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto, @HeaderMap Map<String, String> headers);

        /**
        * Update an interest pause period by external id
        * Updates a specific interest pause period by its variation ID.
            * @param loanExternalId loanExternalId (required)
            * @param variationId variationId (required)
            * @param interestPauseRequestDto  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/interest-pauses/{variationId}")
    Call<CommandProcessingResult> updateInterestPauseByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("variationId") Long variationId, @retrofit2.http.Body InterestPauseRequestDto interestPauseRequestDto, @HeaderMap Map<String, String> headers);


}
