/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.transfer.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TransfersDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> TRANSFER_CLIENTS_BETWEEN_GROUPS_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "destinationGroupId", "clients", "inheritDestinationGroupLoanOfficer", "staffId", "transferActiveLoans"));
    private static final Set<String> PROPOSE_CLIENT_TRANSFER_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "destinationOfficeId", "transferActiveLoans", "note", "transferDate"));
    private static final Set<String> ACCEPT_CLIENT_TRANSFER_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("staffId", "destinationGroupId", "note"));
    private static final Set<String> PROPOSE_AND_ACCEPT_CLIENT_TRANSFER_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "destinationOfficeId", "transferActiveLoans", "staffId", "destinationGroupId", "note"));
    private static final Set<String> REJECT_CLIENT_TRANSFER_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("note"));
    private static final Set<String> WITHDRAW_CLIENT_TRANSFER_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("note"));

    @Autowired
    public TransfersDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForClientsTransferBetweenGroups(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)TRANSFER_CLIENTS_BETWEEN_GROUPS_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("group");
        Long destinationGroupId = this.fromApiJsonHelper.extractLongNamed("destinationGroupId", element);
        baseDataValidator.reset().parameter("destinationGroupId").value((Object)destinationGroupId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long newStaffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)newStaffId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("inheritDestinationGroupLoanOfficer", element)) {
            Boolean inheritDestinationGroupLoanOfficer = this.fromApiJsonHelper.extractBooleanNamed("inheritDestinationGroupLoanOfficer", element);
            baseDataValidator.reset().parameter("inheritDestinationGroupLoanOfficer").value((Object)inheritDestinationGroupLoanOfficer).notNull();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForProposeClientTransfer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)PROPOSE_CLIENT_TRANSFER_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        Long destinationOfficeId = this.fromApiJsonHelper.extractLongNamed("destinationOfficeId", element);
        baseDataValidator.reset().parameter("destinationOfficeId").value((Object)destinationOfficeId).notNull().integerGreaterThanZero();
        this.validateNote(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForAcceptClientTransfer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ACCEPT_CLIENT_TRANSFER_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long newStaffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)newStaffId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("destinationGroupId", element)) {
            Long destinationGroupId = this.fromApiJsonHelper.extractLongNamed("destinationGroupId", element);
            baseDataValidator.reset().parameter("destinationGroupId").value((Object)destinationGroupId).notNull().integerGreaterThanZero();
        }
        this.validateNote(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForProposeAndAcceptClientTransfer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)PROPOSE_AND_ACCEPT_CLIENT_TRANSFER_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Long destinationOfficeId = this.fromApiJsonHelper.extractLongNamed("destinationOfficeId", element);
        baseDataValidator.reset().parameter("destinationOfficeId").value((Object)destinationOfficeId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long newStaffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)newStaffId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("destinationGroupId", element)) {
            Long destinationGroupId = this.fromApiJsonHelper.extractLongNamed("destinationGroupId", element);
            baseDataValidator.reset().parameter("destinationGroupId").value((Object)destinationGroupId).notNull().integerGreaterThanZero();
        }
        this.validateNote(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForRejectClientTransfer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)REJECT_CLIENT_TRANSFER_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateNote(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForWithdrawClientTransfer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)WITHDRAW_CLIENT_TRANSFER_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateNote(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateNote(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
    }
}

