/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.tax.api.TaxComponentApiResourceSwagger;
import org.apache.fineract.portfolio.tax.data.TaxComponentData;
import org.apache.fineract.portfolio.tax.request.TaxComponentRequest;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/taxes/component")
@Component
@Tag(name="Tax Components", description="This defines the Tax Components")
public class TaxComponentApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "TAXCOMPONENT";
    private final PlatformSecurityContext context;
    private final TaxReadPlatformService readPlatformService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final DefaultToApiJsonSerializer<String> toApiJsonSerializer;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Tax Components", description="List Tax Components")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TaxComponentApiResourceSwagger.GetTaxesComponentsResponse.class)))})})
    public List<TaxComponentData> retrieveAllTaxComponents() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveAllTaxComponents();
    }

    @GET
    @Path(value="{taxComponentId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Tax Component", description="Retrieve Tax Component")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TaxComponentApiResourceSwagger.GetTaxesComponentsResponse.class))})})
    public TaxComponentData retrieveTaxComponent(@PathParam(value="taxComponentId") @Parameter(description="taxComponentId") Long taxComponentId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveTaxComponentData(taxComponentId);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TaxComponentData retrieveTemplate() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveTaxComponentTemplate();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new Tax Component", description="Creates a new Tax Component\n\nMandatory Fields: name, percentage\n\nOptional Fields: debitAccountType, debitAcountId, creditAccountType, creditAcountId, startDate")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=TaxComponentApiResourceSwagger.PostTaxesComponentsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TaxComponentApiResourceSwagger.PostTaxesComponentsResponse.class))})})
    public CommandProcessingResult createTaxComponent(@Parameter(hidden=true) TaxComponentRequest taxComponentRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createTaxComponent().withJson(this.toApiJsonSerializer.serialize((Object)taxComponentRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @PUT
    @Path(value="{taxComponentId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Tax Component", description="Updates Tax component. Debit and credit account details cannot be modified. All the future tax components would be replaced with the new percentage.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=TaxComponentApiResourceSwagger.PutTaxesComponentsTaxComponentIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TaxComponentApiResourceSwagger.PutTaxesComponentsTaxComponentIdResponse.class))})})
    public CommandProcessingResult updateTaxCompoent(@PathParam(value="taxComponentId") @Parameter(description="taxComponentId") Long taxComponentId, @Parameter(hidden=true) TaxComponentRequest taxComponentRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateTaxComponent(taxComponentId).withJson(this.toApiJsonSerializer.serialize((Object)taxComponentRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public TaxComponentApiResource(PlatformSecurityContext context, TaxReadPlatformService readPlatformService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, DefaultToApiJsonSerializer<String> toApiJsonSerializer) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

