/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.shareaccounts.data;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SelfShareAccountsDataValidator {
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public SelfShareAccountsDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public HashMap<String, Object> validateShareAccountApplication(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("share");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String clientId = this.fromApiJsonHelper.extractStringNamed("clientId", element);
        baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        HashMap<String, Object> retAttr = new HashMap<String, Object>();
        retAttr.put("clientId", Long.parseLong(clientId));
        return retAttr;
    }
}

