/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.domain;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.portfolio.self.pockets.domain.PocketAccountMapping;
import org.apache.fineract.portfolio.self.pockets.domain.PocketAccountMappingRepository;
import org.apache.fineract.portfolio.self.pockets.exception.MappingIdNotLinkedToPocketException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PocketAccountMappingRepositoryWrapper {
    private final PocketAccountMappingRepository pocketAccountMappingRepository;

    @Autowired
    public PocketAccountMappingRepositoryWrapper(PocketAccountMappingRepository pocketAccountMappingRepository) {
        this.pocketAccountMappingRepository = pocketAccountMappingRepository;
    }

    public void save(PocketAccountMapping pocketAccountMapping) {
        this.pocketAccountMappingRepository.save((Object)pocketAccountMapping);
    }

    public List<PocketAccountMapping> save(List<PocketAccountMapping> pocketAccountsList) {
        return this.pocketAccountMappingRepository.saveAll(pocketAccountsList);
    }

    public void delete(List<PocketAccountMapping> pocketAccountsList) {
        this.pocketAccountMappingRepository.deleteAll(pocketAccountsList);
    }

    public PocketAccountMapping findByIdAndPocketIdWithNotFoundException(Long id, Long pocketId) {
        PocketAccountMapping pocketAccountMapping = this.pocketAccountMappingRepository.findByIdAndPocketId(id, pocketId);
        if (pocketAccountMapping == null) {
            throw new MappingIdNotLinkedToPocketException(id);
        }
        return pocketAccountMapping;
    }

    public Collection<PocketAccountMapping> findByPocketId(Long pocketId) {
        return this.pocketAccountMappingRepository.findByPocketId(pocketId);
    }
}

