/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.updatedepositsaccountmaturitydetails;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.DepositAccountData;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class UpdateDepositsAccountMaturityDetailsTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateDepositsAccountMaturityDetailsTasklet.class);
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final DepositAccountWritePlatformService depositAccountWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection depositAccounts = this.depositAccountReadPlatformService.retrieveForMaturityUpdate();
        for (DepositAccountData depositAccount : depositAccounts) {
            try {
                DepositAccountType depositAccountType = DepositAccountType.fromInt((Integer)((Long)depositAccount.getDepositType().getId()).intValue());
                this.depositAccountWritePlatformService.updateMaturityDetails(depositAccount.getId(), depositAccountType);
            }
            catch (PlatformApiDataValidationException e) {
                List errors = e.getErrors();
                for (ApiParameterError error : errors) {
                    log.error("Update maturity details failed for account: {} with message {}", (Object)depositAccount.getAccountNo(), (Object)error.getDeveloperMessage());
                }
            }
            catch (Exception ex) {
                log.error("Update maturity details failed for account: {}", (Object)depositAccount.getAccountNo(), (Object)ex);
            }
        }
        log.debug("{}: Records affected by updateMaturityDetailsOfDepositAccounts: {}", (Object)ThreadLocalContextUtil.getTenant().getName(), (Object)depositAccounts.size());
        return RepeatStatus.FINISHED;
    }

    @Generated
    public UpdateDepositsAccountMaturityDetailsTasklet(DepositAccountReadPlatformService depositAccountReadPlatformService, DepositAccountWritePlatformService depositAccountWritePlatformService) {
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.depositAccountWritePlatformService = depositAccountWritePlatformService;
    }
}

