/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.domain.LocalDateInterval;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChart;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositAccountUtils;
import org.apache.fineract.portfolio.savings.PreClosurePenalInterestOnType;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPeriodFrequencyType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionDTO;
import org.apache.fineract.portfolio.savings.domain.DepositAccountInterestRateChart;
import org.apache.fineract.portfolio.savings.domain.DepositAccountRecurringDetail;
import org.apache.fineract.portfolio.savings.domain.DepositAccountTermAndPreClosure;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositScheduleInstallment;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountCharge;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionComparator;
import org.apache.fineract.portfolio.savings.domain.SavingsEvent;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.domain.interest.PostingPeriod;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@DiscriminatorValue(value="300")
public class RecurringDepositAccount
extends SavingsAccount
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OneToOne(mappedBy="account", cascade={CascadeType.ALL})
    private DepositAccountTermAndPreClosure accountTermAndPreClosure;
    @OneToOne(mappedBy="account", cascade={CascadeType.ALL})
    private DepositAccountRecurringDetail recurringDetail;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="account")
    private DepositAccountInterestRateChart chart;
    @OrderBy(value="installmentNumber, id")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="account", orphanRemoval=true, fetch=FetchType.LAZY)
    private List<RecurringDepositScheduleInstallment> depositScheduleInstallments = new ArrayList();
    static final long serialVersionUID = -6608625645981411358L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_chart_vh;

    protected RecurringDepositAccount() {
    }

    public static RecurringDepositAccount createNewApplicationForSubmittal(Client client, Group group, SavingsProduct product, Staff fieldOfficer, String accountNo, ExternalId externalId, AccountType accountType, LocalDate submittedOnDate, AppUser submittedBy, BigDecimal interestRate, SavingsCompoundingInterestPeriodType interestCompoundingPeriodType, SavingsPostingInterestPeriodType interestPostingPeriodType, SavingsInterestCalculationType interestCalculationType, SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType, BigDecimal minRequiredOpeningBalance, Integer lockinPeriodFrequency, SavingsPeriodFrequencyType lockinPeriodFrequencyType, boolean withdrawalFeeApplicableForTransfer, Set<SavingsAccountCharge> savingsAccountCharges, DepositAccountTermAndPreClosure accountTermAndPreClosure, DepositAccountRecurringDetail recurringDetail, DepositAccountInterestRateChart chart, boolean withHoldTax) {
        boolean allowOverdraft = false;
        BigDecimal overdraftLimit = new BigDecimal(0);
        SavingsAccountStatusType status = SavingsAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL;
        return new RecurringDepositAccount(client, group, product, fieldOfficer, accountNo, externalId, status, accountType, submittedOnDate, submittedBy, interestRate, interestCompoundingPeriodType, interestPostingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeApplicableForTransfer, savingsAccountCharges, accountTermAndPreClosure, recurringDetail, chart, false, overdraftLimit, withHoldTax);
    }

    public static RecurringDepositAccount createNewActivatedAccount(Client client, Group group, SavingsProduct product, Staff fieldOfficer, String accountNo, ExternalId externalId, AccountType accountType, LocalDate submittedOnDate, AppUser submittedBy, BigDecimal interestRate, SavingsCompoundingInterestPeriodType interestCompoundingPeriodType, SavingsPostingInterestPeriodType interestPostingPeriodType, SavingsInterestCalculationType interestCalculationType, SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType, BigDecimal minRequiredOpeningBalance, Integer lockinPeriodFrequency, SavingsPeriodFrequencyType lockinPeriodFrequencyType, boolean withdrawalFeeApplicableForTransfer, Set<SavingsAccountCharge> savingsAccountCharges, DepositAccountTermAndPreClosure accountTermAndPreClosure, DepositAccountRecurringDetail recurringDetail, DepositAccountInterestRateChart chart, boolean withHoldTax) {
        boolean allowOverdraft = false;
        BigDecimal overdraftLimit = new BigDecimal(0);
        SavingsAccountStatusType status = SavingsAccountStatusType.ACTIVE;
        return new RecurringDepositAccount(client, group, product, fieldOfficer, accountNo, externalId, status, accountType, submittedOnDate, submittedBy, interestRate, interestCompoundingPeriodType, interestPostingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeApplicableForTransfer, savingsAccountCharges, accountTermAndPreClosure, recurringDetail, chart, false, overdraftLimit, withHoldTax);
    }

    private RecurringDepositAccount(Client client, Group group, SavingsProduct product, Staff fieldOfficer, String accountNo, ExternalId externalId, SavingsAccountStatusType status, AccountType accountType, LocalDate submittedOnDate, AppUser submittedBy, BigDecimal nominalAnnualInterestRate, SavingsCompoundingInterestPeriodType interestCompoundingPeriodType, SavingsPostingInterestPeriodType interestPostingPeriodType, SavingsInterestCalculationType interestCalculationType, SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType, BigDecimal minRequiredOpeningBalance, Integer lockinPeriodFrequency, SavingsPeriodFrequencyType lockinPeriodFrequencyType, boolean withdrawalFeeApplicableForTransfer, Set<SavingsAccountCharge> savingsAccountCharges, DepositAccountTermAndPreClosure accountTermAndPreClosure, DepositAccountRecurringDetail recurringDetail, DepositAccountInterestRateChart chart, boolean allowOverdraft, BigDecimal overdraftLimit, boolean withHoldTax) {
        super(client, group, product, fieldOfficer, accountNo, externalId, status, accountType, submittedOnDate, submittedBy, nominalAnnualInterestRate, interestCompoundingPeriodType, interestPostingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeApplicableForTransfer, savingsAccountCharges, allowOverdraft, overdraftLimit, withHoldTax);
        this.accountTermAndPreClosure = accountTermAndPreClosure;
        this.recurringDetail = recurringDetail;
        this.chart = chart;
        if (this.chart != null) {
            this.chart.updateDepositAccountReference((SavingsAccount)this);
        }
    }

    public void modifyApplication(JsonCommand command, Map<String, Object> actualChanges) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount.modify");
        super.modifyApplication(command, actualChanges, baseDataValidator);
        Map termAndPreClosureChanges = this._persistence_get_accountTermAndPreClosure().update(command, baseDataValidator);
        actualChanges.putAll(termAndPreClosureChanges);
        this._persistence_get_recurringDetail().update(command);
        this.validateDomainRules(baseDataValidator);
        super.validateInterestPostingAndCompoundingPeriodTypes(baseDataValidator);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void updateDepositAmount() {
        BigDecimal recurringAmount = this.getRecurringDetail().mandatoryRecommendedDepositAmount();
        Integer numberOfDepositPeriods = this.depositScheduleInstallments().size();
        if (this._persistence_get_accountTermAndPreClosure().depositPeriod() != null && recurringAmount != null && numberOfDepositPeriods != null) {
            BigDecimal depositAmount = Money.of((MonetaryCurrency)this._persistence_get_product().currency(), (BigDecimal)recurringAmount).multipliedBy((long)numberOfDepositPeriods.intValue()).plus(this._persistence_get_minRequiredOpeningBalance()).getAmount();
            this._persistence_get_accountTermAndPreClosure().updateDepositAmount(depositAmount);
        } else if (this._persistence_get_accountTermAndPreClosure().depositAmount() == null) {
            this._persistence_get_accountTermAndPreClosure().updateDepositAmount(Money.zero((MonetaryCurrency)this._persistence_get_product().currency()).getAmount());
        }
    }

    public void updateDepositAmount(BigDecimal depositAmount) {
        if (this._persistence_get_accountTermAndPreClosure().depositPeriod() == null) {
            this._persistence_get_accountTermAndPreClosure().updateDepositAmount(this._persistence_get_accountTermAndPreClosure().depositAmount().add(depositAmount));
        }
    }

    protected BigDecimal getEffectiveInterestRateAsFraction(MathContext mc, LocalDate interestPostingUpToDate) {
        boolean isPreMatureClosure = false;
        return this.getEffectiveInterestRateAsFraction(mc, interestPostingUpToDate, isPreMatureClosure);
    }

    protected BigDecimal getEffectiveInterestRateAsFraction(MathContext mc, LocalDate interestPostingUpToDate, boolean isPreMatureClosure) {
        boolean applyPreMaturePenalty = false;
        BigDecimal penalInterest = BigDecimal.ZERO;
        LocalDate depositCloseDate = this.calculateMaturityDate();
        if (isPreMatureClosure && this._persistence_get_accountTermAndPreClosure().isPreClosurePenalApplicable()) {
            applyPreMaturePenalty = true;
            penalInterest = this._persistence_get_accountTermAndPreClosure().depositPreClosureDetail().preClosurePenalInterest();
            PreClosurePenalInterestOnType preClosurePenalInterestOnType = this._persistence_get_accountTermAndPreClosure().depositPreClosureDetail().preClosurePenalInterestOnType();
            if (preClosurePenalInterestOnType.isWholeTerm()) {
                depositCloseDate = this.interestCalculatedUpto();
            } else if (preClosurePenalInterestOnType.isTillPrematureWithdrawal()) {
                depositCloseDate = interestPostingUpToDate;
            }
        }
        if (depositCloseDate == null) {
            depositCloseDate = DateUtils.getBusinessLocalDate();
        }
        BigDecimal depositAmount = this._persistence_get_accountTermAndPreClosure().depositAmount();
        BigDecimal applicableInterestRate = this._persistence_get_chart().getApplicableInterestRate(depositAmount, this.depositStartDate(), depositCloseDate, this._persistence_get_client());
        if (applyPreMaturePenalty) {
            applicableInterestRate = (applicableInterestRate = applicableInterestRate.subtract(penalInterest)).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : applicableInterestRate;
        }
        this._persistence_set_nominalAnnualInterestRate(applicableInterestRate);
        return applicableInterestRate.divide(BigDecimal.valueOf(100L), mc);
    }

    public void updateMaturityDateAndAmount(MathContext mc, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        LocalDate maturityDate = this.calculateMaturityDate();
        LocalDate interestCalculationUpto = null;
        List allTransactions = null;
        if (maturityDate == null) {
            interestCalculationUpto = DateUtils.getBusinessLocalDate();
            allTransactions = this.getTransactions(interestCalculationUpto, false);
        } else {
            interestCalculationUpto = maturityDate.minusDays(1L);
            allTransactions = this.getTransactions(interestCalculationUpto, true);
        }
        List postingPeriods = this.calculateInterestPayable(mc, interestCalculationUpto, allTransactions, isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Money totalInterestPayable = Money.zero((MonetaryCurrency)this.getCurrency());
        Money totalDepositAmount = Money.zero((MonetaryCurrency)this.getCurrency());
        for (PostingPeriod postingPeriod : postingPeriods) {
            totalInterestPayable = totalInterestPayable.plus(postingPeriod.getInterestEarned());
            totalDepositAmount = totalDepositAmount.plus(postingPeriod.closingBalance()).minus(postingPeriod.openingBalance());
        }
        if (maturityDate == null) {
            this._persistence_get_accountTermAndPreClosure().updateDepositAmount(totalDepositAmount.getAmount());
        } else {
            this._persistence_get_accountTermAndPreClosure().updateMaturityDetails(totalDepositAmount.getAmount(), totalInterestPayable.getAmount(), maturityDate);
        }
    }

    public void updateMaturityStatus(boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, boolean postReversals) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount.updateMaturityDetails");
        SavingsAccountStatusType currentStatus = SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status());
        if (!SavingsAccountStatusType.ACTIVE.hasStateOf(currentStatus)) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("not.in.active.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        LocalDate todayDate = DateUtils.getBusinessLocalDate();
        if (!DateUtils.isAfter((LocalDate)this.maturityDate(), (LocalDate)todayDate)) {
            this._persistence_set_status(SavingsAccountStatusType.MATURED.getValue());
            this.postMaturityInterest(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, todayDate, postReversals);
        }
    }

    public LocalDate calculateMaturityDate() {
        LocalDate startDate = this.depositStartDate();
        LocalDate maturityDate = null;
        Integer depositPeriod = this._persistence_get_accountTermAndPreClosure().depositPeriod();
        if (depositPeriod == null) {
            return maturityDate;
        }
        switch (1.$SwitchMap$org$apache$fineract$portfolio$savings$SavingsPeriodFrequencyType[this._persistence_get_accountTermAndPreClosure().depositPeriodFrequencyType().ordinal()]) {
            case 1: {
                maturityDate = startDate.plusDays(depositPeriod.intValue());
                break;
            }
            case 2: {
                maturityDate = startDate.plusWeeks(depositPeriod.intValue());
                break;
            }
            case 3: {
                maturityDate = startDate.plusMonths(depositPeriod.intValue());
                break;
            }
            case 4: {
                maturityDate = startDate.plusYears(depositPeriod.intValue());
                break;
            }
        }
        return maturityDate;
    }

    private List<PostingPeriod> calculateInterestPayable(MathContext mc, LocalDate maturityDate, List<SavingsAccountTransaction> transactions, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        SavingsPostingInterestPeriodType postingPeriodType = SavingsPostingInterestPeriodType.fromInt((Integer)this._persistence_get_interestPostingPeriodType());
        SavingsCompoundingInterestPeriodType compoundingPeriodType = SavingsCompoundingInterestPeriodType.fromInt((Integer)this._persistence_get_interestCompoundingPeriodType());
        SavingsInterestCalculationDaysInYearType daysInYearType = SavingsInterestCalculationDaysInYearType.fromInt((Integer)this._persistence_get_interestCalculationDaysInYearType());
        List PostedAsOnDates = this.getManualPostingDates();
        List postingPeriodIntervals = this.savingsHelper.determineInterestPostingPeriods(this.depositStartDate(), maturityDate, postingPeriodType, financialYearBeginningMonth, PostedAsOnDates);
        ArrayList<PostingPeriod> allPostingPeriods = new ArrayList<PostingPeriod>();
        Money periodStartingBalance = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        SavingsInterestCalculationType interestCalculationType = SavingsInterestCalculationType.fromInt((Integer)this._persistence_get_interestCalculationType());
        BigDecimal interestRateAsFraction = this.getEffectiveInterestRateAsFraction(mc, maturityDate, isPreMatureClosure);
        Collection interestPostTransactions = this.savingsHelper.fetchPostInterestTransactionIds((Long)this.getId());
        boolean isInterestTransfer = false;
        Money minBalanceForInterestCalculation = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this.minBalanceForInterestCalculation());
        List savingsAccountTransactionDetailsForPostingPeriodList = this.toSavingsAccountTransactionDetailsForPostingPeriodList(transactions);
        for (LocalDateInterval periodInterval : postingPeriodIntervals) {
            boolean isUserPosting = false;
            if (PostedAsOnDates.contains(periodInterval.endDate())) {
                isUserPosting = true;
            }
            PostingPeriod postingPeriod = PostingPeriod.createFrom((LocalDateInterval)periodInterval, (Money)periodStartingBalance, (List)savingsAccountTransactionDetailsForPostingPeriodList, (MonetaryCurrency)this._persistence_get_currency(), (SavingsCompoundingInterestPeriodType)compoundingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (BigDecimal)interestRateAsFraction, (long)daysInYearType.getValue().intValue(), (LocalDate)maturityDate, (Collection)interestPostTransactions, (boolean)isInterestTransfer, (Money)minBalanceForInterestCalculation, (boolean)isSavingsInterestPostingAtCurrentPeriodEnd, (boolean)isUserPosting, (Integer)financialYearBeginningMonth);
            periodStartingBalance = postingPeriod.closingBalance();
            allPostingPeriods.add(postingPeriod);
        }
        this.savingsHelper.calculateInterestForAllPostingPeriods(this._persistence_get_currency(), allPostingPeriods, this.getLockedInUntilDate(), Boolean.valueOf(this.isTransferInterestToOtherAccount()));
        return allPostingPeriods;
    }

    /*
     * WARNING - void declaration
     */
    private List<SavingsAccountTransaction> getTransactions(LocalDate depositEndDate, boolean generateFutureTransactions) {
        SavingsAccountTransaction transaction;
        List<SavingsAccountTransaction> allTransactions = new ArrayList();
        allTransactions.addAll(this.retreiveOrderedNonInterestPostingTransactions());
        LocalDate latestTransactionDate = null;
        for (SavingsAccountTransaction savingsAccountTransaction : allTransactions) {
            if (latestTransactionDate != null && !DateUtils.isBefore((LocalDate)latestTransactionDate, (LocalDate)savingsAccountTransaction.getTransactionDate())) continue;
            latestTransactionDate = savingsAccountTransaction.getTransactionDate();
        }
        String refNo = null;
        if (generateFutureTransactions) {
            for (Object installment : this.depositScheduleInstallments()) {
                if (!installment.isPrincipalNotCompleted(this.getCurrency())) continue;
                LocalDate dueDate = installment.dueDate();
                if (DateUtils.isBefore((LocalDate)dueDate, (LocalDate)latestTransactionDate)) {
                    dueDate = latestTransactionDate;
                }
                transaction = SavingsAccountTransaction.deposit(null, (Office)this.office(), null, (LocalDate)dueDate, (Money)installment.getDepositAmountOutstanding(this.getCurrency()), refNo);
                allTransactions.add(transaction);
            }
        }
        allTransactions = this.sortTransactions(allTransactions);
        Money money = Money.zero((MonetaryCurrency)this.getCurrency());
        for (SavingsAccountTransaction transaction2 : allTransactions) {
            void var6_10;
            if (transaction2.isReversed()) {
                transaction2.zeroBalanceFields();
                continue;
            }
            Money transactionAmount = Money.zero((MonetaryCurrency)this._persistence_get_currency());
            if (transaction2.isCredit()) {
                transactionAmount = transactionAmount.plus(transaction2.getAmount(this._persistence_get_currency()));
            } else if (transaction2.isDebit()) {
                transactionAmount = transactionAmount.minus(transaction2.getAmount(this._persistence_get_currency()));
            }
            Money money2 = var6_10.plus(transactionAmount);
            transaction2.setRunningBalance(money2);
        }
        LocalDate endOfBalanceDate = depositEndDate;
        for (int i = allTransactions.size() - 1; i >= 0; --i) {
            transaction = allTransactions.get(i);
            if (!transaction.isNotReversed() || transaction.isInterestPostingAndNotReversed()) continue;
            transaction.updateCumulativeBalanceAndDates(this._persistence_get_currency(), endOfBalanceDate);
            endOfBalanceDate = transaction.getTransactionDate().minusDays(1L);
        }
        return allTransactions;
    }

    public LocalDate depositStartDate() {
        LocalDate depositStartDate = this._persistence_get_accountTermAndPreClosure().getExpectedFirstDepositOnDate();
        if (depositStartDate == null) {
            return this.accountSubmittedOrActivationDate();
        }
        return depositStartDate;
    }

    public void prematureClosure(AppUser currentUser, JsonCommand command, Map<String, Object> actualChanges) {
        SavingsAccountTransaction accountTransaction;
        List savingsAccountTransactions;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount.preMatureClose");
        SavingsAccountStatusType currentStatus = SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status());
        if (!SavingsAccountStatusType.ACTIVE.hasStateOf(currentStatus)) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("not.in.active.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        if (DateUtils.isBefore((LocalDate)closedDate, (LocalDate)this.getActivationDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.activation.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (this.isAccountLocked(closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.lockin.period", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (this.maturityDate() != null && DateUtils.isAfter((LocalDate)closedDate, (LocalDate)this.maturityDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.before.maturity.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (DateUtils.isAfterBusinessDate((LocalDate)closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("cannot.be.a.future.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (this.isAccountLocked(this.calculateMaturityDate())) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("deposit.period.must.be.greater.than.lock.in.period", new Object[]{"Deposit period must be greater than account lock-in period."});
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if ((savingsAccountTransactions = this.retrieveListOfTransactions()).size() > 0 && (accountTransaction = (SavingsAccountTransaction)savingsAccountTransactions.get(savingsAccountTransactions.size() - 1)).isAfter(closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.last.transaction.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        this.validateActivityNotBeforeClientOrGroupTransferDate(SavingsEvent.SAVINGS_CLOSE_ACCOUNT, closedDate);
        this._persistence_set_status(SavingsAccountStatusType.PRE_MATURE_CLOSURE.getValue());
        Integer onAccountClosureId = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        this._persistence_get_accountTermAndPreClosure().updateOnAccountClosureStatus(onClosureType);
        actualChanges.put("status", SavingsEnumerations.status((Integer)this._persistence_get_status()));
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("closedOnDate", closedDate.format(fmt));
        this._persistence_set_rejectedOnDate(null);
        this._persistence_set_rejectedBy(null);
        this._persistence_set_withdrawnOnDate(null);
        this._persistence_set_withdrawnBy(null);
        this._persistence_set_closedOnDate(closedDate);
        this._persistence_set_closedBy(currentUser);
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
    }

    public Money activateWithBalance() {
        return Money.of((MonetaryCurrency)this._persistence_get_currency(), (BigDecimal)this._persistence_get_minRequiredOpeningBalance());
    }

    protected void processAccountUponActivation(DateTimeFormatter fmt, boolean postReversals, Long relaxingDaysConfigForPivotDate) {
        Money minRequiredOpeningBalance = Money.of((MonetaryCurrency)this._persistence_get_currency(), (BigDecimal)this._persistence_get_minRequiredOpeningBalance());
        boolean backdatedTxnsAllowedTill = false;
        String refNo = null;
        if (minRequiredOpeningBalance.isGreaterThanZero()) {
            SavingsAccountTransactionDTO transactionDTO = new SavingsAccountTransactionDTO(fmt, this.getActivationDate(), minRequiredOpeningBalance.getAmount(), null, null, this._persistence_get_accountType());
            this.deposit(transactionDTO, false, relaxingDaysConfigForPivotDate, refNo);
            this.recalculateDailyBalances(Money.zero((MonetaryCurrency)this._persistence_get_currency()), DateUtils.getBusinessLocalDate(), false, postReversals);
        }
    }

    public void close(AppUser currentUser, JsonCommand command, Map<String, Object> actualChanges) {
        SavingsAccountTransaction accountTransaction;
        List savingsAccountTransactions;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount.close");
        SavingsAccountStatusType currentStatus = SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status());
        if (!SavingsAccountStatusType.MATURED.hasStateOf(currentStatus) && this.maturityDate() != null) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("not.in.matured.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        if (DateUtils.isBefore((LocalDate)closedDate, (LocalDate)this.getActivationDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.activation.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (this.maturityDate() != null && DateUtils.isBefore((LocalDate)closedDate, (LocalDate)this.maturityDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.account.maturity.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (DateUtils.isAfterBusinessDate((LocalDate)closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("cannot.be.a.future.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if ((savingsAccountTransactions = this.retrieveListOfTransactions()).size() > 0 && (accountTransaction = (SavingsAccountTransaction)savingsAccountTransactions.get(savingsAccountTransactions.size() - 1)).isAfter(closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.last.transaction.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        this.validateActivityNotBeforeClientOrGroupTransferDate(SavingsEvent.SAVINGS_CLOSE_ACCOUNT, closedDate);
        this._persistence_set_status(SavingsAccountStatusType.CLOSED.getValue());
        Integer onAccountClosureId = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        this._persistence_get_accountTermAndPreClosure().updateOnAccountClosureStatus(onClosureType);
        actualChanges.put("status", SavingsEnumerations.status((Integer)this._persistence_get_status()));
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("closedOnDate", closedDate.format(fmt));
        this._persistence_set_rejectedOnDate(null);
        this._persistence_set_rejectedBy(null);
        this._persistence_set_withdrawnOnDate(null);
        this._persistence_set_withdrawnBy(null);
        this._persistence_set_closedOnDate(closedDate);
        this._persistence_set_closedBy(currentUser);
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
    }

    public void postMaturityInterest(boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate closeDate, boolean postReversals) {
        LocalDate interestPostingUpToDate = this.maturityDate();
        if (interestPostingUpToDate == null) {
            interestPostingUpToDate = closeDate;
        }
        this.setClosedOnDate(closeDate);
        MathContext mc = MathContext.DECIMAL64;
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean backdatedTxnsAllowedTill = false;
        List postingPeriods = this.calculateInterestUsing(mc, interestPostingUpToDate.minusDays(1L), isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        Money interestPostedToDate = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        boolean recalucateDailyBalanceDetails = false;
        for (PostingPeriod interestPostingPeriod : postingPeriods) {
            LocalDate interestPostingTransactionDate = interestPostingPeriod.dateOfPostingTransaction();
            interestPostingTransactionDate = DateUtils.isAfter((LocalDate)interestPostingTransactionDate, (LocalDate)interestPostingUpToDate) ? interestPostingUpToDate : interestPostingTransactionDate;
            Money interestEarnedToBePostedForPeriod = interestPostingPeriod.getInterestEarned();
            interestPostedToDate = interestPostedToDate.plus(interestEarnedToBePostedForPeriod);
            SavingsAccountTransaction postingTransaction = this.findInterestPostingTransactionFor(interestPostingTransactionDate);
            if (postingTransaction == null) {
                SavingsAccountTransaction newPostingTransaction = SavingsAccountTransaction.interestPosting((SavingsAccount)this, (Office)this.office(), (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod, (boolean)interestPostingPeriod.isUserPosting());
                this.addTransaction(newPostingTransaction);
                recalucateDailyBalanceDetails = true;
                continue;
            }
            boolean correctionRequired = postingTransaction.hasNotAmount(interestEarnedToBePostedForPeriod);
            if (!correctionRequired) continue;
            postingTransaction.reverse();
            SavingsAccountTransaction newPostingTransaction = SavingsAccountTransaction.interestPosting((SavingsAccount)this, (Office)this.office(), (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod, (boolean)interestPostingPeriod.isUserPosting());
            this.addTransaction(newPostingTransaction);
            recalucateDailyBalanceDetails = true;
        }
        this.applyWithholdTaxForDepositAccounts(interestPostingUpToDate, recalucateDailyBalanceDetails, false);
        if (recalucateDailyBalanceDetails) {
            this.recalculateDailyBalances(Money.zero((MonetaryCurrency)this._persistence_get_currency()), interestPostingUpToDate, false, postReversals);
        }
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
    }

    public void postPreMaturityInterest(LocalDate accountCloseDate, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, boolean postReversals) {
        Money interestPostedToDate = this.totalInterestPosted();
        LocalDate interestCalculatedToDate = accountCloseDate.minusDays(1L);
        Money interestOnMaturity = this.calculatePreMatureInterest(interestCalculatedToDate, this.retreiveOrderedNonInterestPostingTransactions(), isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        boolean recalucateDailyBalance = false;
        boolean backdatedTxnsAllowedTill = false;
        Money remainigInterestToBePosted = interestOnMaturity.minus(interestPostedToDate);
        if (!remainigInterestToBePosted.isZero()) {
            boolean postInterestAsOn = false;
            SavingsAccountTransaction newPostingTransaction = SavingsAccountTransaction.interestPosting((SavingsAccount)this, (Office)this.office(), (LocalDate)accountCloseDate, (Money)remainigInterestToBePosted, (boolean)false);
            this.addTransaction(newPostingTransaction);
            recalucateDailyBalance = true;
        }
        this.applyWithholdTaxForDepositAccounts(accountCloseDate, recalucateDailyBalance, false);
        if (recalucateDailyBalance) {
            this.recalculateDailyBalances(Money.zero((MonetaryCurrency)this._persistence_get_currency()), accountCloseDate, false, postReversals);
        }
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
        this._persistence_get_accountTermAndPreClosure().updateMaturityDetails(this.getAccountBalance(), accountCloseDate);
    }

    public BigDecimal calculatePreMatureAmount(LocalDate preMatureDate, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        Money interestPostedToDate = this.totalInterestPosted().copy();
        Money interestEarnedTillDate = this.calculatePreMatureInterest(preMatureDate, this.retreiveOrderedNonInterestPostingTransactions(), isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Money accountBalance = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this.getAccountBalance());
        Money maturityAmount = accountBalance.minus(interestPostedToDate).plus(interestEarnedTillDate);
        return maturityAmount.getAmount();
    }

    private Money calculatePreMatureInterest(LocalDate preMatureDate, List<SavingsAccountTransaction> transactions, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        MathContext mc = MathContext.DECIMAL64;
        List postingPeriods = this.calculateInterestPayable(mc, preMatureDate, transactions, isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Money interestOnMaturity = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        for (PostingPeriod interestPostingPeriod : postingPeriods) {
            Money interestEarnedForPeriod = interestPostingPeriod.getInterestEarned();
            interestOnMaturity = interestOnMaturity.plus(interestEarnedForPeriod);
        }
        this._persistence_get_summary().updateFromInterestPeriodSummaries(this._persistence_get_currency(), postingPeriods);
        return interestOnMaturity;
    }

    public void postInterest(MathContext mc, LocalDate postingDate, boolean isInterestTransfer, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate postInterestAson, boolean backdatedTxnsAllowedTill, boolean postReversals) {
        LocalDate interestPostingUpToDate = this.interestPostingUpToDate(postingDate);
        super.postInterest(mc, interestPostingUpToDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestAson, backdatedTxnsAllowedTill, postReversals);
    }

    public List<PostingPeriod> calculateInterestUsing(MathContext mc, LocalDate postingDate, boolean isInterestTransfer, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate postAsInterestOn, boolean backdatedTxnsAllowedTill, boolean postReversals) {
        LocalDate interestPostingUpToDate = this.interestPostingUpToDate(postingDate);
        return super.calculateInterestUsing(mc, interestPostingUpToDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postAsInterestOn, backdatedTxnsAllowedTill, postReversals);
    }

    private LocalDate interestPostingUpToDate(LocalDate interestPostingDate) {
        LocalDate interestPostingUpToDate = interestPostingDate;
        LocalDate uptoMaturityDate = this.interestCalculatedUpto();
        if (uptoMaturityDate != null && DateUtils.isBefore((LocalDate)uptoMaturityDate, (LocalDate)interestPostingDate)) {
            interestPostingUpToDate = uptoMaturityDate;
        }
        return interestPostingUpToDate;
    }

    public LocalDate maturityDate() {
        return this._persistence_get_accountTermAndPreClosure().getMaturityDate();
    }

    public BigDecimal maturityAmount() {
        return this._persistence_get_accountTermAndPreClosure().maturityAmount();
    }

    private LocalDate interestCalculatedUpto() {
        LocalDate uptoMaturityDate = this.calculateMaturityDate();
        if (uptoMaturityDate != null) {
            uptoMaturityDate = uptoMaturityDate.minusDays(1L);
        }
        return uptoMaturityDate;
    }

    private Money totalInterestPosted() {
        Money interestPostedToDate = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        List trans = this.getTransactions();
        for (SavingsAccountTransaction transaction : trans) {
            if (!transaction.isInterestPostingAndNotReversed()) continue;
            interestPostedToDate = interestPostedToDate.plus(transaction.getAmount(this._persistence_get_currency()));
        }
        return interestPostedToDate;
    }

    public Map<String, Object> activate(AppUser currentUser, JsonCommand command) {
        Map actualChanges = super.activate(currentUser, command);
        if (this._persistence_get_accountTermAndPreClosure().isAfterExpectedFirstDepositDate(this.getActivationDate())) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(command.extractLocale());
            String dateAsString = formatter.format(this._persistence_get_accountTermAndPreClosure().getExpectedFirstDepositOnDate());
            baseDataValidator.reset().parameter("activatedOnDate").value((Object)dateAsString).failWithCodeNoParameterAddedToErrorCode("cannot.be.before.expected.first.deposit.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        return actualChanges;
    }

    protected List<SavingsAccountTransaction> sortTransactions(List<SavingsAccountTransaction> transactions) {
        ArrayList<SavingsAccountTransaction> listOfTransactionsSorted = new ArrayList<SavingsAccountTransaction>();
        listOfTransactionsSorted.addAll(transactions);
        SavingsAccountTransactionComparator transactionComparator = new SavingsAccountTransactionComparator();
        Collections.sort(listOfTransactionsSorted, transactionComparator);
        return listOfTransactionsSorted;
    }

    public SavingsAccountTransaction deposit(SavingsAccountTransactionDTO transactionDTO, boolean backdatedTxnsAllowedTill, Long relaxingDaysConfigForPivotDate, String refNo) {
        if (this.isAccountMatured()) {
            String defaultUserMessage = "Transaction is not allowed. Account is matured.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.recurring.deposit.account.transaction.account.is.matured", (String)"Transaction is not allowed. Account is matured.", (String)"transactionDate", (Object[])new Object[]{transactionDTO.getTransactionDate().format(transactionDTO.getFormatter())});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        if (!this.isBeforeMaturityDate(transactionDTO.getTransactionDate())) {
            String defaultUserMessage = "Transaction is not allowed. Transaction date is on or after account maturity date.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.recurring.deposit.account.transaction.date.is.after.account.maturity.date", (String)"Transaction is not allowed. Transaction date is on or after account maturity date.", (String)"transactionDate", (Object[])new Object[]{transactionDTO.getTransactionDate().format(transactionDTO.getFormatter())});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        if (this.isBeforeDepositStartDate(transactionDTO.getTransactionDate())) {
            String defaultUserMessage = "Transaction is not allowed. Transaction date is on or after account activation and deposit start date.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.recurring.deposit.account.transaction.date.is.before.account.activation.or.deposit.date", (String)"Transaction is not allowed. Transaction date is on or after account activation and deposit start date.", (String)"transactionDate", (Object[])new Object[]{transactionDTO.getTransactionDate().format(transactionDTO.getFormatter())});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        SavingsAccountTransaction transaction = super.deposit(transactionDTO, backdatedTxnsAllowedTill, relaxingDaysConfigForPivotDate, refNo);
        return transaction;
    }

    public void handleScheduleInstallments(SavingsAccountTransaction transaction) {
        LocalDate transactionDate = transaction.getTransactionDate();
        Money transactionAmountUnprocessed = transaction.getAmount(this.getCurrency());
        for (RecurringDepositScheduleInstallment currentInstallment : this.depositScheduleInstallments()) {
            if (!currentInstallment.isNotFullyPaidOff() || !transactionAmountUnprocessed.isGreaterThanZero()) continue;
            if (!this.adjustAdvanceTowardsFuturePayments() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)currentInstallment.dueDate())) {
                transactionAmountUnprocessed = Money.zero((MonetaryCurrency)this.getCurrency());
            }
            transactionAmountUnprocessed = this.handleInstallmentTransaction(currentInstallment, transactionAmountUnprocessed, transactionDate);
        }
    }

    public void updateScheduleInstallments() {
        for (RecurringDepositScheduleInstallment currentInstallment : this.depositScheduleInstallments()) {
            currentInstallment.resetDerivedFields();
        }
        List orderedDepositTransactions = this.retreiveOrderedDepositTransactions();
        for (SavingsAccountTransaction transaction : orderedDepositTransactions) {
            this.handleScheduleInstallments(transaction);
        }
    }

    public void updateScheduleInstallmentsWithNewRecommendedDepositAmount(BigDecimal newDepositAmount, LocalDate depositAmountupdatedFromDate) {
        for (RecurringDepositScheduleInstallment currentInstallment : this.depositScheduleInstallments()) {
            if (!DateUtils.isAfter((LocalDate)depositAmountupdatedFromDate, (LocalDate)currentInstallment.dueDate())) {
                currentInstallment.updateDepositAmountAndResetDerivedFields(newDepositAmount);
                continue;
            }
            currentInstallment.resetDerivedFields();
        }
        List orderedDepositTransactions = this.retreiveOrderedDepositTransactions();
        for (SavingsAccountTransaction transaction : orderedDepositTransactions) {
            this.handleScheduleInstallments(transaction);
        }
    }

    private List<SavingsAccountTransaction> retreiveOrderedDepositTransactions() {
        List listOfTransactionsSorted = this.retrieveListOfTransactions();
        ArrayList<SavingsAccountTransaction> orderedDepositTransactions = new ArrayList<SavingsAccountTransaction>();
        for (SavingsAccountTransaction transaction : listOfTransactionsSorted) {
            if (!transaction.isDepositAndNotReversed()) continue;
            orderedDepositTransactions.add(transaction);
        }
        return orderedDepositTransactions;
    }

    protected boolean isTransactionInAdvanceOfInstallment(int currentInstallmentIndex, List<RecurringDepositScheduleInstallment> installments, LocalDate transactionDate) {
        RecurringDepositScheduleInstallment currentInstallment = installments.get(currentInstallmentIndex);
        return DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)currentInstallment.dueDate());
    }

    private Money handleInstallmentTransaction(RecurringDepositScheduleInstallment currentInstallment, Money transactionAmountUnprocessed, LocalDate transactionDate) {
        Money transactionAmountRemaining = transactionAmountUnprocessed;
        Money depositAmountPortion = currentInstallment.payInstallment(transactionDate, transactionAmountRemaining);
        transactionAmountRemaining = transactionAmountRemaining.minus(depositAmountPortion);
        return transactionAmountRemaining;
    }

    private boolean isAccountMatured() {
        return SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status()).isMatured();
    }

    private boolean isBeforeMaturityDate(LocalDate compareDate) {
        LocalDate maturityDate = this.maturityDate();
        return maturityDate == null || DateUtils.isBefore((LocalDate)compareDate, (LocalDate)maturityDate);
    }

    private boolean isBeforeDepositStartDate(LocalDate compareDate) {
        return DateUtils.isBefore((LocalDate)compareDate, (LocalDate)this.depositStartDate());
    }

    public void validateDomainRules() {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount");
        this.validateDomainRules(baseDataValidator);
        super.validateInterestPostingAndCompoundingPeriodTypes(baseDataValidator);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateDomainRules(DataValidatorBuilder baseDataValidator) {
        boolean isMinTermGreaterThanMax = this._persistence_get_accountTermAndPreClosure().depositTermDetail().isMinDepositTermGreaterThanMaxDepositTerm();
        if (isMinTermGreaterThanMax) {
            Integer maxTerm = this._persistence_get_accountTermAndPreClosure().depositTermDetail().maxDepositTerm();
            baseDataValidator.reset().parameter("maxDepositTerm").value((Object)maxTerm).failWithCodeNoParameterAddedToErrorCode("max.term.lessthan.min.term", new Object[0]);
        }
        Integer depositPeriod = this._persistence_get_accountTermAndPreClosure().depositPeriod();
        if (this._persistence_get_accountTermAndPreClosure().depositTermDetail().maxDepositTerm() != null) {
            baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).notNull();
        }
        if (depositPeriod != null) {
            SavingsPeriodFrequencyType depositPeriodFrequencyType = this._persistence_get_accountTermAndPreClosure().depositPeriodFrequencyType();
            boolean isValidDepositPeriod = this._persistence_get_accountTermAndPreClosure().depositTermDetail().isDepositBetweenMinAndMax(this.depositStartDate(), this.calculateMaturityDate());
            if (!isValidDepositPeriod) {
                baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).failWithCodeNoParameterAddedToErrorCode("deposit.period.not.between.min.and.max.deposit.term", new Object[0]);
            } else {
                boolean isValid;
                Integer inMultiplesOf = this._persistence_get_accountTermAndPreClosure().depositTermDetail().inMultiplesOfDepositTerm();
                if (inMultiplesOf != null && !(isValid = this._persistence_get_accountTermAndPreClosure().depositTermDetail().isValidInMultiplesOfPeriod(depositPeriod, depositPeriodFrequencyType))) {
                    baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).failWithCodeNoParameterAddedToErrorCode("deposit.period.not.multiple.of.term", new Object[0]);
                }
            }
            if (this.isAccountLocked(this.calculateMaturityDate())) {
                baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).failWithCode("deposit.period.must.be.greater.than.lock.in.period", new Object[]{"Deposit period must be greater than account lock-in period."});
            }
        }
        if (this.firstDepositDateBeforeAccountSubmittedOrActivationDate()) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("expected.first.deposit.date.must.be.after.account.submitted.or.activation.date", new Object[0]);
        }
    }

    public void validateApplicableInterestRate() {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount");
        LocalDate maturityDate = this.calculateMaturityDate();
        if (this._persistence_get_chart() != null) {
            LocalDate chartEndDate;
            LocalDate chartFromDate = this._persistence_get_chart().getFromDate();
            LocalDateInterval chartInterval = LocalDateInterval.create((LocalDate)chartFromDate, (LocalDate)(chartEndDate = (chartEndDate = this._persistence_get_chart().getEndDate()) == null ? DateUtils.getBusinessLocalDate() : chartEndDate));
            if (!chartInterval.contains(this.accountSubmittedOrActivationDate())) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("no.valid.interest.rate.slab.available.for.date.range", new Object[0]);
            }
            if (maturityDate == null) {
                maturityDate = DateUtils.getBusinessLocalDate();
            }
            BigDecimal maturityAmount = this._persistence_get_accountTermAndPreClosure().depositAmount();
            BigDecimal applicableInterestRate = this._persistence_get_chart().getApplicableInterestRate(maturityAmount, this.depositStartDate(), maturityDate, this._persistence_get_client());
            if (applicableInterestRate.compareTo(BigDecimal.ZERO) == 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("no.applicable.interest.rate.is.found.based.on.amount.and.deposit.period", new Object[0]);
            }
        } else if (this._persistence_get_nominalAnnualInterestRate() == null || this._persistence_get_nominalAnnualInterestRate().compareTo(BigDecimal.ZERO) == 0) {
            baseDataValidator.reset().parameter("nominalAnnualInterestRate").value((Object)this._persistence_get_nominalAnnualInterestRate()).failWithCodeNoParameterAddedToErrorCode("interest.chart.or.nominal.interest.rate.required", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public boolean isReinvestOnClosure() {
        return this._persistence_get_accountTermAndPreClosure().isReinvestOnClosure();
    }

    public boolean isTransferToSavingsOnClosure() {
        return this._persistence_get_accountTermAndPreClosure().isTransferToSavingsOnClosure();
    }

    public RecurringDepositAccount reInvest(BigDecimal depositAmount) {
        DepositAccountTermAndPreClosure newAccountTermAndPreClosure = this._persistence_get_accountTermAndPreClosure().copy(depositAmount);
        DepositAccountRecurringDetail recurringDetail = this._persistence_get_recurringDetail().copy();
        SavingsProduct product = this._persistence_get_product();
        InterestRateChart productChart = product.applicableChart(this.getClosedOnDate());
        DepositAccountInterestRateChart newChart = DepositAccountInterestRateChart.from((InterestRateChart)productChart);
        String accountNumber = null;
        ExternalId externalId = this._persistence_get_externalId();
        AccountType accountType = AccountType.fromInt((Integer)this._persistence_get_accountType());
        SavingsPostingInterestPeriodType postingPeriodType = SavingsPostingInterestPeriodType.fromInt((Integer)this._persistence_get_interestPostingPeriodType());
        SavingsCompoundingInterestPeriodType compoundingPeriodType = SavingsCompoundingInterestPeriodType.fromInt((Integer)this._persistence_get_interestCompoundingPeriodType());
        SavingsInterestCalculationType interestCalculationType = SavingsInterestCalculationType.fromInt((Integer)this._persistence_get_interestCalculationType());
        SavingsInterestCalculationDaysInYearType daysInYearType = SavingsInterestCalculationDaysInYearType.fromInt((Integer)this._persistence_get_interestCalculationDaysInYearType());
        BigDecimal minRequiredOpeningBalance = depositAmount;
        BigDecimal interestRate = BigDecimal.ZERO;
        Set savingsAccountCharges = null;
        SavingsPeriodFrequencyType lockinPeriodFrequencyType = SavingsPeriodFrequencyType.fromInt((Integer)this._persistence_get_lockinPeriodFrequencyType());
        Integer lockinPeriodFrequency = this._persistence_get_lockinPeriodFrequency();
        boolean withdrawalFeeApplicableForTransfer = false;
        LocalDate now = this.getClosedOnDate();
        newAccountTermAndPreClosure.updateExpectedFirstDepositDate(now);
        RecurringDepositAccount rdAccount = RecurringDepositAccount.createNewActivatedAccount((Client)this._persistence_get_client(), (Group)this._persistence_get_group(), (SavingsProduct)product, (Staff)this._persistence_get_savingsOfficer(), accountNumber, (ExternalId)externalId, (AccountType)accountType, (LocalDate)this.getClosedOnDate(), (AppUser)this._persistence_get_closedBy(), (BigDecimal)interestRate, (SavingsCompoundingInterestPeriodType)compoundingPeriodType, (SavingsPostingInterestPeriodType)postingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (SavingsInterestCalculationDaysInYearType)daysInYearType, (BigDecimal)minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (SavingsPeriodFrequencyType)lockinPeriodFrequencyType, (boolean)false, savingsAccountCharges, (DepositAccountTermAndPreClosure)newAccountTermAndPreClosure, (DepositAccountRecurringDetail)recurringDetail, (DepositAccountInterestRateChart)newChart, (boolean)this._persistence_get_withHoldTax());
        rdAccount.setDatesFrom(now);
        newAccountTermAndPreClosure.updateAccountReference((SavingsAccount)rdAccount);
        recurringDetail.updateAccountReference((SavingsAccount)rdAccount);
        return rdAccount;
    }

    private boolean firstDepositDateBeforeAccountSubmittedOrActivationDate() {
        LocalDate expectedFirstDepositLocalDate = this._persistence_get_accountTermAndPreClosure().getExpectedFirstDepositOnDate();
        return expectedFirstDepositLocalDate != null && DateUtils.isBefore((LocalDate)expectedFirstDepositLocalDate, (LocalDate)this.accountSubmittedOrActivationDate());
    }

    public void setDatesFrom(LocalDate now) {
        this._persistence_set_rejectedOnDate(null);
        this._persistence_set_rejectedBy(null);
        this._persistence_set_withdrawnOnDate(null);
        this._persistence_set_withdrawnBy(null);
        this._persistence_set_closedOnDate(null);
        this._persistence_set_closedBy(null);
        this._persistence_set_activatedBy(null);
        this._persistence_set_lockedInUntilDate(null);
        this._persistence_set_activatedOnDate(now);
    }

    public void setClosedOnDate(LocalDate closedOnDate) {
        this._persistence_set_closedOnDate(closedOnDate);
    }

    protected boolean isTransferInterestToOtherAccount() {
        return this._persistence_get_accountTermAndPreClosure().isTransferInterestToLinkedAccount();
    }

    public void generateSchedule(PeriodFrequencyType frequency, Integer recurringEvery, Calendar calendar) {
        this._persistence_get_depositScheduleInstallments().clear();
        LocalDate installmentDate = null;
        installmentDate = this.isCalendarInherited() ? CalendarUtils.getNextScheduleDate((Calendar)calendar, (LocalDate)this.accountSubmittedOrActivationDate()) : this.depositStartDate();
        int installmentNumber = 1;
        LocalDate maturityDate = this.calcualteScheduleTillDate(frequency, recurringEvery);
        BigDecimal depositAmount = this._persistence_get_recurringDetail().mandatoryRecommendedDepositAmount();
        while (DateUtils.isBefore((LocalDate)installmentDate, (LocalDate)maturityDate)) {
            RecurringDepositScheduleInstallment installment = RecurringDepositScheduleInstallment.installment((RecurringDepositAccount)this, (Integer)installmentNumber, (LocalDate)installmentDate, (BigDecimal)depositAmount);
            this.addDepositScheduleInstallment(installment);
            installmentDate = DepositAccountUtils.calculateNextDepositDate((LocalDate)installmentDate, (PeriodFrequencyType)frequency, (int)recurringEvery);
            ++installmentNumber;
        }
        this.updateDepositAmount();
    }

    private LocalDate calcualteScheduleTillDate(PeriodFrequencyType frequency, Integer recurringEvery) {
        LocalDate tillDate = this.calculateMaturityDate();
        if (tillDate == null) {
            LocalDate today = DateUtils.getBusinessLocalDate();
            tillDate = DepositAccountUtils.calculateNextDepositDate((LocalDate)today, (PeriodFrequencyType)frequency, (int)(recurringEvery * 6));
        }
        return tillDate;
    }

    private List<RecurringDepositScheduleInstallment> depositScheduleInstallments() {
        return this._persistence_get_depositScheduleInstallments();
    }

    private void addDepositScheduleInstallment(RecurringDepositScheduleInstallment installment) {
        this._persistence_get_depositScheduleInstallments().add(installment);
    }

    public boolean isCalendarInherited() {
        return this._persistence_get_recurringDetail().isCalendarInherited();
    }

    public void updateOverduePayments(LocalDate todayDate) {
        LocalDate overdueUptoDate = this.maturityDate();
        if (overdueUptoDate == null || DateUtils.isAfter((LocalDate)overdueUptoDate, (LocalDate)todayDate)) {
            overdueUptoDate = todayDate;
        }
        List installments = this.depositScheduleInstallments();
        int noOfOverdueInstallments = 0;
        Money totalOverdueAmount = Money.zero((MonetaryCurrency)this.getCurrency());
        for (RecurringDepositScheduleInstallment installment : installments) {
            if (!installment.isNotFullyPaidOff() || !DateUtils.isAfter((LocalDate)overdueUptoDate, (LocalDate)installment.dueDate())) continue;
            ++noOfOverdueInstallments;
            totalOverdueAmount = totalOverdueAmount.plus(installment.getDepositAmountOutstanding(this.getCurrency()));
        }
        this._persistence_get_recurringDetail().updateOverdueDetails(noOfOverdueInstallments, totalOverdueAmount);
    }

    public boolean allowWithdrawal() {
        return this._persistence_get_recurringDetail().allowWithdrawal();
    }

    public boolean adjustAdvanceTowardsFuturePayments() {
        return this._persistence_get_recurringDetail().adjustAdvanceTowardsFuturePayments();
    }

    public boolean isTransactionsAllowed() {
        return this.isActive() || this.isAccountMatured();
    }

    public DepositAccountRecurringDetail getRecurringDetail() {
        return this._persistence_get_recurringDetail();
    }

    public void loadLazyCollections() {
        this._persistence_get_depositScheduleInstallments().size();
        super.loadLazyCollections();
        this._persistence_get_chart().getId();
    }

    public BigDecimal getDepositAmount() {
        return this._persistence_get_accountTermAndPreClosure().depositAmount();
    }

    public DepositAccountType depositAccountType() {
        return DepositAccountType.fromInt((Integer)300);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_chart_vh != null) {
            this._persistence_chart_vh = (WeavedAttributeValueHolderInterface)this._persistence_chart_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RecurringDepositAccount();
    }

    public Object _persistence_get(String string) {
        if (string == "accountTermAndPreClosure") {
            return this.accountTermAndPreClosure;
        }
        if (string == "depositScheduleInstallments") {
            return this.depositScheduleInstallments;
        }
        if (string == "chart") {
            return this.chart;
        }
        if (string == "recurringDetail") {
            return this.recurringDetail;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "accountTermAndPreClosure") {
            this.accountTermAndPreClosure = (DepositAccountTermAndPreClosure)object;
            return;
        }
        if (string == "depositScheduleInstallments") {
            this.depositScheduleInstallments = (List)object;
            return;
        }
        if (string == "chart") {
            this.chart = (DepositAccountInterestRateChart)object;
            return;
        }
        if (string == "recurringDetail") {
            this.recurringDetail = (DepositAccountRecurringDetail)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public DepositAccountTermAndPreClosure _persistence_get_accountTermAndPreClosure() {
        this._persistence_checkFetched("accountTermAndPreClosure");
        return this.accountTermAndPreClosure;
    }

    public void _persistence_set_accountTermAndPreClosure(DepositAccountTermAndPreClosure depositAccountTermAndPreClosure) {
        this._persistence_checkFetchedForSet("accountTermAndPreClosure");
        this._persistence_propertyChange("accountTermAndPreClosure", (Object)this.accountTermAndPreClosure, (Object)depositAccountTermAndPreClosure);
        this.accountTermAndPreClosure = depositAccountTermAndPreClosure;
    }

    public List _persistence_get_depositScheduleInstallments() {
        this._persistence_checkFetched("depositScheduleInstallments");
        return this.depositScheduleInstallments;
    }

    public void _persistence_set_depositScheduleInstallments(List list) {
        this._persistence_checkFetchedForSet("depositScheduleInstallments");
        this._persistence_propertyChange("depositScheduleInstallments", (Object)this.depositScheduleInstallments, (Object)list);
        this.depositScheduleInstallments = list;
    }

    protected void _persistence_initialize_chart_vh() {
        if (this._persistence_chart_vh == null) {
            this._persistence_chart_vh = new ValueHolder((Object)this.chart);
            this._persistence_chart_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_chart_vh() {
        DepositAccountInterestRateChart depositAccountInterestRateChart;
        this._persistence_initialize_chart_vh();
        if ((this._persistence_chart_vh.isCoordinatedWithProperty() || this._persistence_chart_vh.isNewlyWeavedValueHolder()) && (depositAccountInterestRateChart = this._persistence_get_chart()) != this._persistence_chart_vh.getValue()) {
            this._persistence_set_chart(depositAccountInterestRateChart);
        }
        return this._persistence_chart_vh;
    }

    public void _persistence_set_chart_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_chart_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            DepositAccountInterestRateChart depositAccountInterestRateChart = this._persistence_get_chart();
            if (depositAccountInterestRateChart != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_chart((DepositAccountInterestRateChart)object);
            }
        } else {
            this.chart = null;
        }
    }

    public DepositAccountInterestRateChart _persistence_get_chart() {
        this._persistence_checkFetched("chart");
        this._persistence_initialize_chart_vh();
        this.chart = (DepositAccountInterestRateChart)this._persistence_chart_vh.getValue();
        return this.chart;
    }

    public void _persistence_set_chart(DepositAccountInterestRateChart depositAccountInterestRateChart) {
        this._persistence_checkFetchedForSet("chart");
        this._persistence_initialize_chart_vh();
        this.chart = (DepositAccountInterestRateChart)this._persistence_chart_vh.getValue();
        this._persistence_propertyChange("chart", (Object)this.chart, (Object)depositAccountInterestRateChart);
        this.chart = depositAccountInterestRateChart;
        this._persistence_chart_vh.setValue((Object)depositAccountInterestRateChart);
    }

    public DepositAccountRecurringDetail _persistence_get_recurringDetail() {
        this._persistence_checkFetched("recurringDetail");
        return this.recurringDetail;
    }

    public void _persistence_set_recurringDetail(DepositAccountRecurringDetail depositAccountRecurringDetail) {
        this._persistence_checkFetchedForSet("recurringDetail");
        this._persistence_propertyChange("recurringDetail", (Object)this.recurringDetail, (Object)depositAccountRecurringDetail);
        this.recurringDetail = depositAccountRecurringDetail;
    }
}

