/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositsApiConstants;
import org.apache.fineract.portfolio.savings.PreClosurePenalInterestOnType;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPeriodFrequencyType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.DepositProductDataValidator;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DepositAccountDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final DepositProductDataValidator productDataValidator;

    @Autowired
    public DepositAccountDataValidator(FromJsonHelper fromApiJsonHelper, DepositProductDataValidator productDataValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.productDataValidator = productDataValidator;
    }

    public void validateFixedDepositForSubmit(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailsForSubmit(element, baseDataValidator);
        this.validatePreClosureDetailForSubmit(element, baseDataValidator);
        this.validateDepositTermDeatilForSubmit(element, baseDataValidator, DepositAccountType.FIXED_DEPOSIT);
        this.validateSavingsCharges(element, baseDataValidator);
        this.validateWithHoldTax(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateFixedDepositForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailsForUpdate(element, baseDataValidator);
        this.validatePreClosureDetailForUpdate(element, baseDataValidator);
        this.validateDepositTermDeatilForUpdate(element, baseDataValidator, DepositAccountType.FIXED_DEPOSIT);
        this.validateWithHoldTax(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateRecurringDepositForSubmit(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailsForSubmit(element, baseDataValidator);
        this.validatePreClosureDetailForSubmit(element, baseDataValidator);
        this.validateDepositTermDeatilForSubmit(element, baseDataValidator, DepositAccountType.RECURRING_DEPOSIT);
        this.validateRecurringDetailForSubmit(element, baseDataValidator);
        this.validateSavingsCharges(element, baseDataValidator);
        this.validateWithHoldTax(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateRecurringDepositForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailsForUpdate(element, baseDataValidator);
        this.validatePreClosureDetailForUpdate(element, baseDataValidator);
        this.validateDepositTermDeatilForUpdate(element, baseDataValidator, DepositAccountType.RECURRING_DEPOSIT);
        this.validateRecurringDetailForUpdate(element, baseDataValidator);
        this.validateWithHoldTax(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateFixedDepositForInterestCalculation(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_INTEREST_CALCULATION_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateForInterestCalc(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateDepositDetailsForSubmit(JsonElement element, DataValidatorBuilder baseDataValidator) {
        Long groupId;
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        if (clientId != null) {
            baseDataValidator.reset().parameter("clientId").value((Object)clientId).longGreaterThanZero();
        }
        if ((groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element)) != null) {
            baseDataValidator.reset().parameter("groupId").value((Object)groupId).longGreaterThanZero();
        }
        if (clientId == null && groupId == null) {
            baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().integerGreaterThanZero();
        }
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        baseDataValidator.reset().parameter("productId").value((Object)productId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("fieldOfficerId", element)) {
            Long fieldOfficerId = this.fromApiJsonHelper.extractLongNamed("fieldOfficerId", element);
            baseDataValidator.reset().parameter("fieldOfficerId").value((Object)fieldOfficerId).ignoreIfNull().integerGreaterThanZero();
        }
        LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
        baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        if (this.fromApiJsonHelper.parameterExists("accountNo", element)) {
            String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
            baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).notBlank().notExceedingLengthOf(Integer.valueOf(20));
        }
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("nominalAnnualInterestRate", element)) {
            BigDecimal interestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("nominalAnnualInterestRate", element);
            baseDataValidator.reset().parameter("nominalAnnualInterestRate").value((Object)interestRate).notNull().zeroOrPositiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("interestCompoundingPeriodType", element)) {
            Integer interestCompoundingPeriodType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCompoundingPeriodType", element);
            baseDataValidator.reset().parameter("interestCompoundingPeriodType").value((Object)interestCompoundingPeriodType).notNull().isOneOfTheseValues(SavingsCompoundingInterestPeriodType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("interestPostingPeriodType", element)) {
            Integer interestPostingPeriodType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestPostingPeriodType", element);
            baseDataValidator.reset().parameter("interestPostingPeriodType").value((Object)interestPostingPeriodType).notNull().isOneOfTheseValues(SavingsPostingInterestPeriodType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("interestCalculationType", element)) {
            Integer interestCalculationType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationType", element);
            baseDataValidator.reset().parameter("interestCalculationType").value((Object)interestCalculationType).notNull().isOneOfTheseValues(SavingsInterestCalculationType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("interestCalculationDaysInYearType", element)) {
            Integer interestCalculationDaysInYearType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationDaysInYearType", element);
            baseDataValidator.reset().parameter("interestCalculationDaysInYearType").value((Object)interestCalculationDaysInYearType).notNull().isOneOfTheseValues(SavingsInterestCalculationDaysInYearType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("minRequiredOpeningBalance", element)) {
            BigDecimal minOpeningBalance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minRequiredOpeningBalance", element);
            baseDataValidator.reset().parameter("minRequiredOpeningBalance").value((Object)minOpeningBalance).zeroOrPositiveAmount();
        }
        boolean isLockinPeriodFrequencyValidated = false;
        boolean isLockinPeriodFrequencyTypeValidated = false;
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequency", element)) {
            isLockinPeriodFrequencyValidated = true;
            Integer lockinPeriodFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("lockinPeriodFrequency", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinPeriodFrequency).ignoreIfNull();
            if (lockinPeriodFrequency != null) {
                isLockinPeriodFrequencyTypeValidated = true;
                Integer lockinPeriodFrequencyType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("lockinPeriodFrequencyType", element);
                baseDataValidator.reset().parameter("lockinPeriodFrequencyType").value((Object)lockinPeriodFrequencyType).ignoreIfNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            }
        }
        if (!isLockinPeriodFrequencyTypeValidated && this.fromApiJsonHelper.parameterExists("lockinPeriodFrequencyType", element)) {
            Integer lockinPeriodFrequencyType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("lockinPeriodFrequencyType", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequencyType").value((Object)lockinPeriodFrequencyType).inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            if (lockinPeriodFrequencyType != null && !isLockinPeriodFrequencyValidated) {
                Integer lockinPeriodFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("lockinPeriodFrequency", element);
                baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinPeriodFrequency).ignoreIfNull().integerZeroOrGreater();
            }
        }
        boolean isLinkedAccRequired = false;
        if (this.fromApiJsonHelper.parameterExists("transferInterestToSavings", element)) {
            isLinkedAccRequired = this.fromApiJsonHelper.extractBooleanNamed("transferInterestToSavings", element);
        }
        Long linkAccountId = this.fromApiJsonHelper.extractLongNamed("linkAccountId", element);
        if (isLinkedAccRequired) {
            baseDataValidator.reset().parameter("linkAccountId").value((Object)linkAccountId).notNull().longGreaterThanZero();
        } else {
            baseDataValidator.reset().parameter("linkAccountId").value((Object)linkAccountId).ignoreIfNull().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("maturityInstructionId", element)) {
            Integer depositRolloverId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maturityInstructionId", element);
            baseDataValidator.reset().parameter("maturityInstructionId").value((Object)depositRolloverId).notNull().isOneOfTheseValues(DepositAccountOnClosureType.integerValues());
            if (depositRolloverId.equals(DepositAccountOnClosureType.TRANSFER_TO_SAVINGS.getValue())) {
                Long transferToSavingsId = this.fromApiJsonHelper.extractLongNamed("transferToSavingsId", element);
                baseDataValidator.reset().parameter("transferToSavingsId").value((Object)transferToSavingsId).notNull().longGreaterThanZero();
            }
        }
    }

    private void validateDepositDetailsForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        Long groupId;
        Long clientId = null;
        if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
            clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
            baseDataValidator.reset().parameter("clientId").value((Object)clientId).ignoreIfNull().longGreaterThanZero();
            groupId = null;
            if (this.fromApiJsonHelper.parameterExists("productId", element)) {
                groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
                baseDataValidator.reset().parameter("groupId").value((Object)groupId).ignoreIfNull().longGreaterThanZero();
            }
            if (clientId == null && groupId == null) {
                baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().integerGreaterThanZero();
            }
        }
        groupId = null;
        if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
            groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
            baseDataValidator.reset().parameter("groupId").value((Object)groupId).ignoreIfNull().longGreaterThanZero();
            if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
                clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
                baseDataValidator.reset().parameter("clientId").value((Object)clientId).ignoreIfNull().longGreaterThanZero();
            }
            if (clientId == null && groupId == null) {
                baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().integerGreaterThanZero();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("productId", element)) {
            Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
            baseDataValidator.reset().parameter("productId").value((Object)productId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("fieldOfficerId", element)) {
            Long fieldOfficerId = this.fromApiJsonHelper.extractLongNamed("fieldOfficerId", element);
            baseDataValidator.reset().parameter("fieldOfficerId").value((Object)fieldOfficerId).ignoreIfNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("accountNo", element)) {
            String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
            baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).notBlank().notExceedingLengthOf(Integer.valueOf(20));
        }
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("nominalAnnualInterestRate", element)) {
            BigDecimal interestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("nominalAnnualInterestRate", element);
            baseDataValidator.reset().parameter("nominalAnnualInterestRate").value((Object)interestRate).notNull().zeroOrPositiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("interestCompoundingPeriodType", element)) {
            Integer interestCompoundingPeriodType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCompoundingPeriodType", element);
            baseDataValidator.reset().parameter("interestCompoundingPeriodType").value((Object)interestCompoundingPeriodType).notNull().isOneOfTheseValues(SavingsCompoundingInterestPeriodType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("interestPostingPeriodType", element)) {
            Integer interestPostingPeriodType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestPostingPeriodType", element);
            baseDataValidator.reset().parameter("interestPostingPeriodType").value((Object)interestPostingPeriodType).notNull().isOneOfTheseValues(SavingsPostingInterestPeriodType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("interestCalculationType", element)) {
            Integer interestCalculationType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationType", element);
            baseDataValidator.reset().parameter("interestCalculationType").value((Object)interestCalculationType).notNull().isOneOfTheseValues(SavingsInterestCalculationType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("interestCalculationDaysInYearType", element)) {
            Integer interestCalculationDaysInYearType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationDaysInYearType", element);
            baseDataValidator.reset().parameter("interestCalculationDaysInYearType").value((Object)interestCalculationDaysInYearType).notNull().isOneOfTheseValues(SavingsInterestCalculationDaysInYearType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("minRequiredOpeningBalance", element)) {
            BigDecimal minOpeningBalance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minRequiredOpeningBalance", element);
            baseDataValidator.reset().parameter("minRequiredOpeningBalance").value((Object)minOpeningBalance).ignoreIfNull().zeroOrPositiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequency", element)) {
            Integer lockinPeriodFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("lockinPeriodFrequency", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinPeriodFrequency).ignoreIfNull().integerZeroOrGreater();
        }
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequencyType", element)) {
            Integer lockinPeriodFrequencyType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("lockinPeriodFrequencyType", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequencyType").value((Object)lockinPeriodFrequencyType).inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
        }
        boolean isLinkedAccRequired = false;
        if (this.fromApiJsonHelper.parameterExists("transferInterestToSavings", element)) {
            isLinkedAccRequired = this.fromApiJsonHelper.extractBooleanNamed("transferInterestToSavings", element);
        }
        if (this.fromApiJsonHelper.parameterExists("linkAccountId", element)) {
            Long linkAccountId = this.fromApiJsonHelper.extractLongNamed("linkAccountId", element);
            if (isLinkedAccRequired) {
                baseDataValidator.reset().parameter("linkAccountId").value((Object)linkAccountId).notNull().longGreaterThanZero();
            } else {
                baseDataValidator.reset().parameter("linkAccountId").value((Object)linkAccountId).ignoreIfNull().longGreaterThanZero();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("maturityInstructionId", element)) {
            Integer depositRolloverId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maturityInstructionId", element);
            baseDataValidator.reset().parameter("maturityInstructionId").value((Object)depositRolloverId).notNull().isOneOfTheseValues(DepositAccountOnClosureType.integerValues());
            if (depositRolloverId.equals(DepositAccountOnClosureType.TRANSFER_TO_SAVINGS.getValue())) {
                Long transferToSavingsId = this.fromApiJsonHelper.extractLongNamed("transferToSavingsId", element);
                baseDataValidator.reset().parameter("transferToSavingsId").value((Object)transferToSavingsId).notNull().longGreaterThanZero();
            }
        }
    }

    private void validatePreClosureDetailForSubmit(JsonElement element, DataValidatorBuilder baseDataValidator) {
        boolean preClosurePenalApplicable;
        if (this.fromApiJsonHelper.parameterExists("preClosurePenalApplicable", element) && (preClosurePenalApplicable = this.fromApiJsonHelper.extractBooleanNamed("preClosurePenalApplicable", element).booleanValue())) {
            BigDecimal penalInterestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("preClosurePenalInterest", element);
            baseDataValidator.reset().parameter("preClosurePenalInterest").value((Object)penalInterestRate).cantBeBlankWhenParameterProvidedIs("preClosurePenalApplicable", (Object)preClosurePenalApplicable).zeroOrPositiveAmount();
            Integer preClosurePenalInterestType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("preClosurePenalInterestOnTypeId", element);
            baseDataValidator.reset().parameter("preClosurePenalInterestOnTypeId").value((Object)preClosurePenalInterestType).cantBeBlankWhenParameterProvidedIs("preClosurePenalApplicable", (Object)preClosurePenalApplicable).isOneOfTheseValues(PreClosurePenalInterestOnType.integerValues());
        }
    }

    private void validatePreClosureDetailForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        this.productDataValidator.validatePreClosureDetailForUpdate(element, baseDataValidator);
    }

    private void validateDepositTermDeatilForSubmit(JsonElement element, DataValidatorBuilder baseDataValidator, DepositAccountType depositType) {
        Integer minTerm = null;
        if (this.fromApiJsonHelper.parameterExists("minDepositTerm", element)) {
            minTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("minDepositTerm", element);
            baseDataValidator.reset().parameter("minDepositTerm").value((Object)minTerm).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("maxDepositTerm", element)) {
            Integer maxTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maxDepositTerm", element);
            baseDataValidator.reset().parameter("maxDepositTerm").value((Object)maxTerm).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("minDepositTermTypeId", element)) {
            Integer minDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("minDepositTermTypeId", element);
            baseDataValidator.reset().parameter("minDepositTermTypeId").value((Object)minDepositTermType).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("maxDepositTermTypeId", element)) {
            Integer maxDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maxDepositTermTypeId", element);
            baseDataValidator.reset().parameter("maxDepositTermTypeId").value((Object)maxDepositTermType).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("inMultiplesOfDepositTerm", element)) {
            Integer inMultiplesOfDepositTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("inMultiplesOfDepositTerm", element);
            baseDataValidator.reset().parameter("inMultiplesOfDepositTerm").value((Object)inMultiplesOfDepositTerm).integerGreaterThanZero();
            Integer inMultiplesOfDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("inMultiplesOfDepositTermTypeId", element);
            baseDataValidator.reset().parameter("inMultiplesOfDepositTermTypeId").value((Object)inMultiplesOfDepositTermType).cantBeBlankWhenParameterProvidedIs("inMultiplesOfDepositTerm", (Object)inMultiplesOfDepositTerm).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (depositType.isFixedDeposit()) {
            BigDecimal depositAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("depositAmount", element);
            baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notNull().positiveAmount();
        }
        if (depositType.isFixedDeposit() || this.fromApiJsonHelper.parameterExists("depositPeriod", element)) {
            Integer depositPeriod = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("depositPeriod", element);
            baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).notNull().integerGreaterThanZero();
        }
        Integer depositPeriodFrequencyId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("depositPeriodFrequencyId", element);
        baseDataValidator.reset().parameter("depositPeriodFrequencyId").value((Object)depositPeriodFrequencyId).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
    }

    private void validateDepositTermDeatilForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator, DepositAccountType depositAccountType) {
        this.productDataValidator.validateDepositTermDetailForUpdate(element, baseDataValidator);
        if (this.fromApiJsonHelper.parameterExists("depositAmount", element)) {
            BigDecimal depositAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("depositAmount", element);
            baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notNull().positiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("depositPeriod", element)) {
            Integer depositPeriod = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("depositPeriod", element);
            if (depositAccountType.isFixedDeposit()) {
                baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).notNull().integerGreaterThanZero();
            } else {
                baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).notNull().integerGreaterThanZero();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("depositPeriodFrequencyId", element)) {
            Integer depositPeriodFrequencyId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("depositPeriodFrequencyId", element);
            baseDataValidator.reset().parameter("depositPeriodFrequencyId").value((Object)depositPeriodFrequencyId).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
    }

    private void validateForInterestCalc(JsonElement element, DataValidatorBuilder baseDataValidator) {
        BigDecimal principalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principalAmount", element);
        baseDataValidator.reset().parameter("principalAmount").value((Object)principalAmount).notNull().positiveAmount();
        BigDecimal annualInterestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("annualInterestRate", element);
        baseDataValidator.reset().parameter("annualInterestRate").value((Object)annualInterestRate).notNull().notLessThanMin(BigDecimal.valueOf(0L));
        Long tenureInMonths = this.fromApiJsonHelper.extractLongNamed("tenureInMonths", element);
        baseDataValidator.reset().parameter("tenureInMonths").value((Object)tenureInMonths).notNull().longGreaterThanZero();
        Long interestPostingPeriodInMonths = this.fromApiJsonHelper.extractLongNamed("interestPostingPeriodInMonths", element);
        baseDataValidator.reset().parameter("interestPostingPeriodInMonths").value((Object)interestPostingPeriodInMonths).notNull().longGreaterThanZero();
        Long interestCompoundingPeriodInMonths = this.fromApiJsonHelper.extractLongNamed("interestCompoundingPeriodInMonths", element);
        baseDataValidator.reset().parameter("interestCompoundingPeriodInMonths").value((Object)interestCompoundingPeriodInMonths).notNull();
        List<Long> allowedValues = List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(6L), Long.valueOf(12L));
        if (interestCompoundingPeriodInMonths != null && !allowedValues.contains(interestCompoundingPeriodInMonths)) {
            baseDataValidator.reset().parameter("interestCompoundingPeriodInMonths").value((Object)interestCompoundingPeriodInMonths).failWithCode("parameter.value.error", new Object[]{"interestCompoundingPeriodInMonths can only be one {1,2,3,4,6,12}"});
        }
        if (interestCompoundingPeriodInMonths != null && tenureInMonths != null && tenureInMonths % interestCompoundingPeriodInMonths != 0L) {
            baseDataValidator.reset().parameter("interestCompoundingPeriodInMonths").value((Object)interestCompoundingPeriodInMonths).failWithCode("parameter.relational.validation", new Object[]{"tenureInMonths must be perfectly divisible by interestCompoundingPeriodInMonths"});
        }
    }

    private void validateRecurringDetailForSubmit(JsonElement element, DataValidatorBuilder baseDataValidator) {
        String isCalendarInheritedString;
        BigDecimal mandatoryRecommendedDepositAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("mandatoryRecommendedDepositAmount", element);
        baseDataValidator.reset().parameter("mandatoryRecommendedDepositAmount").value((Object)mandatoryRecommendedDepositAmount).notNull().positiveAmount();
        if (this.fromApiJsonHelper.parameterExists("isMandatoryDeposit", element)) {
            Boolean isMandatoryDeposit = this.fromApiJsonHelper.extractBooleanNamed("isMandatoryDeposit", element);
            baseDataValidator.reset().parameter("isMandatoryDeposit").value((Object)isMandatoryDeposit).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("allowWithdrawal", element)) {
            Boolean allowWithdrawal = this.fromApiJsonHelper.extractBooleanNamed("allowWithdrawal", element);
            baseDataValidator.reset().parameter("allowWithdrawal").value((Object)allowWithdrawal).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("adjustAdvanceTowardsFuturePayments", element)) {
            Boolean adjustAdvanceTowardsFuturePayments = this.fromApiJsonHelper.extractBooleanNamed("adjustAdvanceTowardsFuturePayments", element);
            baseDataValidator.reset().parameter("adjustAdvanceTowardsFuturePayments").value((Object)adjustAdvanceTowardsFuturePayments).ignoreIfNull().validateForBooleanValue();
        }
        if (StringUtils.isBlank((CharSequence)(isCalendarInheritedString = this.fromApiJsonHelper.extractStringNamed("isCalendarInherited", element)))) {
            baseDataValidator.reset().parameter("isCalendarInherited").value((Object)isCalendarInheritedString).notBlank();
        } else {
            Boolean isCalendarInherited = this.fromApiJsonHelper.extractBooleanNamed("isCalendarInherited", element);
            baseDataValidator.reset().parameter("isCalendarInherited").value((Object)isCalendarInherited).notNull().validateForBooleanValue();
            if (!isCalendarInherited.booleanValue()) {
                Integer frequencyType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("recurringFrequencyType", element);
                baseDataValidator.reset().parameter("recurringFrequencyType").value((Object)frequencyType).notBlank().isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
                Integer frequency = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("recurringFrequency", element);
                baseDataValidator.reset().parameter("recurringFrequency").value((Object)frequency).notNull().integerGreaterThanZero();
            }
        }
    }

    private void validateRecurringDetailForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (this.fromApiJsonHelper.parameterExists("isMandatoryDeposit", element)) {
            Boolean isMandatoryDeposit = this.fromApiJsonHelper.extractBooleanNamed("isMandatoryDeposit", element);
            baseDataValidator.reset().parameter("isMandatoryDeposit").value((Object)isMandatoryDeposit).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("allowWithdrawal", element)) {
            Boolean allowWithdrawal = this.fromApiJsonHelper.extractBooleanNamed("allowWithdrawal", element);
            baseDataValidator.reset().parameter("allowWithdrawal").value((Object)allowWithdrawal).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("adjustAdvanceTowardsFuturePayments", element)) {
            Boolean adjustAdvanceTowardsFuturePayments = this.fromApiJsonHelper.extractBooleanNamed("adjustAdvanceTowardsFuturePayments", element);
            baseDataValidator.reset().parameter("adjustAdvanceTowardsFuturePayments").value((Object)adjustAdvanceTowardsFuturePayments).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("isCalendarInherited", element)) {
            Boolean isCalendarInherited = this.fromApiJsonHelper.extractBooleanNamed("isCalendarInherited", element);
            baseDataValidator.reset().parameter("isCalendarInherited").value((Object)isCalendarInherited).notNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("recurringFrequencyType", element)) {
            Integer frequencyType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("recurringFrequencyType", element);
            baseDataValidator.reset().parameter("recurringFrequencyType").value((Object)frequencyType).notBlank().isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("recurringFrequency", element)) {
            Integer frequency = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("recurringFrequency", element);
            baseDataValidator.reset().parameter("recurringFrequency").value((Object)frequency).notNull().integerGreaterThanZero();
        }
    }

    public void validatelinkedSavingsAccount(SavingsAccount linkedSavingsAccount, SavingsAccount savingsAccount) {
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        if (linkedSavingsAccount.isNotActive()) {
            ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.deposit.linked.savings.account.is.not.active", (String)("Linked Savings account with id:" + String.valueOf(linkedSavingsAccount.getId()) + " is not in active state"), (String)"linkAccountId", (Object[])new Object[]{linkedSavingsAccount.getId()});
            dataValidationErrors.add(error);
        } else if (!savingsAccount.clientId().equals(linkedSavingsAccount.clientId())) {
            ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.deposit.linked.savings.account.not.belongs.to.same.client", (String)("Linked Savings account with id:" + String.valueOf(linkedSavingsAccount.getId()) + " is not belongs to the same client"), (String)"linkAccountId", (Object[])new Object[]{linkedSavingsAccount.getId()});
            dataValidationErrors.add(error);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void throwLinkedAccountRequiredError() {
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.fixeddepositaccount.linkAccountId.cannot.be.blank", (String)"Linked Savings account required", (String)"linkAccountId", (Object[])new Object[0]);
        dataValidationErrors.add(error);
        throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
    }

    private void validateSavingsCharges(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (element.isJsonObject()) {
            JsonObject topLevelJsonElement = element.getAsJsonObject();
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            String monthDayFormat = this.fromApiJsonHelper.extractMonthDayFormatParameter(topLevelJsonElement);
            if (topLevelJsonElement.has("charges") && topLevelJsonElement.get("charges").isJsonArray()) {
                JsonArray array = topLevelJsonElement.get("charges").getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject savingsChargeElement = array.get(i).getAsJsonObject();
                    Long chargeId = this.fromApiJsonHelper.extractLongNamed("chargeId", (JsonElement)savingsChargeElement);
                    baseDataValidator.reset().parameter("chargeId").value((Object)chargeId).longGreaterThanZero();
                    BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed("amount", (JsonElement)savingsChargeElement, locale);
                    baseDataValidator.reset().parameter("amount").value((Object)amount).notNull().positiveAmount();
                    if (this.fromApiJsonHelper.parameterExists("feeOnMonthDay", (JsonElement)savingsChargeElement)) {
                        MonthDay monthDay = this.fromApiJsonHelper.extractMonthDayNamed("feeOnMonthDay", savingsChargeElement, monthDayFormat, locale);
                        baseDataValidator.reset().parameter("feeOnMonthDay").value((Object)monthDay).notNull();
                    }
                    if (!this.fromApiJsonHelper.parameterExists("feeInterval", (JsonElement)savingsChargeElement)) continue;
                    Integer feeInterval = this.fromApiJsonHelper.extractIntegerNamed("feeInterval", (JsonElement)savingsChargeElement, Locale.getDefault());
                    baseDataValidator.reset().parameter("feeInterval").value((Object)feeInterval).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(12));
                }
            }
        }
    }

    private void validateWithHoldTax(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (this.fromApiJsonHelper.parameterExists("withHoldTax", element)) {
            String withHoldTax = this.fromApiJsonHelper.extractStringNamed("withHoldTax", element);
            baseDataValidator.reset().parameter("withHoldTax").value((Object)withHoldTax).ignoreIfNull().validateForBooleanValue();
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

