/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.note.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.portfolio.note.data.NoteData;
import org.apache.fineract.portfolio.note.domain.NoteType;
import org.apache.fineract.portfolio.note.exception.NoteNotFoundException;
import org.apache.fineract.portfolio.note.service.NoteReadPlatformService;
import org.apache.fineract.portfolio.note.service.NoteReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class NoteReadPlatformServiceImpl
implements NoteReadPlatformService {
    private final JdbcTemplate jdbcTemplate;

    public NoteReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public NoteData retrieveNote(Long noteId, Long resourceId, Integer noteTypeId) {
        NoteType noteType = NoteType.fromInt((int)noteTypeId);
        try {
            NoteMapper rm = new NoteMapper();
            ArrayList<Long> paramList = new ArrayList<Long>(Arrays.asList(noteId, resourceId));
            Object conditionSql = NoteReadPlatformServiceImpl.getResourceCondition((NoteType)noteType, paramList);
            if (StringUtils.isNotBlank((CharSequence)conditionSql)) {
                conditionSql = " and " + (String)conditionSql;
            }
            String sql = rm.schema() + " where n.id = ? " + (String)conditionSql + " order by n.created_date DESC";
            return (NoteData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, paramList.toArray());
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoteNotFoundException(noteId, resourceId, noteType.name().toLowerCase(), e);
        }
    }

    public List<NoteData> retrieveNotesByResource(Long resourceId, Integer noteTypeId) {
        NoteType noteType = NoteType.fromInt((int)noteTypeId);
        NoteMapper rm = new NoteMapper();
        ArrayList<Long> paramList = new ArrayList<Long>(Arrays.asList(resourceId));
        String conditionSql = NoteReadPlatformServiceImpl.getResourceCondition((NoteType)noteType, paramList);
        String sql = rm.schema() + " where " + conditionSql + " order by n.created_date DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, paramList.toArray());
    }

    public static String getResourceCondition(NoteType noteType, List<Object> paramList) {
        String conditionSql = "";
        switch (1.$SwitchMap$org$apache$fineract$portfolio$note$domain$NoteType[noteType.ordinal()]) {
            case 1: {
                paramList.add(NoteType.CLIENT.getValue());
                conditionSql = " n.client_id = ? and note_type_enum = ?";
                break;
            }
            case 2: {
                paramList.add(NoteType.LOAN.getValue());
                paramList.add(NoteType.LOAN_TRANSACTION.getValue());
                conditionSql = " n.loan_id = ? and ( n.note_type_enum = ? or n.note_type_enum = ? )";
                break;
            }
            case 3: {
                conditionSql = " n.loan_transaction_id = ? ";
                break;
            }
            case 4: {
                paramList.add(NoteType.SAVING_ACCOUNT.getValue());
                paramList.add(NoteType.SAVINGS_TRANSACTION.getValue());
                conditionSql = " n.savings_account_id = ? and ( n.note_type_enum = ? or n.note_type_enum = ? ) ";
                break;
            }
            case 5: {
                conditionSql = " n.savings_account_transaction_id = ? ";
                break;
            }
            case 6: {
                conditionSql = " n.group_id = ? ";
                break;
            }
        }
        return conditionSql;
    }
}

