/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.floatingrates.domain.FloatingRate;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.AprCalculator;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductFloatingRatesUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductGuaranteeDetailsAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductGuaranteeDetailsUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductInterestRecalculationDetailsAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductInterestRecalculationDetailsUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductMinMaxConstraintsUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductRelatedDetailUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductTrancheDetailsUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductVariableInstallmentConfigUpdateUtil;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductBorrowerCycleVariations;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductConfigurableAttributes;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductParamType;
import org.apache.fineract.portfolio.loanproduct.domain.RepaymentStartDateType;
import org.springframework.stereotype.Service;

@Service
public class LoanProductUpdateUtil {
    private final LoanProductRelatedDetailUpdateUtil detailUpdateUtil;
    private final LoanProductMinMaxConstraintsUpdateUtil minMaxConstraintsUpdateUtil;
    private final LoanProductFloatingRatesUpdateUtil floatingRatesUpdateUtil;
    private final LoanProductVariableInstallmentConfigUpdateUtil variableInstallmentConfigUpdateUtil;
    private final LoanProductTrancheDetailsUpdateUtil trancheDetailsUpdateUtil;
    private final LoanProductInterestRecalculationDetailsAssembler interestRecalculationDetailsAssembler;
    private final LoanProductInterestRecalculationDetailsUpdateUtil interestRecalculationDetailsUpdateUtil;
    private final LoanProductGuaranteeDetailsAssembler guaranteeDetailsAssembler;
    private final LoanProductGuaranteeDetailsUpdateUtil guaranteeDetailsUpdateUtil;

    public Map<String, Object> update(LoanProduct loanProduct, JsonCommand command, AprCalculator aprCalculator, FloatingRate floatingRate) {
        JsonArray jsonArray;
        Number newValue;
        boolean isInterestRecalculationEnabledChanged;
        Object newValue2;
        boolean newValue3;
        JsonArray jsonArray2;
        JsonArray jsonArray3;
        JsonArray jsonArray4;
        Integer currentValue;
        boolean newValue4;
        Map actualChanges = this.detailUpdateUtil.updateLoanRepaymentSchedule(loanProduct.getLoanProductRelatedDetail(), command, aprCalculator);
        actualChanges.putAll(this.minMaxConstraintsUpdateUtil.update(loanProduct.loanProductMinMaxConstraints(), command));
        String isLinkedToFloatingInterestRates = "isLinkedToFloatingInterestRates";
        if (command.isChangeInBooleanParameterNamed("isLinkedToFloatingInterestRates", Boolean.valueOf(loanProduct.isLinkedToFloatingInterestRate()))) {
            newValue4 = command.booleanPrimitiveValueOfParameterNamed("isLinkedToFloatingInterestRates");
            actualChanges.put("isLinkedToFloatingInterestRates", newValue4);
            loanProduct.setLinkedToFloatingInterestRate(newValue4);
        }
        if (command.isChangeInBooleanParameterNamed("enableAccrualActivityPosting", Boolean.valueOf(loanProduct.getLoanProductRelatedDetail().isEnableAccrualActivityPosting()))) {
            newValue4 = command.booleanPrimitiveValueOfParameterNamed("enableAccrualActivityPosting");
            actualChanges.put("enableAccrualActivityPosting", newValue4);
            loanProduct.getLoanProductRelatedDetail().setEnableAccrualActivityPosting(newValue4);
        }
        if (loanProduct.isLinkedToFloatingInterestRate()) {
            actualChanges.putAll(this.floatingRatesUpdateUtil.update(loanProduct.loanProductFloatingRates(), command, floatingRate));
            loanProduct.getLoanProductRelatedDetail().updateForFloatingInterestRates();
            loanProduct.getLoanProductMinMaxConstraints().updateForFloatingInterestRates();
        } else {
            loanProduct.setFloatingRates(null);
        }
        if (command.isChangeInBooleanParameterNamed("allowVariableInstallments", Boolean.valueOf(loanProduct.isAllowVariabeInstallments()))) {
            newValue4 = command.booleanPrimitiveValueOfParameterNamed("allowVariableInstallments");
            actualChanges.put("allowVariableInstallments", newValue4);
            loanProduct.setAllowVariabeInstallments(newValue4);
        }
        if (loanProduct.isAllowVariabeInstallments()) {
            actualChanges.putAll(this.variableInstallmentConfigUpdateUtil.update(loanProduct.loanProductVariableInstallmentConfig(), command));
        } else {
            loanProduct.setVariableInstallmentConfig(null);
        }
        String accountingTypeParamName = "accountingRule";
        Integer n = currentValue = loanProduct.getAccountingRule() == null ? null : loanProduct.getAccountingRule().getValue();
        if (command.isChangeInIntegerParameterNamed("accountingRule", currentValue)) {
            Integer newValue5 = command.integerValueOfParameterNamed("accountingRule");
            actualChanges.put("accountingRule", newValue5);
            loanProduct.setAccountingRule(AccountingRuleType.fromInt((Integer)newValue5));
        }
        String nameParamName = "name";
        if (command.isChangeInStringParameterNamed("name", loanProduct.getName())) {
            String newValue6 = command.stringValueOfParameterNamed("name");
            actualChanges.put("name", newValue6);
            loanProduct.setName(newValue6);
        }
        String shortNameParamName = "shortName";
        if (command.isChangeInStringParameterNamed("shortName", loanProduct.getShortName())) {
            String newValue7 = command.stringValueOfParameterNamed("shortName");
            actualChanges.put("shortName", newValue7);
            loanProduct.setShortName(newValue7);
        }
        String descriptionParamName = "description";
        if (command.isChangeInStringParameterNamed("description", loanProduct.getDescription())) {
            String newValue8 = command.stringValueOfParameterNamed("description");
            actualChanges.put("description", newValue8);
            loanProduct.setDescription(newValue8);
        }
        Long existingFundId = null;
        if (loanProduct.getFund() != null) {
            existingFundId = (Long)loanProduct.getFund().getId();
        }
        String fundIdParamName = "fundId";
        if (command.isChangeInLongParameterNamed("fundId", existingFundId)) {
            Long newValue9 = command.longValueOfParameterNamed("fundId");
            actualChanges.put("fundId", newValue9);
        }
        String transactionProcessingStrategyCodeParamName = "transactionProcessingStrategyCode";
        if (command.isChangeInStringParameterNamed("transactionProcessingStrategyCode", loanProduct.getTransactionProcessingStrategyCode())) {
            String newValue10 = command.stringValueOfParameterNamed("transactionProcessingStrategyCode");
            actualChanges.put("transactionProcessingStrategyCode", newValue10);
        }
        String paymentAllocationParamName = "paymentAllocation";
        if (command.hasParameter("paymentAllocation") && (jsonArray4 = command.arrayOfParameterNamed("paymentAllocation")) != null) {
            actualChanges.put("paymentAllocation", command.jsonFragment("paymentAllocation"));
        }
        String creditAllocationParamName = "creditAllocation";
        if (command.hasParameter("creditAllocation") && (jsonArray3 = command.arrayOfParameterNamed("creditAllocation")) != null) {
            actualChanges.put("creditAllocation", command.jsonFragment("creditAllocation"));
        }
        String chargesParamName = "charges";
        if (command.hasParameter("charges") && (jsonArray2 = command.arrayOfParameterNamed("charges")) != null) {
            actualChanges.put("charges", command.jsonFragment("charges"));
        }
        String includeInBorrowerCycleParamName = "includeInBorrowerCycle";
        if (command.isChangeInBooleanParameterNamed("includeInBorrowerCycle", Boolean.valueOf(loanProduct.isIncludeInBorrowerCycle()))) {
            newValue3 = command.booleanPrimitiveValueOfParameterNamed("includeInBorrowerCycle");
            actualChanges.put("includeInBorrowerCycle", newValue3);
            loanProduct.setIncludeInBorrowerCycle(newValue3);
        }
        if (command.isChangeInBooleanParameterNamed("useBorrowerCycle", Boolean.valueOf(loanProduct.isUseBorrowerCycle()))) {
            newValue3 = command.booleanPrimitiveValueOfParameterNamed("useBorrowerCycle");
            actualChanges.put("useBorrowerCycle", newValue3);
            loanProduct.setUseBorrowerCycle(newValue3);
        }
        if (loanProduct.isUseBorrowerCycle()) {
            actualChanges.putAll(this.updateBorrowerCycleVariations(loanProduct, command));
        } else {
            this.clearVariations(loanProduct);
        }
        String dateFormatAsInput = command.dateFormat();
        String localeAsInput = command.locale();
        String localeParamName = "locale";
        String dateFormatParamName = "dateFormat";
        String startDateParamName = "startDate";
        if (command.isChangeInLocalDateParameterNamed("startDate", loanProduct.getStartDate())) {
            String valueAsInput = command.stringValueOfParameterNamed("startDate");
            actualChanges.put("startDate", valueAsInput);
            actualChanges.put("dateFormat", dateFormatAsInput);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setStartDate(command.localDateValueOfParameterNamed("startDate"));
        }
        String closeDateParamName = "closeDate";
        if (command.isChangeInLocalDateParameterNamed("closeDate", loanProduct.getCloseDate())) {
            String valueAsInput = command.stringValueOfParameterNamed("closeDate");
            actualChanges.put("closeDate", valueAsInput);
            actualChanges.put("dateFormat", dateFormatAsInput);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setCloseDate(command.localDateValueOfParameterNamed("closeDate"));
        }
        String externalIdTypeParamName = "externalId";
        if (command.isChangeInExternalIdParameterNamed("externalId", loanProduct.getExternalId())) {
            newValue2 = ExternalIdFactory.produce((String)command.stringValueOfParameterNamed("externalId"));
            actualChanges.put("accountingRule", newValue2);
            loanProduct.setExternalId(newValue2);
        }
        this.trancheDetailsUpdateUtil.update(loanProduct.getLoanProductTrancheDetails(), command, actualChanges);
        if (command.isChangeInIntegerParameterNamed("overdueDaysForNPA", loanProduct.getOverdueDaysForNPA())) {
            newValue2 = command.integerValueOfParameterNamed("overdueDaysForNPA");
            actualChanges.put("overdueDaysForNPA", newValue2);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setOverdueDaysForNPA((Integer)newValue2);
        }
        if (command.isChangeInIntegerParameterNamed("minimumDaysBetweenDisbursalAndFirstRepayment", loanProduct.getMinimumDaysBetweenDisbursalAndFirstRepayment())) {
            newValue2 = command.integerValueOfParameterNamed("minimumDaysBetweenDisbursalAndFirstRepayment");
            actualChanges.put("minimumDaysBetweenDisbursalAndFirstRepayment", newValue2);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setMinimumDaysBetweenDisbursalAndFirstRepayment((Integer)newValue2);
        }
        if (command.isChangeInBooleanParameterNamed("syncExpectedWithDisbursementDate", Boolean.valueOf(loanProduct.isSyncExpectedWithDisbursementDate()))) {
            boolean newValue11 = command.booleanPrimitiveValueOfParameterNamed("syncExpectedWithDisbursementDate");
            actualChanges.put("syncExpectedWithDisbursementDate", newValue11);
            loanProduct.setSyncExpectedWithDisbursementDate(newValue11);
        }
        Long delinquencyBucketId = null;
        if (loanProduct.getDelinquencyBucket() != null) {
            delinquencyBucketId = (Long)loanProduct.getDelinquencyBucket().getId();
        }
        if (command.isChangeInLongParameterNamed("delinquencyBucketId", delinquencyBucketId)) {
            Long newValue12 = command.longValueOfParameterNamed("delinquencyBucketId");
            actualChanges.put("delinquencyBucketId", newValue12);
        }
        if (isInterestRecalculationEnabledChanged = actualChanges.containsKey("isInterestRecalculationEnabled")) {
            if (loanProduct.isInterestRecalculationEnabled()) {
                loanProduct.setProductInterestRecalculationDetails(this.interestRecalculationDetailsAssembler.createFrom(command));
                loanProduct.getProductInterestRecalculationDetails().updateProduct(loanProduct);
                actualChanges.put("interestRecalculationCompoundingMethod", command.integerValueOfParameterNamed("interestRecalculationCompoundingMethod"));
                actualChanges.put("rescheduleStrategyMethod", command.integerValueOfParameterNamed("rescheduleStrategyMethod"));
            } else {
                loanProduct.setProductInterestRecalculationDetails(null);
            }
        }
        if (!isInterestRecalculationEnabledChanged && loanProduct.isInterestRecalculationEnabled()) {
            this.interestRecalculationDetailsUpdateUtil.update(loanProduct.getProductInterestRecalculationDetails(), command, actualChanges, localeAsInput);
        }
        if (command.isChangeInBooleanParameterNamed("holdGuaranteeFunds", Boolean.valueOf(loanProduct.isHoldGuaranteeFunds()))) {
            boolean newValue13 = command.booleanPrimitiveValueOfParameterNamed("holdGuaranteeFunds");
            actualChanges.put("holdGuaranteeFunds", newValue13);
            loanProduct.setHoldGuaranteeFunds(newValue13);
        }
        String configurableAttributesChanges = "allowAttributeOverrides";
        if (command.hasParameter("allowAttributeOverrides")) {
            if (!command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").isJsonNull()) {
                actualChanges.put("allowAttributeOverrides", command.jsonFragment("allowAttributeOverrides"));
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("amortizationType").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getAmortizationBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setAmortizationType(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("amortizationType").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("interestType").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getInterestMethodBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setInterestType(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("interestType").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("transactionProcessingStrategyCode").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getTransactionProcessingStrategyBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setTransactionProcessingStrategyCode(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("transactionProcessingStrategyCode").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("interestCalculationPeriodType").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getInterestCalcPeriodBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setInterestCalculationPeriodType(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("interestCalculationPeriodType").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("inArrearsTolerance").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getArrearsToleranceBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setInArrearsTolerance(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("inArrearsTolerance").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("repaymentEvery").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getRepaymentEveryBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setRepaymentEvery(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("repaymentEvery").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("graceOnPrincipalAndInterestPayment").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getGraceOnPrincipalAndInterestPaymentBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setGraceOnPrincipalAndInterestPayment(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("graceOnPrincipalAndInterestPayment").getAsBoolean()));
                }
                if (command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("graceOnArrearsAgeing").getAsBoolean() != loanProduct.getLoanConfigurableAttributes().getGraceOnArrearsAgingBoolean().booleanValue()) {
                    loanProduct.getLoanConfigurableAttributes().setGraceOnArrearsAgeing(Boolean.valueOf(command.parsedJson().getAsJsonObject().getAsJsonObject("allowAttributeOverrides").getAsJsonPrimitive("graceOnArrearsAgeing").getAsBoolean()));
                }
            } else {
                loanProduct.setLoanConfigurableAttributes(LoanProductConfigurableAttributes.populateDefaultsForConfigurableAttributes());
                loanProduct.getLoanConfigurableAttributes().updateLoanProduct(loanProduct);
            }
        }
        if (actualChanges.containsKey("holdGuaranteeFunds")) {
            if (loanProduct.isHoldGuaranteeFunds()) {
                loanProduct.setLoanProductGuaranteeDetails(this.guaranteeDetailsAssembler.createFrom(command));
                loanProduct.getLoanProductGuaranteeDetails().updateProduct(loanProduct);
                actualChanges.put("mandatoryGuarantee", loanProduct.getLoanProductGuaranteeDetails().getMandatoryGuarantee());
                actualChanges.put("minimumGuaranteeFromGuarantor", loanProduct.getLoanProductGuaranteeDetails().getMinimumGuaranteeFromGuarantor());
                actualChanges.put("minimumGuaranteeFromOwnFunds", loanProduct.getLoanProductGuaranteeDetails().getMinimumGuaranteeFromOwnFunds());
            } else {
                loanProduct.setLoanProductRelatedDetail(null);
            }
        } else if (loanProduct.isHoldGuaranteeFunds()) {
            this.guaranteeDetailsUpdateUtil.update(loanProduct.getLoanProductGuaranteeDetails(), command, actualChanges);
        }
        if (command.isChangeInBigDecimalParameterNamed("principalThresholdForLastInstallment", loanProduct.getPrincipalThresholdForLastInstallment())) {
            newValue = command.bigDecimalValueOfParameterNamed("principalThresholdForLastInstallment");
            actualChanges.put("principalThresholdForLastInstallment", newValue);
            loanProduct.setPrincipalThresholdForLastInstallment(newValue);
        }
        if (command.isChangeInBooleanParameterNamed("accountMovesOutOfNPAOnlyOnArrearsCompletion", Boolean.valueOf(loanProduct.isAccountMovesOutOfNPAOnlyOnArrearsCompletion()))) {
            boolean newValue14 = command.booleanPrimitiveValueOfParameterNamed("accountMovesOutOfNPAOnlyOnArrearsCompletion");
            actualChanges.put("accountMovesOutOfNPAOnlyOnArrearsCompletion", newValue14);
            loanProduct.setAccountMovesOutOfNPAOnlyOnArrearsCompletion(newValue14);
        }
        if (command.isChangeInBooleanParameterNamed("canDefineInstallmentAmount", Boolean.valueOf(loanProduct.isCanDefineInstallmentAmount()))) {
            boolean newValue15 = command.booleanPrimitiveValueOfParameterNamed("canDefineInstallmentAmount");
            actualChanges.put("canDefineInstallmentAmount", newValue15);
            loanProduct.setCanDefineInstallmentAmount(newValue15);
        }
        if (command.isChangeInIntegerParameterNamedWithNullCheck("installmentAmountInMultiplesOf", loanProduct.getLoanProductRelatedDetail().getInstallmentAmountInMultiplesOf())) {
            newValue = command.integerValueOfParameterNamed("installmentAmountInMultiplesOf");
            actualChanges.put("installmentAmountInMultiplesOf", newValue);
            actualChanges.put("locale", localeAsInput);
            loanProduct.getLoanProductRelatedDetail().setInstallmentAmountInMultiplesOf((Integer)newValue);
        }
        if (command.isChangeInBooleanParameterNamed("canUseForTopup", Boolean.valueOf(loanProduct.isCanUseForTopup()))) {
            boolean newValue16 = command.booleanPrimitiveValueOfParameterNamed("canUseForTopup");
            actualChanges.put("canUseForTopup", newValue16);
            loanProduct.setCanUseForTopup(newValue16);
        }
        if (command.hasParameter("rates") && (jsonArray = command.arrayOfParameterNamed("rates")) != null) {
            actualChanges.put("rates", command.jsonFragment("rates"));
        }
        if (command.isChangeInBigDecimalParameterNamed("fixedPrincipalPercentagePerInstallment", loanProduct.getFixedPrincipalPercentagePerInstallment())) {
            BigDecimal newValue17 = command.bigDecimalValueOfParameterNamed("fixedPrincipalPercentagePerInstallment");
            actualChanges.put("fixedPrincipalPercentagePerInstallment", newValue17);
            loanProduct.setFixedPrincipalPercentagePerInstallment(newValue17);
        }
        if (command.isChangeInBooleanParameterNamed("disallowExpectedDisbursements", Boolean.valueOf(loanProduct.isDisallowExpectedDisbursements()))) {
            boolean newValue18 = command.booleanPrimitiveValueOfParameterNamed("disallowExpectedDisbursements");
            actualChanges.put("disallowExpectedDisbursements", newValue18);
            loanProduct.setDisallowExpectedDisbursements(newValue18);
        }
        if (command.isChangeInBooleanParameterNamed("allowApprovedDisbursedAmountsOverApplied", Boolean.valueOf(loanProduct.isAllowApprovedDisbursedAmountsOverApplied()))) {
            boolean newValue19 = command.booleanPrimitiveValueOfParameterNamed("allowApprovedDisbursedAmountsOverApplied");
            actualChanges.put("allowApprovedDisbursedAmountsOverApplied", newValue19);
            loanProduct.setAllowApprovedDisbursedAmountsOverApplied(newValue19);
        }
        if (command.isChangeInStringParameterNamed("overAppliedCalculationType", loanProduct.getOverAppliedCalculationType())) {
            String newValue20 = command.stringValueOfParameterNamed("overAppliedCalculationType");
            actualChanges.put("overAppliedCalculationType", newValue20);
            loanProduct.setOverAppliedCalculationType(newValue20);
        }
        if (command.isChangeInIntegerParameterNamed("overAppliedNumber", loanProduct.getOverAppliedNumber())) {
            Integer newValue21 = command.integerValueOfParameterNamed("overAppliedNumber");
            actualChanges.put("overAppliedNumber", newValue21);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setOverAppliedNumber(newValue21);
        }
        if (command.isChangeInIntegerParameterNamed("dueDaysForRepaymentEvent", loanProduct.getDueDaysForRepaymentEvent())) {
            Integer newValue22 = command.integerValueOfParameterNamed("dueDaysForRepaymentEvent");
            actualChanges.put("dueDaysForRepaymentEvent", newValue22);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setDueDaysForRepaymentEvent(newValue22);
        }
        if (command.isChangeInIntegerParameterNamed("overDueDaysForRepaymentEvent", loanProduct.getOverDueDaysForRepaymentEvent())) {
            Integer newValue23 = command.integerValueOfParameterNamed("overDueDaysForRepaymentEvent");
            actualChanges.put("overDueDaysForRepaymentEvent", newValue23);
            actualChanges.put("locale", localeAsInput);
            loanProduct.setOverDueDaysForRepaymentEvent(newValue23);
        }
        if (command.isChangeInBooleanParameterNamed("enableDownPayment", Boolean.valueOf(loanProduct.getLoanProductRelatedDetail().isEnableDownPayment()))) {
            boolean newValue24 = command.booleanPrimitiveValueOfParameterNamed("enableDownPayment");
            actualChanges.put("enableDownPayment", newValue24);
            loanProduct.getLoanProductRelatedDetail().setEnableDownPayment(newValue24);
        }
        if (command.isChangeInBigDecimalParameterNamed("disbursedAmountPercentageForDownPayment", loanProduct.getLoanProductRelatedDetail().getDisbursedAmountPercentageForDownPayment())) {
            BigDecimal newValue25 = command.bigDecimalValueOfParameterNamed("disbursedAmountPercentageForDownPayment");
            actualChanges.put("disbursedAmountPercentageForDownPayment", newValue25);
            loanProduct.getLoanProductRelatedDetail().setDisbursedAmountPercentageForDownPayment(newValue25);
        }
        if (command.isChangeInBooleanParameterNamed("enableAutoRepaymentForDownPayment", Boolean.valueOf(loanProduct.getLoanProductRelatedDetail().isEnableAutoRepaymentForDownPayment()))) {
            boolean newValue26 = command.booleanPrimitiveValueOfParameterNamed("enableAutoRepaymentForDownPayment");
            actualChanges.put("enableAutoRepaymentForDownPayment", newValue26);
            loanProduct.getLoanProductRelatedDetail().setEnableAutoRepaymentForDownPayment(newValue26);
        }
        if (command.isChangeInIntegerParameterNamed("repaymentStartDateType", loanProduct.getRepaymentStartDateType().getValue())) {
            Integer newValue27 = command.integerValueOfParameterNamed("repaymentStartDateType");
            actualChanges.put("repaymentStartDateType", newValue27);
            loanProduct.setRepaymentStartDateType(RepaymentStartDateType.fromInt((Integer)newValue27));
        }
        if (command.isChangeInBooleanParameterNamed("enableInstallmentLevelDelinquency", Boolean.valueOf(loanProduct.isEnableInstallmentLevelDelinquency()))) {
            boolean newValue28 = command.booleanPrimitiveValueOfParameterNamed("enableInstallmentLevelDelinquency");
            actualChanges.put("enableInstallmentLevelDelinquency", newValue28);
            loanProduct.updateEnableInstallmentLevelDelinquency(newValue28);
        }
        if (command.isChangeInIntegerParameterNamed("fixedLength", loanProduct.getLoanProductRelatedDetail().getFixedLength())) {
            Integer newValue29 = command.integerValueOfParameterNamed("fixedLength");
            actualChanges.put("fixedLength", newValue29);
            loanProduct.getLoanProductRelatedDetail().setFixedLength(newValue29);
        }
        return actualChanges;
    }

    private Map<String, Object> updateBorrowerCycleVariations(LoanProduct loanProduct, JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(20);
        List variationIds = this.fetchAllVariationIds(loanProduct);
        this.updateBorrowerCycleVariations(loanProduct, command, LoanProductParamType.PRINCIPAL.getValue(), "principalVariationsForBorrowerCycle", actualChanges, variationIds);
        this.updateBorrowerCycleVariations(loanProduct, command, LoanProductParamType.INTERESTRATE.getValue(), "interestRateVariationsForBorrowerCycle", actualChanges, variationIds);
        this.updateBorrowerCycleVariations(loanProduct, command, LoanProductParamType.REPAYMENT.getValue(), "numberOfRepaymentVariationsForBorrowerCycle", actualChanges, variationIds);
        for (Long id : variationIds) {
            loanProduct.getBorrowerCycleVariations().remove(this.fetchLoanProductBorrowerCycleVariationById(loanProduct, id));
        }
        return actualChanges;
    }

    public LoanProductBorrowerCycleVariations fetchLoanProductBorrowerCycleVariationById(LoanProduct loanProduct, Long id) {
        LoanProductBorrowerCycleVariations borrowerCycleVariation = null;
        for (LoanProductBorrowerCycleVariations cycleVariation : loanProduct.getBorrowerCycleVariations()) {
            if (!id.equals(cycleVariation.getId())) continue;
            borrowerCycleVariation = cycleVariation;
            break;
        }
        return borrowerCycleVariation;
    }

    private List<Long> fetchAllVariationIds(LoanProduct loanProduct) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (LoanProductBorrowerCycleVariations cycleVariation : loanProduct.getBorrowerCycleVariations()) {
            list.add((Long)cycleVariation.getId());
        }
        return list;
    }

    private void updateBorrowerCycleVariations(LoanProduct loanProduct, JsonCommand command, Integer paramType, String variationParameterName, Map<String, Object> actualChanges, List<Long> variationIds) {
        JsonArray variationArray;
        if (command.parameterExists(variationParameterName) && (variationArray = command.arrayOfParameterNamed(variationParameterName)) != null && variationArray.size() > 0) {
            int i = 0;
            do {
                JsonObject jsonObject = variationArray.get(i).getAsJsonObject();
                BigDecimal defaultValue = null;
                BigDecimal minValue = null;
                BigDecimal maxValue = null;
                Integer cycleNumber = null;
                Integer valueUsageCondition = null;
                Long id = null;
                if (jsonObject.has("defaultValue") && jsonObject.get("defaultValue").isJsonPrimitive()) {
                    defaultValue = jsonObject.getAsJsonPrimitive("defaultValue").getAsBigDecimal();
                }
                if (jsonObject.has("minValue") && jsonObject.get("minValue").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("minValue").getAsString())) {
                    minValue = jsonObject.getAsJsonPrimitive("minValue").getAsBigDecimal();
                }
                if (jsonObject.has("maxValue") && jsonObject.get("maxValue").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("maxValue").getAsString())) {
                    maxValue = jsonObject.getAsJsonPrimitive("maxValue").getAsBigDecimal();
                }
                if (jsonObject.has("borrowerCycleNumber") && jsonObject.get("borrowerCycleNumber").isJsonPrimitive()) {
                    cycleNumber = jsonObject.getAsJsonPrimitive("borrowerCycleNumber").getAsInt();
                }
                if (jsonObject.has("valueConditionType") && jsonObject.get("valueConditionType").isJsonPrimitive()) {
                    valueUsageCondition = jsonObject.getAsJsonPrimitive("valueConditionType").getAsInt();
                }
                if (jsonObject.has("id") && jsonObject.get("id").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("id").getAsString())) {
                    id = jsonObject.getAsJsonPrimitive("id").getAsLong();
                }
                LoanProductBorrowerCycleVariations borrowerCycleVariations = new LoanProductBorrowerCycleVariations(cycleNumber, paramType, valueUsageCondition, minValue, maxValue, defaultValue);
                if (id == null) {
                    borrowerCycleVariations.updateLoanProduct(loanProduct);
                    loanProduct.getBorrowerCycleVariations().add(borrowerCycleVariations);
                    actualChanges.put("borrowerCycleParamType", paramType);
                    continue;
                }
                variationIds.remove(id);
                LoanProductBorrowerCycleVariations existingCycleVariation = this.fetchLoanProductBorrowerCycleVariationById(loanProduct, id);
                if (existingCycleVariation.equals((Object)borrowerCycleVariations)) continue;
                existingCycleVariation.copy(borrowerCycleVariations);
                actualChanges.put("borrowerCycleId", id);
            } while (++i < variationArray.size());
        }
    }

    private void clearVariations(LoanProduct loanProduct) {
        loanProduct.getBorrowerCycleVariations().clear();
    }

    @Generated
    public LoanProductUpdateUtil(LoanProductRelatedDetailUpdateUtil detailUpdateUtil, LoanProductMinMaxConstraintsUpdateUtil minMaxConstraintsUpdateUtil, LoanProductFloatingRatesUpdateUtil floatingRatesUpdateUtil, LoanProductVariableInstallmentConfigUpdateUtil variableInstallmentConfigUpdateUtil, LoanProductTrancheDetailsUpdateUtil trancheDetailsUpdateUtil, LoanProductInterestRecalculationDetailsAssembler interestRecalculationDetailsAssembler, LoanProductInterestRecalculationDetailsUpdateUtil interestRecalculationDetailsUpdateUtil, LoanProductGuaranteeDetailsAssembler guaranteeDetailsAssembler, LoanProductGuaranteeDetailsUpdateUtil guaranteeDetailsUpdateUtil) {
        this.detailUpdateUtil = detailUpdateUtil;
        this.minMaxConstraintsUpdateUtil = minMaxConstraintsUpdateUtil;
        this.floatingRatesUpdateUtil = floatingRatesUpdateUtil;
        this.variableInstallmentConfigUpdateUtil = variableInstallmentConfigUpdateUtil;
        this.trancheDetailsUpdateUtil = trancheDetailsUpdateUtil;
        this.interestRecalculationDetailsAssembler = interestRecalculationDetailsAssembler;
        this.interestRecalculationDetailsUpdateUtil = interestRecalculationDetailsUpdateUtil;
        this.guaranteeDetailsAssembler = guaranteeDetailsAssembler;
        this.guaranteeDetailsUpdateUtil = guaranteeDetailsUpdateUtil;
    }
}

