/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.loanschedule.service;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LoanScheduleHistoryReadPlatformServiceImpl
implements LoanScheduleHistoryReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public LoanScheduleHistoryReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Integer fetchCurrentVersionNumber(Long loanId) {
        String sql = "select MAX(lrs.version) from m_loan_repayment_schedule_history lrs where lrs.loan_id = ?";
        Integer max = (Integer)this.jdbcTemplate.queryForObject("select MAX(lrs.version) from m_loan_repayment_schedule_history lrs where lrs.loan_id = ?", new Object[]{loanId}, Integer.class);
        return (Integer)ObjectUtils.defaultIfNull((Object)max, (Object)0);
    }

    public LoanScheduleData retrieveRepaymentArchiveSchedule(Long loanId, RepaymentScheduleRelatedLoanData repaymentScheduleRelatedLoanData, Collection<DisbursementData> disbursementData, LoanScheduleType loanScheduleType) {
        try {
            this.context.authenticatedUser();
            Integer versionNumber = this.fetchCurrentVersionNumber(loanId);
            if (versionNumber == 0) {
                return null;
            }
            LoanScheduleArchiveResultSetExtractor fullResultsetExtractor = new LoanScheduleArchiveResultSetExtractor(repaymentScheduleRelatedLoanData, disbursementData, loanScheduleType);
            String sql = "select " + fullResultsetExtractor.schema() + " where ls.loan_id = ? and ls.version = ? order by ls.loan_id, ls.installment";
            return (LoanScheduleData)this.jdbcTemplate.query(sql, (ResultSetExtractor)fullResultsetExtractor, new Object[]{loanId, versionNumber});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanNotFoundException(loanId, (Exception)((Object)e));
        }
    }

    public Map<String, Object> fetchOldAuditDates(Long id) {
        String sql = "select lrs.created_date, lrs.lastmodified_date from m_loan_repayment_schedule lrs where lrs.id = ?";
        return this.jdbcTemplate.queryForMap("select lrs.created_date, lrs.lastmodified_date from m_loan_repayment_schedule lrs where lrs.id = ?", new Object[]{id});
    }
}

