/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.CommandParameterUtil;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.exception.LoanChargeNotFoundException;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.api.LoanChargesApiResourceSwagger;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans")
@Component
@Tag(name="Loan Charges", description="Its typical for MFIs to add extra costs for their loan products. They can be either Fees or Penalties.\n\nLoan Charges are instances of Charges and represent either fees and penalties for loan products. Refer Charges for documentation of the various properties of a charge, Only additional properties ( specific to the context of a Charge being associated with a Loan) are described here")
public class LoanChargesApiResource {
    public static final String COMMAND_PAY = "pay";
    public static final String COMMAND_WAIVE = "waive";
    public static final String COMMAND_ADJUSTMENT = "adjustment";
    public static final String COMMAND_DEACTIVATE_OVERDUE = "deactivateOverdue";
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "chargeId", "name", "penalty", "chargeTimeType", "dueAsOfDate", "chargeCalculationType", "percentage", "amountPercentageAppliedTo", "currency", "amountWaived", "amountWrittenOff", "amountOutstanding", "amountOrPercentage", "amount", "amountPaid", "chargeOptions", "installmentChargeData", "externalId"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "LOAN";
    private final PlatformSecurityContext context;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final LoanChargeReadPlatformService loanChargeReadPlatformService;
    private final DefaultToApiJsonSerializer<LoanChargeData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final LoanReadPlatformService loanReadPlatformService;

    @GET
    @Path(value="{loanId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loan Charges", description="It lists all the Loan Charges specific to a Loan \n\nExample Requests:\n\nloans/1/charges\n\n\nloans/1/charges?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesChargeIdResponse.class)))})})
    public String retrieveAllLoanCharges(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Context UriInfo uriInfo) {
        return this.retrieveAllLoanCharges(loanId, null, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loan Charges", description="It lists all the Loan Charges specific to a Loan \n\nExample Requests:\n\nloans/1/charges\n\n\nloans/1/charges?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesChargeIdResponse.class)))})})
    public String retrieveAllLoanCharges(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @Context UriInfo uriInfo) {
        return this.retrieveAllLoanCharges(null, loanExternalId, uriInfo);
    }

    @GET
    @Path(value="{loanId}/charges/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Charges Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nloans/1/charges/template\n\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesTemplateResponse.class))})})
    public String retrieveTemplate(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Context UriInfo uriInfo) {
        return this.retrieveTemplate(loanId, null, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/charges/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Charges Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nloans/1/charges/template\n\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesTemplateResponse.class))})})
    public String retrieveTemplate(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @Context UriInfo uriInfo) {
        return this.retrieveTemplate(null, loanExternalId, uriInfo);
    }

    @GET
    @Path(value="{loanId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Charge", description="Retrieves Loan Charge according to the Loan ID and Loan Charge IDExample Requests:\n\n/loans/1/charges/1\n\n\n/loans/1/charges/1?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesChargeIdResponse.class))})})
    public String retrieveLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId, @Context UriInfo uriInfo) {
        return this.retrieveLoanCharge(loanId, null, loanChargeId, null, uriInfo);
    }

    @GET
    @Path(value="{loanId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Charge", description="Retrieves Loan Charge according to the Loan ID and Loan Charge External IDExample Requests:\n\n/loans/1/charges/1\n\n\n/loans/1/charges/external-id/1?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesChargeIdResponse.class))})})
    public String retrieveLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId, @Context UriInfo uriInfo) {
        return this.retrieveLoanCharge(loanId, null, null, loanChargeExternalId, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Charge", description="Retrieves Loan Charge according to the Loan external ID and Loan Charge IDExample Requests:\n\n/loans/1/charges/1\n\n\n/loans/1/charges/1?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesChargeIdResponse.class))})})
    public String retrieveLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId, @Context UriInfo uriInfo) {
        return this.retrieveLoanCharge(null, loanExternalId, loanChargeId, null, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Charge", description="Retrieves Loan Charge according to the Loan External ID and Loan Charge External IDExample Requests:\n\n/loans/1/charges/1\n\n\n/loans/1/charges/1?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.GetLoansLoanIdChargesChargeIdResponse.class))})})
    public String retrieveLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId, @Context UriInfo uriInfo) {
        return this.retrieveLoanCharge(null, loanExternalId, null, loanChargeExternalId, uriInfo);
    }

    @POST
    @Path(value="{loanId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Loan Charge (no command provided) or Pay a charge (command=pay)", description="Creates a Loan Charge | Pay a Loan Charge")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesResponse.class))})})
    public String executeLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleExecuteLoanCharge(loanId, null, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Loan Charge (no command provided) or Pay a charge (command=pay)", description="Creates a Loan Charge | Pay a Loan Charge")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesResponse.class))})})
    public String executeLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleExecuteLoanCharge(null, loanExternalId, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="{loanId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Pay / Waive / Adjustment for Loan Charge", description="Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdResponse.class))})})
    public String executeLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleExecuteLoanCharge(loanId, null, loanChargeId, null, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="{loanId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Pay / Waive / Adjustment for Loan Charge", description="Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdResponse.class))})})
    public String executeLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleExecuteLoanCharge(loanId, null, null, loanChargeExternalId, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Pay / Waive / Adjustment for Loan Charge", description="Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdResponse.class))})})
    public String executeLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleExecuteLoanCharge(null, loanExternalId, loanChargeId, null, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Pay / Waive / Adjustment for Loan Charge", description="Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PostLoansLoanIdChargesChargeIdResponse.class))})})
    public String executeLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleExecuteLoanCharge(null, loanExternalId, null, loanChargeExternalId, commandParam, apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="{loanId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Charge", description="Currently Loan Charges may be updated only if the Loan is not yet approved")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdResponse.class))})})
    public String updateLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.updateLoanCharge(loanId, null, loanChargeId, null, apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="{loanId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Charge", description="Currently Loan Charges may be updated only if the Loan is not yet approved")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdResponse.class))})})
    public String updateLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.updateLoanCharge(loanId, null, null, loanChargeExternalId, apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Charge", description="Currently Loan Charges may be updated only if the Loan is not yet approved")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdResponse.class))})})
    public String updateLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.updateLoanCharge(null, loanExternalId, loanChargeId, null, apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Charge", description="Currently Loan Charges may be updated only if the Loan is not yet approved")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.PutLoansLoanIdChargesChargeIdResponse.class))})})
    public String updateLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.updateLoanCharge(null, loanExternalId, null, loanChargeExternalId, apiRequestBodyAsJson);
    }

    @DELETE
    @Path(value="{loanId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Loan Charge", description="Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.DeleteLoansLoanIdChargesChargeIdResponse.class))})})
    public String deleteLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId) {
        return this.deleteLoanCharge(loanId, null, loanChargeId, null);
    }

    @DELETE
    @Path(value="{loanId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Loan Charge", description="Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.DeleteLoansLoanIdChargesChargeIdResponse.class))})})
    public String deleteLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId) {
        return this.deleteLoanCharge(loanId, null, null, loanChargeExternalId);
    }

    @DELETE
    @Path(value="external-id/{loanExternalId}/charges/{loanChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Loan Charge", description="Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.DeleteLoansLoanIdChargesChargeIdResponse.class))})})
    public String deleteLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeId") @Parameter(description="loanChargeId") Long loanChargeId) {
        return this.deleteLoanCharge(null, loanExternalId, loanChargeId, null);
    }

    @DELETE
    @Path(value="external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Loan Charge", description="Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanChargesApiResourceSwagger.DeleteLoansLoanIdChargesChargeIdResponse.class))})})
    public String deleteLoanCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId") String loanExternalId, @PathParam(value="loanChargeExternalId") @Parameter(description="loanChargeExternalId") String loanChargeExternalId) {
        return this.deleteLoanCharge(null, loanExternalId, null, loanChargeExternalId);
    }

    private String deleteLoanCharge(Long loanId, String loanExternalIdStr, Long loanChargeId, String loanChargeExternalIdStr) {
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId loanChargeExternalId = ExternalIdFactory.produce((String)loanChargeExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Long resolvedLoanChargeId = this.getResolvedLoanChargeId(loanChargeId, loanChargeExternalId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteLoanCharge(resolvedLoanId, resolvedLoanChargeId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String retrieveLoanCharge(Long loanId, String loanExternalIdStr, Long loanChargeId, String loanChargeExternalIdStr, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId loanChargeExternalId = ExternalIdFactory.produce((String)loanChargeExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Long resolvedLoanChargeId = this.getResolvedLoanChargeId(loanChargeId, loanChargeExternalId);
        LoanChargeData loanCharge = this.loanChargeReadPlatformService.retrieveLoanChargeDetails(resolvedLoanChargeId, resolvedLoanId);
        List installmentChargeData = this.loanChargeReadPlatformService.retrieveInstallmentLoanCharges(resolvedLoanChargeId, true);
        LoanChargeData loanChargeData = new LoanChargeData(loanCharge, installmentChargeData);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)loanChargeData, RESPONSE_DATA_PARAMETERS);
    }

    private String handleExecuteLoanCharge(Long loanId, String loanExternalIdStr, String commandParam, String apiRequestBodyAsJson) {
        CommandProcessingResult result;
        Long resolvedLoanId;
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long l = resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        if (CommandParameterUtil.is((String)commandParam, (String)COMMAND_PAY)) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().payLoanCharge(resolvedLoanId, null).withJson(apiRequestBodyAsJson).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (CommandParameterUtil.is((String)commandParam, (String)COMMAND_DEACTIVATE_OVERDUE)) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().deactivateOverdueLoanCharges(resolvedLoanId, null).withJson(apiRequestBodyAsJson).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else {
            CommandWrapper commandRequest = new CommandWrapperBuilder().createLoanCharge(resolvedLoanId).withJson(apiRequestBodyAsJson).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String handleExecuteLoanCharge(Long loanId, String loanExternalIdStr, Long loanChargeId, String loanChargeExternalIdStr, String commandParam, String apiRequestBodyAsJson) {
        CommandProcessingResult result;
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId loanChargeExternalId = ExternalIdFactory.produce((String)loanChargeExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Long resolvedLoanChargeId = this.getResolvedLoanChargeId(loanChargeId, loanChargeExternalId);
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        if (CommandParameterUtil.is((String)commandParam, (String)COMMAND_WAIVE)) {
            CommandWrapper commandRequest = builder.waiveLoanCharge(resolvedLoanId, resolvedLoanChargeId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (CommandParameterUtil.is((String)commandParam, (String)COMMAND_PAY)) {
            CommandWrapper commandRequest = builder.payLoanCharge(resolvedLoanId, resolvedLoanChargeId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (CommandParameterUtil.is((String)commandParam, (String)COMMAND_ADJUSTMENT)) {
            CommandWrapper commandRequest = builder.adjustmentForLoanCharge(resolvedLoanId, resolvedLoanChargeId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String updateLoanCharge(Long loanId, String loanExternalIdStr, Long loanChargeId, String loanChargeExternalIdStr, String apiRequestBodyAsJson) {
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId loanChargeExternalId = ExternalIdFactory.produce((String)loanChargeExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Long resolvedLoanChargeId = this.getResolvedLoanChargeId(loanChargeId, loanChargeExternalId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateLoanCharge(resolvedLoanId, resolvedLoanChargeId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String retrieveAllLoanCharges(Long loanId, String loanExternalIdStr, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Collection loanCharges = this.loanChargeReadPlatformService.retrieveLoanCharges(resolvedLoanId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, loanCharges, RESPONSE_DATA_PARAMETERS);
    }

    private String retrieveTemplate(Long loanId, String loanExternalIdStr, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        List chargeOptions = this.chargeReadPlatformService.retrieveLoanAccountApplicableCharges(resolvedLoanId, new ChargeTimeType[]{ChargeTimeType.OVERDUE_INSTALLMENT});
        LoanChargeData loanChargeTemplate = LoanChargeData.template((List)chargeOptions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)loanChargeTemplate, RESPONSE_DATA_PARAMETERS);
    }

    private Long getResolvedLoanChargeId(Long loanChargeId, ExternalId loanChargeExternalId) {
        Long resolvedLoanChargeId = loanChargeId;
        if (resolvedLoanChargeId == null) {
            loanChargeExternalId.throwExceptionIfEmpty();
            resolvedLoanChargeId = this.loanChargeReadPlatformService.retrieveLoanChargeIdByExternalId(loanChargeExternalId);
            if (resolvedLoanChargeId == null) {
                throw new LoanChargeNotFoundException(loanChargeExternalId);
            }
        }
        return resolvedLoanChargeId;
    }

    @Generated
    public LoanChargesApiResource(PlatformSecurityContext context, ChargeReadPlatformService chargeReadPlatformService, LoanChargeReadPlatformService loanChargeReadPlatformService, DefaultToApiJsonSerializer<LoanChargeData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, LoanReadPlatformService loanReadPlatformService) {
        this.context = context;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.loanChargeReadPlatformService = loanChargeReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.loanReadPlatformService = loanReadPlatformService;
    }
}

