/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.PaginationParametersDataValidator;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.group.data.CenterData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.data.StaffCenterData;
import org.apache.fineract.portfolio.group.domain.GroupTypes;
import org.apache.fineract.portfolio.group.exception.CenterNotFoundException;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformService;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class CenterReadPlatformServiceImpl
implements CenterReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final ClientReadPlatformService clientReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final ColumnValidator columnValidator;
    private final CenterDataMapper centerMapper = new CenterDataMapper();
    private final GroupDataMapper groupDataMapper = new GroupDataMapper();
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationParametersDataValidator paginationParametersDataValidator;
    private static final Set<String> SUPPORTED_ORDER_BY_VALUES = new HashSet<String>(Arrays.asList("id", "name", "officeId", "officeName"));
    private static final String SQL_QUERY = "g.id as id, g.account_no as accountNo, g.external_id as externalId, g.display_name as name, g.office_id as officeId, o.name as officeName, g.staff_id as staffId, s.display_name as staffName, g.status_enum as statusEnum, g.activation_date as activationDate, g.hierarchy as hierarchy, g.level_id as groupLevel,g.closedon_date as closedOnDate, g.submittedon_date as submittedOnDate, sbu.username as submittedByUsername, sbu.firstname as submittedByFirstname, sbu.lastname as submittedByLastname, clu.username as closedByUsername, clu.firstname as closedByFirstname, clu.lastname as closedByLastname, acu.username as activatedByUsername, acu.firstname as activatedByFirstname, acu.lastname as activatedByLastname from m_group g join m_office o on o.id = g.office_id left join m_staff s on s.id = g.staff_id left join m_group pg on pg.id = g.parent_id left join m_appuser sbu on sbu.id = g.submittedon_userid left join m_appuser acu on acu.id = g.activatedon_userid left join m_appuser clu on clu.id = g.closedon_userid ";

    private SQLBuilder getCenterExtraCriteria(String schemaSl, SearchParameters searchCriteria) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addCriteria("g.level_id =", (Object)GroupTypes.CENTER.getId());
        if (searchCriteria != null) {
            extraCriteria.addNonNullCriteria("g.office_id = ", (Object)searchCriteria.getOfficeId());
            extraCriteria.addNonNullCriteria("g.external_id = ", (Object)searchCriteria.getExternalId());
            extraCriteria.addNonNullCriteria("g.display_name like ", (Object)searchCriteria.getName());
            extraCriteria.addNonNullCriteria(" o.hierarchy like ", (Object)searchCriteria.getHierarchy());
            extraCriteria.addNonNullCriteria(" g.staff_id = ", (Object)searchCriteria.getStaffId());
        }
        return extraCriteria;
    }

    public Page<CenterData> retrievePagedAll(SearchParameters searchParameters, PaginationParameters parameters) {
        this.paginationParametersDataValidator.validateParameterValues(parameters, SUPPORTED_ORDER_BY_VALUES, "audits");
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.centerMapper.schema());
        SQLBuilder extraCriteria = this.getCenterExtraCriteria(this.centerMapper.schema(), searchParameters);
        extraCriteria.addNonNullCriteria("o.hierarchy like ", (Object)hierarchySearchString);
        sqlBuilder.append(' ').append(extraCriteria.getSQLTemplate());
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy()).append(' ').append(searchParameters.getSortOrder());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy(), searchParameters.getSortOrder()});
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), extraCriteria.getArguments(), (RowMapper)this.centerMapper);
    }

    public Collection<CenterData> retrieveAll(SearchParameters searchParameters, PaginationParameters parameters) {
        if (parameters != null) {
            this.paginationParametersDataValidator.validateParameterValues(parameters, SUPPORTED_ORDER_BY_VALUES, "audits");
        }
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select ");
        sqlBuilder.append(this.centerMapper.schema());
        SQLBuilder extraCriteria = this.getCenterExtraCriteria(this.centerMapper.schema(), searchParameters);
        extraCriteria.addNonNullCriteria("o.hierarchy like ", (Object)hierarchySearchString);
        sqlBuilder.append(' ').append(extraCriteria.getSQLTemplate());
        if (searchParameters != null) {
            if (searchParameters.hasOrderBy()) {
                sqlBuilder.append(" order by ").append(searchParameters.getOrderBy()).append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy(), searchParameters.getSortOrder()});
            }
            if (searchParameters.hasLimit()) {
                sqlBuilder.append(" ");
                if (searchParameters.hasOffset()) {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
                } else {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
                }
            }
        }
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)this.centerMapper, extraCriteria.getArguments());
    }

    public Collection<CenterData> retrieveAllForDropdown(Long officeId) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        String sql = "select " + this.centerMapper.schema() + " where g.office_id = ? and g.parent_id is null and g.level_Id = ? and o.hierarchy like ? order by g.hierarchy";
        return this.jdbcTemplate.query(sql, (RowMapper)this.centerMapper, new Object[]{officeId, GroupTypes.CENTER.getId(), hierarchySearchString});
    }

    public CenterData retrieveTemplate(Long officeId, boolean staffInSelectedOfficeOnly) {
        Long officeIdDefaulted = this.defaultToUsersOfficeIfNull(officeId);
        Collection officeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        boolean loanOfficersOnly = false;
        List staffOptions = null;
        staffOptions = staffInSelectedOfficeOnly ? this.staffReadPlatformService.retrieveAllStaffForDropdown(officeIdDefaulted) : this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(officeIdDefaulted, false);
        if (CollectionUtils.isEmpty((Collection)staffOptions)) {
            staffOptions = null;
        }
        Collection groupMembersOptions = null;
        String accountNo = null;
        BigDecimal totalCollected = null;
        BigDecimal totalOverdue = null;
        BigDecimal totaldue = null;
        BigDecimal installmentDue = null;
        return CenterData.template((Long)officeIdDefaulted, accountNo, (LocalDate)LocalDate.now(DateUtils.getDateTimeZoneOfTenant()), (Collection)officeOptions, (Collection)staffOptions, groupMembersOptions, totalCollected, totalOverdue, totaldue, installmentDue);
    }

    private Long defaultToUsersOfficeIfNull(Long officeId) {
        Long defaultOfficeId = officeId;
        if (defaultOfficeId == null) {
            defaultOfficeId = (Long)this.context.authenticatedUser().getOffice().getId();
        }
        return defaultOfficeId;
    }

    public CenterData retrieveOne(Long centerId) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            String hierarchy = currentUser.getOffice().getHierarchy();
            String hierarchySearchString = hierarchy + "%";
            String sql = "select " + this.centerMapper.schema() + " where g.id = ? and o.hierarchy like ?";
            return (CenterData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.centerMapper, new Object[]{centerId, hierarchySearchString});
        }
        catch (EmptyResultDataAccessException e) {
            throw new CenterNotFoundException(centerId, e);
        }
    }

    public GroupGeneralData retrieveCenterGroupTemplate(Long centerId) {
        Collection clientOptions;
        CenterData center = this.retrieveOne(centerId);
        Long centerOfficeId = center.officeId();
        OfficeData centerOffice = this.officeReadPlatformService.retrieveOffice(centerOfficeId);
        StaffData staff = null;
        Long staffId = center.staffId();
        String staffName = null;
        if (staffId != null) {
            staff = this.staffReadPlatformService.retrieveStaff(staffId);
            staffName = staff.getDisplayName();
        }
        List<CenterData> centerOptions = Arrays.asList(center);
        List<OfficeData> officeOptions = Arrays.asList(centerOffice);
        List staffOptions = this.staffReadPlatformService.retrieveAllStaffForDropdown(centerOfficeId);
        if (CollectionUtils.isEmpty((Collection)staffOptions)) {
            staffOptions = null;
        }
        if (CollectionUtils.isEmpty((Collection)(clientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(centerOfficeId)))) {
            clientOptions = null;
        }
        return GroupGeneralData.template((Long)centerOfficeId, (Long)center.getId(), (String)center.getAccountNo(), (String)center.getName(), (Long)staffId, (String)staffName, centerOptions, officeOptions, (Collection)staffOptions, (Collection)clientOptions, null);
    }

    public Collection<GroupGeneralData> retrieveAssociatedGroups(Long centerId) {
        String sql = "select " + this.groupDataMapper.schema() + " where g.parent_id = ? order by g.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.groupDataMapper, new Object[]{centerId});
    }

    public CenterData retrieveCenterWithClosureReasons() {
        ArrayList closureReasons = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("CenterClosureReason"));
        return CenterData.withClosureReasons(closureReasons);
    }

    public Collection<StaffCenterData> retriveAllCentersByMeetingDate(Long officeId, LocalDate meetingDate, Long staffId) {
        List centerDataArray;
        this.validateForGenerateCollectionSheet(staffId);
        CenterCalendarDataMapper centerCalendarMapper = new CenterCalendarDataMapper();
        Object sql = centerCalendarMapper.schema();
        if (staffId != null) {
            sql = (String)sql + " and g.staff_id = ? ";
            sql = (String)sql + " and lrs.duedate <= ? ";
            sql = (String)sql + " group by c.id, ci.id, g.account_no, g.external_id, g.status_enum, g.activation_date, g.hierarchy";
            centerDataArray = this.jdbcTemplate.query((String)sql, (RowMapper)centerCalendarMapper, new Object[]{meetingDate, meetingDate, meetingDate, meetingDate, meetingDate, meetingDate, officeId, staffId, meetingDate});
        } else {
            centerDataArray = this.jdbcTemplate.query((String)sql, (RowMapper)centerCalendarMapper, new Object[]{meetingDate, meetingDate, meetingDate, meetingDate, meetingDate, meetingDate, officeId});
        }
        ArrayList<StaffCenterData> staffCenterDataArray = new ArrayList<StaffCenterData>();
        Boolean flag = false;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        for (CenterData centerData : centerDataArray) {
            ArrayList<CenterData> meetingFallCenter;
            if (!centerData.getCollectionMeetingCalendar().isValidRecurringDate(meetingDate, Boolean.valueOf(isSkipRepaymentOnFirstMonthEnabled), numberOfDays)) continue;
            if (staffCenterDataArray.size() <= 0) {
                meetingFallCenter = new ArrayList();
                meetingFallCenter.add(centerData);
                staffCenterDataArray.add(StaffCenterData.instance((Long)centerData.staffId(), (String)centerData.getStaffName(), meetingFallCenter));
                continue;
            }
            for (StaffCenterData staffCenterData : staffCenterDataArray) {
                flag = false;
                if (!staffCenterData.getStaffId().equals(centerData.staffId())) continue;
                staffCenterData.getMeetingFallCenters().add(centerData);
                flag = true;
                break;
            }
            if (flag.booleanValue()) continue;
            meetingFallCenter = new ArrayList<CenterData>();
            meetingFallCenter.add(centerData);
            staffCenterDataArray.add(StaffCenterData.instance((Long)centerData.staffId(), (String)centerData.getStaffName(), meetingFallCenter));
        }
        return staffCenterDataArray;
    }

    public void validateForGenerateCollectionSheet(Long staffId) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("productivecollectionsheet");
        baseDataValidator.reset().parameter("staffId").value((Object)staffId).notNull();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    @Generated
    public CenterReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, ClientReadPlatformService clientReadPlatformService, OfficeReadPlatformService officeReadPlatformService, StaffReadPlatformService staffReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, ConfigurationDomainService configurationDomainService, ColumnValidator columnValidator, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator, PaginationParametersDataValidator paginationParametersDataValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.clientReadPlatformService = clientReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.configurationDomainService = configurationDomainService;
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
        this.paginationParametersDataValidator = paginationParametersDataValidator;
    }
}

