/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepository;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.domain.Address;
import org.apache.fineract.portfolio.address.domain.AddressRepository;
import org.apache.fineract.portfolio.address.exception.AddressNotFoundException;
import org.apache.fineract.portfolio.address.serialization.AddressCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.address.service.AddressWritePlatformService;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientAddress;
import org.apache.fineract.portfolio.client.domain.ClientAddressRepository;
import org.apache.fineract.portfolio.client.domain.ClientAddressRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.springframework.stereotype.Service;

@Service
public class AddressWritePlatformServiceImpl
implements AddressWritePlatformService {
    private final PlatformSecurityContext context;
    private final CodeValueRepository codeValueRepository;
    private final ClientAddressRepository clientAddressRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final AddressRepository addressRepository;
    private final ClientAddressRepositoryWrapper clientAddressRepositoryWrapper;
    private final AddressCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    public CommandProcessingResult addClientAddress(Long clientId, Long addressTypeId, JsonCommand command) {
        JsonObject jsonObject = command.parsedJson().getAsJsonObject();
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForCreate(jsonObject.toString(), false);
        CodeValue addressTypeIdCodeValue = (CodeValue)this.codeValueRepository.getReferenceById((Object)addressTypeId);
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        Address address = this.createAddress(jsonObject);
        this.addressRepository.save((Object)address);
        ClientAddress clientAddress = this.createClientAddress(client, jsonObject, addressTypeIdCodeValue, address);
        this.clientAddressRepository.saveAndFlush((Object)clientAddress);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)clientAddress.getId()).build();
    }

    public CommandProcessingResult addNewClientAddress(Client client, JsonCommand command) {
        ClientAddress clientAddress = new ClientAddress();
        JsonArray addressArray = command.arrayOfParameterNamed("address");
        if (addressArray != null) {
            for (int i = 0; i < addressArray.size(); ++i) {
                JsonObject jsonObject = addressArray.get(i).getAsJsonObject();
                this.fromApiJsonDeserializer.validateForCreate(jsonObject.toString(), true);
                long addressTypeId = jsonObject.get("addressTypeId").getAsLong();
                CodeValue addressTypeIdCodeValue = (CodeValue)this.codeValueRepository.getReferenceById((Object)addressTypeId);
                Address address = this.createAddress(jsonObject);
                this.addressRepository.save((Object)address);
                clientAddress = this.createClientAddress(client, jsonObject, addressTypeIdCodeValue, address);
                this.clientAddressRepository.saveAndFlush((Object)clientAddress);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)clientAddress.getId()).build();
    }

    private ClientAddress createClientAddress(Client client, JsonObject jsonObject, CodeValue addressTypeIdCodeValue, Address address) {
        boolean clientAddressIsActive = false;
        if (jsonObject.get("isActive") != null) {
            clientAddressIsActive = jsonObject.get("isActive").getAsBoolean();
        }
        return ClientAddress.fromJson((boolean)clientAddressIsActive, (Client)client, (Address)address, (CodeValue)addressTypeIdCodeValue);
    }

    private Address createAddress(JsonObject jsonObject) {
        CodeValue stateIdCodeValue = null;
        if (jsonObject.get("stateProvinceId") != null) {
            long stateId = jsonObject.get("stateProvinceId").getAsLong();
            stateIdCodeValue = (CodeValue)this.codeValueRepository.getReferenceById((Object)stateId);
        }
        CodeValue countryIdCodeValue = null;
        if (jsonObject.get("countryId") != null) {
            long countryId = jsonObject.get("countryId").getAsLong();
            countryIdCodeValue = (CodeValue)this.codeValueRepository.getReferenceById((Object)countryId);
        }
        Address address = Address.fromJsonObject((JsonObject)jsonObject, stateIdCodeValue, countryIdCodeValue);
        address.setCreatedOn(LocalDate.now(DateUtils.getDateTimeZoneOfTenant()));
        address.setUpdatedOn(LocalDate.now(DateUtils.getDateTimeZoneOfTenant()));
        return address;
    }

    public CommandProcessingResult updateClientAddress(Long clientId, JsonCommand command) {
        Boolean testActive;
        this.context.authenticatedUser();
        boolean is_address_update = false;
        this.fromApiJsonDeserializer.validateForUpdate(command.json());
        long addressId = command.longValueOfParameterNamed("addressId");
        ClientAddress clientAddressObj = this.clientAddressRepositoryWrapper.findOneByClientIdAndAddressId(clientId.longValue(), addressId);
        if (clientAddressObj == null) {
            throw new AddressNotFoundException(clientId.longValue());
        }
        Address addobj = (Address)this.addressRepository.getReferenceById((Object)addressId);
        if (!command.stringValueOfParameterNamed("addressLine1").isEmpty()) {
            is_address_update = true;
            String addressLine1 = command.stringValueOfParameterNamed("addressLine1");
            addobj.setAddressLine1(addressLine1);
        }
        if (!command.stringValueOfParameterNamed("addressLine2").isEmpty()) {
            is_address_update = true;
            String addressLine2 = command.stringValueOfParameterNamed("addressLine2");
            addobj.setAddressLine2(addressLine2);
        }
        if (!command.stringValueOfParameterNamed("addressLine3").isEmpty()) {
            is_address_update = true;
            String addressLine3 = command.stringValueOfParameterNamed("addressLine3");
            addobj.setAddressLine3(addressLine3);
        }
        if (!command.stringValueOfParameterNamed("townVillage").isEmpty()) {
            is_address_update = true;
            String townVillage = command.stringValueOfParameterNamed("townVillage");
            addobj.setTownVillage(townVillage);
        }
        if (!command.stringValueOfParameterNamed("city").isEmpty()) {
            is_address_update = true;
            String city = command.stringValueOfParameterNamed("city");
            addobj.setCity(city);
        }
        if (!command.stringValueOfParameterNamed("countyDistrict").isEmpty()) {
            is_address_update = true;
            String countyDistrict = command.stringValueOfParameterNamed("countyDistrict");
            addobj.setCountyDistrict(countyDistrict);
        }
        if (command.longValueOfParameterNamed("stateProvinceId") != null && command.longValueOfParameterNamed("stateProvinceId") != 0L) {
            is_address_update = true;
            long stateId = command.longValueOfParameterNamed("stateProvinceId");
            CodeValue stateIdobj = (CodeValue)this.codeValueRepository.getReferenceById((Object)stateId);
            addobj.setStateProvince(stateIdobj);
        }
        if (command.longValueOfParameterNamed("countryId") != null && command.longValueOfParameterNamed("countryId") != 0L) {
            is_address_update = true;
            long countryId = command.longValueOfParameterNamed("countryId");
            CodeValue countryIdObj = (CodeValue)this.codeValueRepository.getReferenceById((Object)countryId);
            addobj.setCountry(countryIdObj);
        }
        if (!command.stringValueOfParameterNamed("postalCode").isEmpty()) {
            is_address_update = true;
            String postalCode = command.stringValueOfParameterNamed("postalCode");
            addobj.setPostalCode(postalCode);
        }
        if (command.bigDecimalValueOfParameterNamed("latitude") != null) {
            is_address_update = true;
            BigDecimal latitude = command.bigDecimalValueOfParameterNamed("latitude");
            addobj.setLatitude(latitude);
        }
        if (command.bigDecimalValueOfParameterNamed("longitude") != null) {
            is_address_update = true;
            BigDecimal longitude = command.bigDecimalValueOfParameterNamed("longitude");
            addobj.setLongitude(longitude);
        }
        if (is_address_update) {
            addobj.setUpdatedOn(LocalDate.now(DateUtils.getDateTimeZoneOfTenant()));
            this.addressRepository.save((Object)addobj);
        }
        if ((testActive = Boolean.valueOf(command.booleanPrimitiveValueOfParameterNamed("isActive"))) != null) {
            boolean active = command.booleanPrimitiveValueOfParameterNamed("isActive");
            clientAddressObj.setIs_active(active);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)clientAddressObj.getId()).build();
    }

    @Generated
    public AddressWritePlatformServiceImpl(PlatformSecurityContext context, CodeValueRepository codeValueRepository, ClientAddressRepository clientAddressRepository, ClientRepositoryWrapper clientRepositoryWrapper, AddressRepository addressRepository, ClientAddressRepositoryWrapper clientAddressRepositoryWrapper, AddressCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.context = context;
        this.codeValueRepository = codeValueRepository;
        this.clientAddressRepository = clientAddressRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.addressRepository = addressRepository;
        this.clientAddressRepositoryWrapper = clientAddressRepositoryWrapper;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }
}

