/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransfersDetailDataValidator;
import org.apache.fineract.portfolio.account.domain.AccountTransferRecurrenceType;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.domain.StandingInstructionType;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StandingInstructionDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final AccountTransfersDetailDataValidator accountTransfersDetailDataValidator;
    private static final Set<String> CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "fromOfficeId", "fromClientId", "fromAccountType", "fromAccountId", "toOfficeId", "toClientId", "toAccountType", "toAccountId", "transferType", "priority", "instructionType", "status", "amount", "validFrom", "validTill", "recurrenceType", "recurrenceFrequency", "recurrenceInterval", "recurrenceOnMonthDay", "name", "monthDayFormat"));
    private static final Set<String> UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "priority", "instructionType", "status", "amount", "validFrom", "validTill", "recurrenceType", "recurrenceFrequency", "recurrenceInterval", "recurrenceOnMonthDay", "monthDayFormat"));

    @Autowired
    public StandingInstructionDataValidator(FromJsonHelper fromApiJsonHelper, AccountTransfersDetailDataValidator accountTransfersDetailDataValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.accountTransfersDetailDataValidator = accountTransfersDetailDataValidator;
    }

    public void validateForCreate(JsonCommand command) {
        PeriodFrequencyType frequencyType;
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CREATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("standinginstruction");
        this.accountTransfersDetailDataValidator.validate(command, baseDataValidator);
        JsonElement element = command.parsedJson();
        Integer status = this.fromApiJsonHelper.extractIntegerNamed("status", element, Locale.getDefault());
        baseDataValidator.reset().parameter("status").value((Object)status).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        LocalDate validFrom = this.fromApiJsonHelper.extractLocalDateNamed("validFrom", element);
        baseDataValidator.reset().parameter("validFrom").value((Object)validFrom).notNull();
        LocalDate validTill = this.fromApiJsonHelper.extractLocalDateNamed("validTill", element);
        baseDataValidator.reset().parameter("validTill").value((Object)validTill).validateDateAfter(validFrom);
        BigDecimal transferAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("amount", element);
        baseDataValidator.reset().parameter("amount").value((Object)transferAmount).positiveAmount();
        Integer transferType = this.fromApiJsonHelper.extractIntegerNamed("transferType", element, Locale.getDefault());
        baseDataValidator.reset().parameter("transferType").value((Object)transferType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(3));
        Integer priority = this.fromApiJsonHelper.extractIntegerNamed("priority", element, Locale.getDefault());
        baseDataValidator.reset().parameter("priority").value((Object)priority).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
        Integer standingInstructionType = this.fromApiJsonHelper.extractIntegerNamed("instructionType", element, Locale.getDefault());
        baseDataValidator.reset().parameter("instructionType").value((Object)standingInstructionType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        Integer recurrenceType = this.fromApiJsonHelper.extractIntegerNamed("recurrenceType", element, Locale.getDefault());
        baseDataValidator.reset().parameter("recurrenceType").value((Object)recurrenceType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        boolean isPeriodic = false;
        if (recurrenceType != null) {
            isPeriodic = AccountTransferRecurrenceType.fromInt((Integer)recurrenceType).isPeriodicRecurrence();
        }
        Integer recurrenceFrequency = this.fromApiJsonHelper.extractIntegerNamed("recurrenceFrequency", element, Locale.getDefault());
        baseDataValidator.reset().parameter("recurrenceFrequency").value((Object)recurrenceFrequency).inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
        if (recurrenceFrequency != null && ((frequencyType = PeriodFrequencyType.fromInt((Integer)recurrenceFrequency)).isMonthly() || frequencyType.isYearly())) {
            MonthDay monthDay = this.fromApiJsonHelper.extractMonthDayNamed("recurrenceOnMonthDay", element);
            baseDataValidator.reset().parameter("recurrenceOnMonthDay").value((Object)monthDay).notNull();
        }
        Integer recurrenceInterval = this.fromApiJsonHelper.extractIntegerNamed("recurrenceInterval", element, Locale.getDefault());
        if (isPeriodic) {
            baseDataValidator.reset().parameter("recurrenceInterval").value((Object)recurrenceInterval).notNull();
            baseDataValidator.reset().parameter("recurrenceFrequency").value((Object)recurrenceFrequency).notNull();
        }
        baseDataValidator.reset().parameter("recurrenceInterval").value((Object)recurrenceInterval).integerGreaterThanZero();
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull();
        Integer toAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("toAccountType", element);
        if (toAccountType != null && PortfolioAccountType.fromInt((Integer)toAccountType).isSavingsAccount()) {
            baseDataValidator.reset().parameter("instructionType").value((Object)standingInstructionType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(1));
            baseDataValidator.reset().parameter("recurrenceType").value((Object)recurrenceType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(1));
        }
        if (standingInstructionType != null && StandingInstructionType.fromInt((Integer)standingInstructionType).isFixedAmoutTransfer()) {
            baseDataValidator.reset().parameter("amount").value((Object)transferAmount).notNull();
        }
        String errorCode = null;
        AccountTransferType accountTransferType = AccountTransferType.fromInt((Integer)transferType);
        Integer fromAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("fromAccountType", element);
        if (fromAccountType != null && toAccountType != null) {
            PortfolioAccountType fromPortfolioAccountType = PortfolioAccountType.fromInt((Integer)fromAccountType);
            PortfolioAccountType toPortfolioAccountType = PortfolioAccountType.fromInt((Integer)toAccountType);
            if (accountTransferType.isAccountTransfer() && (fromPortfolioAccountType.isLoanAccount() || toPortfolioAccountType.isLoanAccount())) {
                errorCode = "not.account.transfer";
            } else if (accountTransferType.isLoanRepayment() && (fromPortfolioAccountType.isLoanAccount() || toPortfolioAccountType.isSavingsAccount())) {
                errorCode = "not.loan.repayment";
            }
            if (errorCode != null) {
                baseDataValidator.reset().parameter("transferType").failWithCode(errorCode, new Object[0]);
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)UPDATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("standinginstruction");
        JsonElement element = command.parsedJson();
        if (this.fromApiJsonHelper.parameterExists("validFrom", element)) {
            LocalDate validFrom = this.fromApiJsonHelper.extractLocalDateNamed("validFrom", element);
            baseDataValidator.reset().parameter("validFrom").value((Object)validFrom).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("validTill", element)) {
            LocalDate validTill = this.fromApiJsonHelper.extractLocalDateNamed("validTill", element);
            baseDataValidator.reset().parameter("validTill").value((Object)validTill).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("amount", element)) {
            BigDecimal transferAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("amount", element);
            baseDataValidator.reset().parameter("amount").value((Object)transferAmount).positiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("status", element)) {
            Integer status = this.fromApiJsonHelper.extractIntegerNamed("status", element, Locale.getDefault());
            baseDataValidator.reset().parameter("status").value((Object)status).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        }
        if (this.fromApiJsonHelper.parameterExists("priority", element)) {
            Integer priority = this.fromApiJsonHelper.extractIntegerNamed("priority", element, Locale.getDefault());
            baseDataValidator.reset().parameter("priority").value((Object)priority).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
        }
        if (this.fromApiJsonHelper.parameterExists("instructionType", element)) {
            Integer standingInstructionType = this.fromApiJsonHelper.extractIntegerNamed("instructionType", element, Locale.getDefault());
            baseDataValidator.reset().parameter("instructionType").value((Object)standingInstructionType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        }
        if (this.fromApiJsonHelper.parameterExists("recurrenceType", element)) {
            Integer recurrenceType = this.fromApiJsonHelper.extractIntegerNamed("recurrenceType", element, Locale.getDefault());
            baseDataValidator.reset().parameter("recurrenceType").value((Object)recurrenceType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        }
        if (this.fromApiJsonHelper.parameterExists("recurrenceFrequency", element)) {
            Integer recurrenceFrequency = this.fromApiJsonHelper.extractIntegerNamed("recurrenceFrequency", element, Locale.getDefault());
            baseDataValidator.reset().parameter("recurrenceFrequency").value((Object)recurrenceFrequency).inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
        }
        if (this.fromApiJsonHelper.parameterExists("recurrenceInterval", element)) {
            Integer recurrenceInterval = this.fromApiJsonHelper.extractIntegerNamed("recurrenceInterval", element, Locale.getDefault());
            baseDataValidator.reset().parameter("recurrenceInterval").value((Object)recurrenceInterval).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notNull();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

