/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCriteriaDefinitionData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;

public final class ProvisioningCriteriaData
implements Comparable<ProvisioningCriteriaData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long criteriaId;
    private String criteriaName;
    private String createdBy;
    private Collection<LoanProductData> loanProducts;
    private Collection<LoanProductData> selectedLoanProducts;
    private Collection<ProvisioningCriteriaDefinitionData> definitions;
    private Collection<GLAccountData> glAccounts;

    private ProvisioningCriteriaData(Long criteriaId, String criteriaName, Collection<LoanProductData> loanProducts, Collection<ProvisioningCriteriaDefinitionData> definitions, Collection<GLAccountData> glAccounts, String createdBy) {
        this.criteriaId = criteriaId;
        this.criteriaName = criteriaName;
        this.loanProducts = loanProducts;
        this.definitions = definitions;
        this.glAccounts = glAccounts;
        this.createdBy = createdBy;
    }

    private ProvisioningCriteriaData(ProvisioningCriteriaData data, Collection<LoanProductData> loanProducts, Collection<GLAccountData> glAccounts) {
        this.criteriaId = data.criteriaId;
        this.criteriaName = data.criteriaName;
        this.selectedLoanProducts = data.loanProducts;
        this.loanProducts = loanProducts;
        this.loanProducts.removeAll(this.selectedLoanProducts);
        this.definitions = data.definitions;
        this.glAccounts = glAccounts;
        this.createdBy = data.createdBy;
    }

    public static ProvisioningCriteriaData toLookup(Long criteriaId, String criteriaName, Collection<LoanProductData> loanProducts, List<ProvisioningCriteriaDefinitionData> definitions) {
        Collection glAccounts = null;
        String createdBy = null;
        return new ProvisioningCriteriaData().setCriteriaId(criteriaId).setCriteriaName(criteriaName).setLoanProducts(loanProducts).setDefinitions(definitions).setGlAccounts(glAccounts).setCreatedBy(createdBy);
    }

    public static ProvisioningCriteriaData toLookup(Long criteriaId, String criteriaName, String createdBy) {
        Collection glAccounts = null;
        Collection loanProducts = null;
        Collection definitions = null;
        return new ProvisioningCriteriaData().setCriteriaId(criteriaId).setCriteriaName(criteriaName).setLoanProducts(loanProducts).setDefinitions(definitions).setGlAccounts(glAccounts).setCreatedBy(createdBy);
    }

    public static ProvisioningCriteriaData toTemplate(Collection<ProvisioningCriteriaDefinitionData> definitions, Collection<LoanProductData> loanProducts, Collection<GLAccountData> glAccounts) {
        Long criteriaId = null;
        String criteriaName = null;
        String createdBy = null;
        return new ProvisioningCriteriaData().setCriteriaId(criteriaId).setCriteriaName(criteriaName).setLoanProducts(loanProducts).setDefinitions(definitions).setGlAccounts(glAccounts).setCreatedBy(createdBy);
    }

    public static ProvisioningCriteriaData toTemplate(ProvisioningCriteriaData data, Collection<ProvisioningCriteriaDefinitionData> definitions, Collection<LoanProductData> loanProducts, Collection<GLAccountData> glAccounts) {
        return new ProvisioningCriteriaData(data, loanProducts, glAccounts);
    }

    @Override
    public int compareTo(ProvisioningCriteriaData obj) {
        if (obj == null) {
            return -1;
        }
        return obj.criteriaId.compareTo(this.criteriaId);
    }

    @Generated
    public Long getCriteriaId() {
        return this.criteriaId;
    }

    @Generated
    public String getCriteriaName() {
        return this.criteriaName;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Collection<LoanProductData> getLoanProducts() {
        return this.loanProducts;
    }

    @Generated
    public Collection<LoanProductData> getSelectedLoanProducts() {
        return this.selectedLoanProducts;
    }

    @Generated
    public Collection<ProvisioningCriteriaDefinitionData> getDefinitions() {
        return this.definitions;
    }

    @Generated
    public Collection<GLAccountData> getGlAccounts() {
        return this.glAccounts;
    }

    @Generated
    public ProvisioningCriteriaData setCriteriaId(Long criteriaId) {
        this.criteriaId = criteriaId;
        return this;
    }

    @Generated
    public ProvisioningCriteriaData setCriteriaName(String criteriaName) {
        this.criteriaName = criteriaName;
        return this;
    }

    @Generated
    public ProvisioningCriteriaData setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Generated
    public ProvisioningCriteriaData setLoanProducts(Collection<LoanProductData> loanProducts) {
        this.loanProducts = loanProducts;
        return this;
    }

    @Generated
    public ProvisioningCriteriaData setSelectedLoanProducts(Collection<LoanProductData> selectedLoanProducts) {
        this.selectedLoanProducts = selectedLoanProducts;
        return this;
    }

    @Generated
    public ProvisioningCriteriaData setDefinitions(Collection<ProvisioningCriteriaDefinitionData> definitions) {
        this.definitions = definitions;
        return this;
    }

    @Generated
    public ProvisioningCriteriaData setGlAccounts(Collection<GLAccountData> glAccounts) {
        this.glAccounts = glAccounts;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvisioningCriteriaData)) {
            return false;
        }
        ProvisioningCriteriaData other = (ProvisioningCriteriaData)o;
        Long this$criteriaId = this.getCriteriaId();
        Long other$criteriaId = other.getCriteriaId();
        if (this$criteriaId == null ? other$criteriaId != null : !((Object)this$criteriaId).equals(other$criteriaId)) {
            return false;
        }
        String this$criteriaName = this.getCriteriaName();
        String other$criteriaName = other.getCriteriaName();
        if (this$criteriaName == null ? other$criteriaName != null : !this$criteriaName.equals(other$criteriaName)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Collection this$loanProducts = this.getLoanProducts();
        Collection other$loanProducts = other.getLoanProducts();
        if (this$loanProducts == null ? other$loanProducts != null : !((Object)this$loanProducts).equals(other$loanProducts)) {
            return false;
        }
        Collection this$selectedLoanProducts = this.getSelectedLoanProducts();
        Collection other$selectedLoanProducts = other.getSelectedLoanProducts();
        if (this$selectedLoanProducts == null ? other$selectedLoanProducts != null : !((Object)this$selectedLoanProducts).equals(other$selectedLoanProducts)) {
            return false;
        }
        Collection this$definitions = this.getDefinitions();
        Collection other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        Collection this$glAccounts = this.getGlAccounts();
        Collection other$glAccounts = other.getGlAccounts();
        return !(this$glAccounts == null ? other$glAccounts != null : !((Object)this$glAccounts).equals(other$glAccounts));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $criteriaId = this.getCriteriaId();
        result = result * 59 + ($criteriaId == null ? 43 : ((Object)$criteriaId).hashCode());
        String $criteriaName = this.getCriteriaName();
        result = result * 59 + ($criteriaName == null ? 43 : $criteriaName.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Collection $loanProducts = this.getLoanProducts();
        result = result * 59 + ($loanProducts == null ? 43 : ((Object)$loanProducts).hashCode());
        Collection $selectedLoanProducts = this.getSelectedLoanProducts();
        result = result * 59 + ($selectedLoanProducts == null ? 43 : ((Object)$selectedLoanProducts).hashCode());
        Collection $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        Collection $glAccounts = this.getGlAccounts();
        result = result * 59 + ($glAccounts == null ? 43 : ((Object)$glAccounts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProvisioningCriteriaData(criteriaId=" + this.getCriteriaId() + ", criteriaName=" + this.getCriteriaName() + ", createdBy=" + this.getCreatedBy() + ", loanProducts=" + String.valueOf(this.getLoanProducts()) + ", selectedLoanProducts=" + String.valueOf(this.getSelectedLoanProducts()) + ", definitions=" + String.valueOf(this.getDefinitions()) + ", glAccounts=" + String.valueOf(this.getGlAccounts()) + ")";
    }

    @Generated
    public ProvisioningCriteriaData() {
    }
}

