/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.data.AccessTokenData;
import org.apache.fineract.infrastructure.security.data.OTPDeliveryMethod;
import org.apache.fineract.infrastructure.security.data.OTPMetadata;
import org.apache.fineract.infrastructure.security.data.OTPRequest;
import org.apache.fineract.infrastructure.security.domain.TFAccessToken;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Path(value="/v1/twofactor")
@Component
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
@Tag(name="Two Factor", description="")
public class TwoFactorApiResource {
    private final ToApiJsonSerializer<OTPMetadata> otpRequestSerializer;
    private final ToApiJsonSerializer<OTPDeliveryMethod> otpDeliveryMethodSerializer;
    private final ToApiJsonSerializer<AccessTokenData> accessTokenSerializer;
    private final DefaultToApiJsonSerializer<Map<String, Object>> toApiJsonSerializer;
    private final PlatformSecurityContext context;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final TwoFactorService twoFactorService;

    @GET
    @Produces(value={"application/json"})
    public String getOTPDeliveryMethods(@Context UriInfo uriInfo) {
        AppUser user = this.context.authenticatedUser();
        List otpDeliveryMethods = this.twoFactorService.getDeliveryMethodsForUser(user);
        return this.otpDeliveryMethodSerializer.serialize((Object)otpDeliveryMethods);
    }

    @POST
    @Produces(value={"application/json"})
    public String requestToken(@QueryParam(value="deliveryMethod") String deliveryMethod, @QueryParam(value="extendedToken") @DefaultValue(value="false") boolean extendedAccessToken, @Context UriInfo uriInfo) {
        AppUser user = this.context.authenticatedUser();
        OTPRequest request = this.twoFactorService.createNewOTPToken(user, deliveryMethod, extendedAccessToken);
        return this.otpRequestSerializer.serialize((Object)request.getMetadata());
    }

    @Path(value="validate")
    @POST
    @Produces(value={"application/json"})
    public String validate(@QueryParam(value="token") String token) {
        AppUser user = this.context.authenticatedUser();
        TFAccessToken accessToken = this.twoFactorService.createAccessTokenFromOTP(user, token);
        return this.accessTokenSerializer.serialize((Object)accessToken.toTokenData());
    }

    @Path(value="invalidate")
    @POST
    @Produces(value={"application/json"})
    public String updateConfiguration(String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().invalidateTwoFactorAccessToken().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public TwoFactorApiResource(ToApiJsonSerializer<OTPMetadata> otpRequestSerializer, ToApiJsonSerializer<OTPDeliveryMethod> otpDeliveryMethodSerializer, ToApiJsonSerializer<AccessTokenData> accessTokenSerializer, DefaultToApiJsonSerializer<Map<String, Object>> toApiJsonSerializer, PlatformSecurityContext context, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, TwoFactorService twoFactorService) {
        this.otpRequestSerializer = otpRequestSerializer;
        this.otpDeliveryMethodSerializer = otpDeliveryMethodSerializer;
        this.accessTokenSerializer = accessTokenSerializer;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.context = context;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.twoFactorService = twoFactorService;
    }
}

