/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobData;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobEmailAttachmentFileFormat;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobStretchyReportParamDateOption;
import org.apache.fineract.infrastructure.reportmailingjob.exception.ReportMailingJobNotFoundException;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobReadPlatformService;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ReportMailingJobReadPlatformServiceImpl
implements ReportMailingJobReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ColumnValidator columnValidator;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationHelper paginationHelper;

    @Autowired
    public ReportMailingJobReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.columnValidator = columnValidator;
        this.sqlGenerator = sqlGenerator;
        this.paginationHelper = paginationHelper;
    }

    public Page<ReportMailingJobData> retrieveAllReportMailingJobs(SearchParameters searchParameters) {
        StringBuilder sqlStringBuilder = new StringBuilder(200);
        ArrayList queryParameters = new ArrayList();
        ReportMailingJobMapper mapper = new ReportMailingJobMapper();
        sqlStringBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlStringBuilder.append(mapper.reportMailingJobSchema());
        sqlStringBuilder.append(" where rmj.is_deleted = false");
        if (searchParameters.hasOrderBy()) {
            sqlStringBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlStringBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlStringBuilder.append(" ").append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlStringBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        } else {
            sqlStringBuilder.append(" order by rmj.name ");
        }
        if (searchParameters.hasLimit()) {
            sqlStringBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlStringBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlStringBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlStringBuilder.toString(), queryParameters.toArray(), (RowMapper)mapper);
    }

    public Collection<ReportMailingJobData> retrieveAllActiveReportMailingJobs() {
        ReportMailingJobMapper mapper = new ReportMailingJobMapper();
        String sql = "select " + mapper.reportMailingJobSchema() + " where rmj.is_deleted = false and is_active = true order by rmj.name";
        return this.jdbcTemplate.query(sql, (RowMapper)mapper);
    }

    public ReportMailingJobData retrieveReportMailingJob(Long reportMailingJobId) {
        try {
            ReportMailingJobMapper mapper = new ReportMailingJobMapper();
            String sql = "select " + mapper.reportMailingJobSchema() + " where rmj.id = ? and rmj.is_deleted = false";
            return (ReportMailingJobData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{reportMailingJobId});
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ReportMailingJobNotFoundException(reportMailingJobId, ex);
        }
    }

    public ReportMailingJobData retrieveReportMailingJobEnumOptions() {
        List emailAttachmentFileFormatOptions = ReportMailingJobEmailAttachmentFileFormat.validOptions();
        List stretchyReportParamDateOptions = ReportMailingJobStretchyReportParamDateOption.validOptions();
        return ReportMailingJobData.newInstance((List)emailAttachmentFileFormatOptions, (List)stretchyReportParamDateOptions);
    }
}

