/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.hooks.api.HookApiConstants;
import org.apache.fineract.infrastructure.hooks.api.HookApiResourceSwagger;
import org.apache.fineract.infrastructure.hooks.data.HookData;
import org.apache.fineract.infrastructure.hooks.service.HookReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/hooks")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@Tag(name="Hooks", description="Hooks are a mechanism to trigger custom code on the occurence of events. ")
public class HookApiResource {
    private final PlatformSecurityContext context;
    private final HookReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<HookData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Operation(summary="Retrieve Hooks", description="Returns the list of hooks.\n\nExample Requests:\n\nhooks")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=HookApiResourceSwagger.GetHookResponse.class)))})})
    public String retrieveHooks(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("HOOK");
        Collection hooks = this.readPlatformService.retrieveAllHooks();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, hooks, HookApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{hookId}")
    @Operation(summary="Retrieve a Hook", description="Returns the details of a Hook.\n\nExample Requests:\n\nhooks/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.GetHookResponse.class))})})
    public String retrieveHook(@PathParam(value="hookId") @Parameter(description="hookId") Long hookId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("HOOK");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        HookData hook = this.readPlatformService.retrieveHook(hookId);
        if (settings.isTemplate()) {
            HookData hookData = this.readPlatformService.retrieveNewHookDetails(hook.getTemplateName());
            hook = HookData.templateExisting((HookData)hook, (List)hookData.getTemplates(), (List)hookData.getGroupings());
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)hook, HookApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Operation(summary="Retrieve Hooks Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nhooks/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.GetHookTemplateResponse.class))})})
    public String template(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("HOOK");
        HookData hook = this.readPlatformService.retrieveNewHookDetails(null);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)hook, HookApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Operation(summary="Create a Hook", description="The following parameters can be passed for the creation of a hook :-\n\nname - string - Required. The name of the template that is being called. (See /hooks/template for the list of valid hook names.)\n\nisActive - boolean - Determines whether the hook is actually triggered.\n\nevents - array - Determines what events the hook is triggered for.\n\nconfig - hash - Required. Key/value pairs to provide settings for this hook. These settings vary between the templates.\n\ntemplateId - Optional. The UGD template ID associated with the same entity (client or loan).")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.PostHookRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.PostHookResponse.class))})})
    public String createHook(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createHook().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{hookId}")
    @Operation(summary="Update a Hook", description="Updates the details of a hook.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.PutHookRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.PutHookResponse.class))})})
    public String updateHook(@PathParam(value="hookId") @Parameter(description="hookId") Long hookId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateHook(hookId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{hookId}")
    @Operation(summary="Delete a Hook", description="Deletes a hook.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HookApiResourceSwagger.DeleteHookResponse.class))})})
    public String deleteHook(@PathParam(value="hookId") @Parameter(description="hookId") Long hookId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteHook(hookId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public HookApiResource(PlatformSecurityContext context, HookReadPlatformService readPlatformService, DefaultToApiJsonSerializer<HookData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

