/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.documentmanagement.service;

import org.apache.fineract.infrastructure.documentmanagement.api.ImagesApiResource;
import org.apache.fineract.infrastructure.documentmanagement.contentrepository.ContentRepository;
import org.apache.fineract.infrastructure.documentmanagement.contentrepository.ContentRepositoryFactory;
import org.apache.fineract.infrastructure.documentmanagement.data.FileData;
import org.apache.fineract.infrastructure.documentmanagement.data.ImageData;
import org.apache.fineract.infrastructure.documentmanagement.service.ImageReadPlatformService;
import org.apache.fineract.infrastructure.documentmanagement.service.ImageReadPlatformServiceImpl;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ImageNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ImageReadPlatformServiceImpl
implements ImageReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ContentRepositoryFactory contentRepositoryFactory;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final StaffRepositoryWrapper staffRepositoryWrapper;

    @Autowired
    public ImageReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ContentRepositoryFactory documentStoreFactory, ClientRepositoryWrapper clientRepositoryWrapper, StaffRepositoryWrapper staffRepositoryWrapper) {
        this.staffRepositoryWrapper = staffRepositoryWrapper;
        this.jdbcTemplate = jdbcTemplate;
        this.contentRepositoryFactory = documentStoreFactory;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
    }

    public FileData retrieveImage(String entityType, Long entityId) {
        try {
            Object displayName;
            if (ImagesApiResource.EntityTypeForImages.CLIENTS.toString().equalsIgnoreCase(entityType)) {
                owner = this.clientRepositoryWrapper.findOneWithNotFoundDetection(entityId);
                displayName = owner.getDisplayName();
            } else if (ImagesApiResource.EntityTypeForImages.STAFF.toString().equalsIgnoreCase(entityType)) {
                owner = this.staffRepositoryWrapper.findOneWithNotFoundDetection(entityId);
                displayName = owner.displayName();
            } else {
                displayName = "UnknownEntityType:" + entityType;
            }
            ImageMapper imageMapper = new ImageMapper((String)displayName);
            String sql = "select " + imageMapper.schema(entityType);
            ImageData imageData = (ImageData)this.jdbcTemplate.queryForObject(sql, (RowMapper)imageMapper, new Object[]{entityId});
            ContentRepository contentRepository = this.contentRepositoryFactory.getRepository(imageData.storageType());
            return contentRepository.fetchImage(imageData);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ImageNotFoundException("clients", entityId, e);
        }
    }
}

