/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableData;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.domain.EntityDatatableChecks;
import org.apache.fineract.infrastructure.dataqueries.domain.EntityDatatableChecksRepository;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableEntryRequiredException;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.exception.EntityDatatableCheckAlreadyExistsException;
import org.apache.fineract.infrastructure.dataqueries.exception.EntityDatatableCheckNotSupportedException;
import org.apache.fineract.infrastructure.dataqueries.exception.EntityDatatableChecksNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableReadService;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableWriteService;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksDataValidator;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EntityDatatableChecksWritePlatformServiceImpl
implements EntityDatatableChecksWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityDatatableChecksWritePlatformServiceImpl.class);
    private final PlatformSecurityContext context;
    private final EntityDatatableChecksDataValidator fromApiJsonDeserializer;
    private final EntityDatatableChecksRepository entityDatatableChecksRepository;
    private final DatatableReadService datatableReadService;
    private final DatatableWriteService datatableWriteService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final FromJsonHelper fromApiJsonHelper;
    private final ConfigurationDomainService configurationDomainService;

    @Transactional
    public CommandProcessingResult createCheck(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            String datatableName = command.stringValueOfParameterNamed("datatableName");
            DatatableData datatableData = this.datatableReadService.retrieveDatatable(datatableName);
            if (datatableData == null) {
                throw new DatatableNotFoundException(datatableName);
            }
            String entity = command.stringValueOfParameterNamed("entity");
            String foreignKeyColumnName = EntityTables.getForeignKeyColumnNameOnDatatable((String)entity);
            boolean columnExist = datatableData.hasColumn(foreignKeyColumnName);
            log.debug("{} has column {} ? {}", new Object[]{datatableData.getRegisteredTableName(), foreignKeyColumnName, columnExist});
            if (!columnExist) {
                throw new EntityDatatableCheckNotSupportedException(datatableData.getRegisteredTableName(), entity);
            }
            Long productId = command.longValueOfParameterNamed("productId");
            Integer status = command.integerValueSansLocaleOfParameterNamed("status");
            if (productId == null) {
                List entityDatatableCheck = this.entityDatatableChecksRepository.findByEntityStatusAndDatatableIdAndNoProduct(entity, status, datatableName);
                if (!entityDatatableCheck.isEmpty()) {
                    throw new EntityDatatableCheckAlreadyExistsException(entity, status, datatableName);
                }
            } else {
                EntityTables entityTable = EntityTables.fromEntityName((String)entity);
                if (entityTable == EntityTables.LOAN) {
                    this.loanProductReadPlatformService.retrieveLoanProduct(productId);
                } else if (entityTable == EntityTables.SAVINGS) {
                    this.savingsProductReadPlatformService.retrieveOne(productId);
                } else {
                    throw new EntityDatatableCheckNotSupportedException(entity, productId);
                }
                List entityDatatableCheck = this.entityDatatableChecksRepository.findByEntityStatusAndDatatableIdAndProductId(entity, status, datatableName, productId);
                if (!entityDatatableCheck.isEmpty()) {
                    throw new EntityDatatableCheckAlreadyExistsException(entity, status, datatableName, productId);
                }
            }
            EntityDatatableChecks check = EntityDatatableChecks.fromJson((JsonCommand)command);
            this.entityDatatableChecksRepository.saveAndFlush((Object)check);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)check.getId()).build();
        }
        catch (DataAccessException e) {
            this.handleReportDataIntegrityIssues(command, e.getMostSpecificCause(), (Exception)((Object)e));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            this.handleReportDataIntegrityIssues(command, ExceptionUtils.getRootCause((Throwable)dve.getCause()), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public void runTheCheck(Long entityId, String entityName, Integer status, String foreignKeyColumn, String entitySubtype) {
        List tableRequiredBeforeClientActivation = entitySubtype == null ? this.entityDatatableChecksRepository.findByEntityAndStatus(entityName, status) : this.entityDatatableChecksRepository.findByEntityAndStatusAndSubtype(entityName, status, entitySubtype.toUpperCase());
        if (tableRequiredBeforeClientActivation != null) {
            ArrayList<String> reqDatatables = new ArrayList<String>();
            for (EntityDatatableChecks t : tableRequiredBeforeClientActivation) {
                String datatableName = t.getDatatableName();
                Long countEntries = this.datatableReadService.countDatatableEntries(datatableName, entityId, foreignKeyColumn);
                log.debug("The are {} entries in the table {}", (Object)countEntries, (Object)datatableName);
                if (countEntries.intValue() != 0) continue;
                reqDatatables.add(datatableName);
            }
            if (!reqDatatables.isEmpty()) {
                throw new DatatableEntryRequiredException(((Object)reqDatatables).toString());
            }
        }
    }

    @Transactional(readOnly=true)
    public void runTheCheckForProduct(Long entityId, String entityName, Integer status, String foreignKeyColumn, long productId) {
        List tableRequiredBeforAction = this.entityDatatableChecksRepository.findByEntityStatusAndProduct(entityName, status, Long.valueOf(productId));
        if (tableRequiredBeforAction == null || tableRequiredBeforAction.isEmpty()) {
            tableRequiredBeforAction = this.entityDatatableChecksRepository.findByEntityStatusAndNoProduct(entityName, status);
        }
        if (tableRequiredBeforAction != null) {
            ArrayList<String> reqDatatables = new ArrayList<String>();
            for (EntityDatatableChecks t : tableRequiredBeforAction) {
                String datatableName = t.getDatatableName();
                Long countEntries = this.datatableReadService.countDatatableEntries(datatableName, entityId, foreignKeyColumn);
                log.debug("The are {} entries in the table {}", (Object)countEntries, (Object)datatableName);
                if (countEntries.intValue() != 0) continue;
                reqDatatables.add(datatableName);
            }
            if (!reqDatatables.isEmpty()) {
                throw new DatatableEntryRequiredException(((Object)reqDatatables).toString());
            }
        }
    }

    @Transactional
    public boolean saveDatatables(Integer status, String entity, Long entityId, Long productId, JsonArray datatableDatas) {
        AppUser user = this.context.authenticatedUser();
        boolean isMakerCheckerEnabled = false;
        if (datatableDatas != null && datatableDatas.size() > 0) {
            for (JsonElement element : datatableDatas) {
                String datatableName = this.fromApiJsonHelper.extractStringNamed("registeredTableName", element);
                JsonObject datatableData = this.fromApiJsonHelper.extractJsonObjectNamed("data", element);
                if (datatableName == null || datatableData == null) {
                    ApiParameterError error = ApiParameterError.generalError((String)"registeredTableName.and.data.parameters.must.be.present.in.each.list.items.in.datatables", (String)"registeredTableName and data parameters must be present in each list items in datatables", (Object[])new Object[0]);
                    ArrayList<ApiParameterError> errors = new ArrayList<ApiParameterError>();
                    errors.add(error);
                    throw new PlatformApiDataValidationException(errors);
                }
                String taskPermissionName = "CREATE_" + datatableName;
                user.validateHasPermissionTo(taskPermissionName);
                if (this.configurationDomainService.isMakerCheckerEnabledForTask(taskPermissionName)) {
                    isMakerCheckerEnabled = true;
                }
                try {
                    this.datatableWriteService.createNewDatatableEntry(datatableName, entityId, datatableData.toString());
                }
                catch (PlatformApiDataValidationException e) {
                    for (ApiParameterError error : e.getErrors()) {
                        error.setParameterName("datatables." + datatableName + "." + error.getParameterName());
                    }
                    throw e;
                }
            }
        }
        return isMakerCheckerEnabled;
    }

    @Transactional
    public CommandProcessingResult deleteCheck(Long entityDatatableCheckId) {
        EntityDatatableChecks check = (EntityDatatableChecks)this.entityDatatableChecksRepository.findById((Object)entityDatatableCheckId).orElseThrow(() -> new EntityDatatableChecksNotFoundException(entityDatatableCheckId));
        this.entityDatatableChecksRepository.delete((Object)check);
        return new CommandProcessingResultBuilder().withEntityId(entityDatatableCheckId).build();
    }

    private void handleReportDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dae) {
        Object[] msgArgs;
        Object msgCode = "error.msg.entityDatatableCheck";
        Throwable checkEx = realCause == null ? dae : realCause;
        String msg = "Unknown data integrity issue with resource: " + checkEx.getMessage();
        String param = null;
        if (checkEx.getMessage().contains("FOREIGN KEY (x_registered_table_name)")) {
            String datatableName = command.stringValueOfParameterNamed("datatableName");
            msgCode = (String)msgCode + ".foreign.key.constraint";
            msg = "Datatable with name '" + datatableName + "' does not exist";
            param = "datatableName";
            msgArgs = new Object[]{datatableName, dae};
        } else {
            if (checkEx.getMessage().contains("unique_entity_check")) {
                String datatableName = command.stringValueOfParameterNamed("datatableName");
                Integer status = command.integerValueSansLocaleOfParameterNamed("status");
                String entity = command.stringValueOfParameterNamed("entity");
                Long productId = command.longValueOfParameterNamed("productId");
                throw new EntityDatatableCheckAlreadyExistsException(entity, status, datatableName, productId);
            }
            msgCode = (String)msgCode + ".unknown.data.integrity.issue";
            msgArgs = new Object[]{dae};
        }
        log.error("Error occured.", (Throwable)dae);
        throw ErrorHandler.getMappable((Throwable)dae, (String)msgCode, (String)msg, (String)param, (Object[])msgArgs);
    }

    @Generated
    public EntityDatatableChecksWritePlatformServiceImpl(PlatformSecurityContext context, EntityDatatableChecksDataValidator fromApiJsonDeserializer, EntityDatatableChecksRepository entityDatatableChecksRepository, DatatableReadService datatableReadService, DatatableWriteService datatableWriteService, LoanProductReadPlatformService loanProductReadPlatformService, SavingsProductReadPlatformService savingsProductReadPlatformService, FromJsonHelper fromApiJsonHelper, ConfigurationDomainService configurationDomainService) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.entityDatatableChecksRepository = entityDatatableChecksRepository;
        this.datatableReadService = datatableReadService;
        this.datatableWriteService = datatableWriteService;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.savingsProductReadPlatformService = savingsProductReadPlatformService;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.configurationDomainService = configurationDomainService;
    }
}

