/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.output;

import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingConfiguration;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingData;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingService;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingServiceFactory;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.output.SamplingDataPrinter;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.support.SamplingEnabledCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={SamplingEnabledCondition.class})
public class SamplingScheduler
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamplingScheduler.class);
    private final SamplingServiceFactory samplingServiceFactory;
    private final SamplingDataPrinter printer;
    private final TaskScheduler taskScheduler;
    private final SamplingConfiguration samplingConfiguration;

    public void afterPropertiesSet() throws Exception {
        long resetPeriodInSec = this.samplingConfiguration.getResetPeriod().toSeconds();
        if (resetPeriodInSec < 10L) {
            log.warn("Reset period for sampling cannot be smaller than 10 seconds, setting back the minimum 10");
            resetPeriodInSec = 10L;
        }
        Duration resetPeriodInSecDuration = Duration.ofSeconds(resetPeriodInSec);
        PeriodicTrigger trigger = new PeriodicTrigger(resetPeriodInSecDuration);
        trigger.setInitialDelay(resetPeriodInSecDuration);
        this.taskScheduler.schedule(() -> this.printAndResetPeriodically(), (Trigger)trigger);
    }

    private void printAndResetPeriodically() {
        this.samplingServiceFactory.doWithAll(serviceMap -> {
            Map<Class, SamplingData> samplingDataMap = serviceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SamplingService)e.getValue()).getSamplingData()));
            this.printer.print(samplingDataMap);
            serviceMap.values().forEach(SamplingService::reset);
        });
    }

    @Generated
    public SamplingScheduler(SamplingServiceFactory samplingServiceFactory, SamplingDataPrinter printer, TaskScheduler taskScheduler, SamplingConfiguration samplingConfiguration) {
        this.samplingServiceFactory = samplingServiceFactory;
        this.printer = printer;
        this.taskScheduler = taskScheduler;
        this.samplingConfiguration = samplingConfiguration;
    }
}

