/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.service;

import java.util.Map;
import org.apache.fineract.infrastructure.codes.domain.Code;
import org.apache.fineract.infrastructure.codes.domain.CodeRepository;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepository;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.codes.exception.CodeNotFoundException;
import org.apache.fineract.infrastructure.codes.serialization.CodeValueCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.codes.service.CodeValueWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodeValueWritePlatformServiceJpaRepositoryImpl
implements CodeValueWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(CodeValueWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final CodeValueRepositoryWrapper codeValueRepositoryWrapper;
    private final CodeValueRepository codeValueRepository;
    private final CodeRepository codeRepository;
    private final CodeValueCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    @Autowired
    public CodeValueWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, CodeRepository codeRepository, CodeValueRepositoryWrapper codeValueRepositoryWrapper, CodeValueRepository codeValueRepository, CodeValueCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.context = context;
        this.codeRepository = codeRepository;
        this.codeValueRepositoryWrapper = codeValueRepositoryWrapper;
        this.codeValueRepository = codeValueRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }

    @Transactional
    @CacheEvict(value={"code_values"}, allEntries=true)
    public CommandProcessingResult createCodeValue(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Long codeId = command.entityId();
            Code code = (Code)this.codeRepository.findById((Object)codeId).orElseThrow(() -> new CodeNotFoundException(codeId));
            CodeValue codeValue = CodeValue.fromJson((Code)code, (JsonCommand)command);
            this.codeValueRepository.saveAndFlush((Object)codeValue);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)code.getId()).withSubEntityId((Long)codeValue.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleCodeValueDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
    }

    private void handleCodeValueDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("code_value")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.code.value.duplicate.label", "A code value with lable '" + name + "' already exists", "name", new Object[]{name});
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.code.value.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Transactional
    @CacheEvict(value={"code_values"}, allEntries=true)
    public CommandProcessingResult updateCodeValue(Long codeValueId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            CodeValue codeValue = this.codeValueRepositoryWrapper.findOneWithNotFoundDetection(codeValueId);
            Map changes = codeValue.update(command);
            if (!changes.isEmpty()) {
                this.codeValueRepository.saveAndFlush((Object)codeValue);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(codeValueId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleCodeValueDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
    }

    @Transactional
    @CacheEvict(value={"code_values"}, allEntries=true)
    public CommandProcessingResult deleteCodeValue(Long codeId, Long codeValueId) {
        try {
            this.context.authenticatedUser();
            Code code = (Code)this.codeRepository.findById((Object)codeId).orElseThrow(() -> new CodeNotFoundException(codeId));
            CodeValue codeValueToDelete = this.codeValueRepositoryWrapper.findOneWithNotFoundDetection(codeValueId);
            boolean removed = code.remove(codeValueToDelete);
            if (removed) {
                this.codeRepository.saveAndFlush((Object)code);
            }
            return new CommandProcessingResultBuilder().withEntityId(codeId).withSubEntityId(codeValueId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            LOG.error("Error occured.", dve);
            Throwable realCause = dve.getMostSpecificCause();
            if (realCause.getMessage().contains("code_value")) {
                throw new PlatformDataIntegrityException("error.msg.codeValue.in.use", "This code value is in use", new Object[]{codeValueId, dve});
            }
            throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.code.value.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
        }
    }
}

