/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.codes.data.CodeData;
import org.apache.fineract.infrastructure.codes.exception.CodeNotFoundException;
import org.apache.fineract.infrastructure.codes.service.CodeReadPlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class CodeReadPlatformServiceImpl
implements CodeReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public CodeReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Cacheable(value={"codes"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('CD')")
    public Collection<CodeData> retrieveAllCodes() {
        this.context.authenticatedUser();
        CodeMapper rm = new CodeMapper();
        String sql = "select " + rm.schema() + " order by c.code_name";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public CodeData retrieveCode(Long codeId) {
        try {
            this.context.authenticatedUser();
            CodeMapper rm = new CodeMapper();
            String sql = "select " + rm.schema() + " where c.id = ?";
            return (CodeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{codeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new CodeNotFoundException(codeId, e);
        }
    }

    public CodeData retriveCode(String codeName) {
        try {
            this.context.authenticatedUser();
            CodeMapper rm = new CodeMapper();
            String sql = "select " + rm.schema() + " where c.code_name = ?";
            return (CodeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{codeName});
        }
        catch (EmptyResultDataAccessException e) {
            throw new CodeNotFoundException(codeName, e);
        }
    }
}

