/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaign;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignDomainService;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignDomainServiceImpl;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignWritePlatformService;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.event.business.BusinessEventListener;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanApprovedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRejectedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMakeRepaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailCampaignDomainServiceImpl
implements EmailCampaignDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailCampaignDomainServiceImpl.class);
    private final BusinessEventNotifierService businessEventNotifierService;
    private final EmailCampaignWritePlatformService emailCampaignWritePlatformService;
    private final EmailCampaignRepository emailCampaignRepository;

    @PostConstruct
    public void addListeners() {
        this.businessEventNotifierService.addPostBusinessEventListener(LoanApprovedBusinessEvent.class, (BusinessEventListener)new SendEmailOnLoanApproved(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanRejectedBusinessEvent.class, (BusinessEventListener)new SendEmailOnLoanRejected(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanTransactionMakeRepaymentPostBusinessEvent.class, (BusinessEventListener)new SendEmailOnLoanRepayment(this));
    }

    private void notifyLoanOwner(LoanTransaction loanTransaction, String paramValue) throws IOException {
        List campaigns = this.retrieveEmailCampaigns(paramValue);
        for (EmailCampaign emailCampaign : campaigns) {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(emailCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            campaignParams.put("loanId", ((Long)loanTransaction.getLoan().getId()).toString());
            campaignParams.put("loanTransactionId", ((Long)loanTransaction.getId()).toString());
            this.emailCampaignWritePlatformService.insertDirectCampaignIntoEmailOutboundTable(loanTransaction.getLoan(), emailCampaign, campaignParams);
        }
    }

    private void notifyLoanOwner(Loan loan, String paramValue) throws IOException {
        List campaigns = this.retrieveEmailCampaigns(paramValue);
        for (EmailCampaign emailCampaign : campaigns) {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(emailCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            campaignParams.put("loanId", ((Long)loan.getId()).toString());
            this.emailCampaignWritePlatformService.insertDirectCampaignIntoEmailOutboundTable(loan, emailCampaign, campaignParams);
        }
    }

    private List<EmailCampaign> retrieveEmailCampaigns(String paramValue) {
        return this.emailCampaignRepository.findActiveEmailCampaigns("%" + paramValue + "%", SmsCampaignTriggerType.TRIGGERED.getValue());
    }

    @Generated
    public EmailCampaignDomainServiceImpl(BusinessEventNotifierService businessEventNotifierService, EmailCampaignWritePlatformService emailCampaignWritePlatformService, EmailCampaignRepository emailCampaignRepository) {
        this.businessEventNotifierService = businessEventNotifierService;
        this.emailCampaignWritePlatformService = emailCampaignWritePlatformService;
        this.emailCampaignRepository = emailCampaignRepository;
    }
}

