/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignType;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailCampaignValidator {
    public static final String RESOURCE_NAME = "email";
    public static final String campaignName = "campaignName";
    public static final String campaignType = "campaignType";
    public static final String businessRuleId = "businessRuleId";
    public static final String stretchyReportId = "stretchyReportId";
    public static final String stretchyReportParamMap = "stretchyReportParamMap";
    public static final String paramValue = "paramValue";
    public static final String emailSubject = "emailSubject";
    public static final String emailMessage = "emailMessage";
    public static final String emailAttachmentFileFormatId = "emailAttachmentFileFormatId";
    public static final String activationDateParamName = "activationDate";
    public static final String recurrenceStartDate = "recurrenceStartDate";
    public static final String submittedOnDateParamName = "submittedOnDate";
    public static final String closureDateParamName = "closureDate";
    public static final String recurrenceParamName = "recurrence";
    public static final String statusParamName = "status";
    public static final String localeParamName = "locale";
    public static final String dateFormatParamName = "dateFormat";
    private final FromJsonHelper fromApiJsonHelper;
    public static final Set<String> supportedParams = new HashSet<String>(Arrays.asList("campaignName", "campaignType", "locale", "dateFormat", "businessRuleId", "paramValue", "emailMessage", "recurrenceStartDate", "activationDate", "submittedOnDate", "closureDate", "recurrence", "emailSubject", "stretchyReportId", "stretchyReportParamMap", "emailAttachmentFileFormatId"));
    public static final Set<String> supportedParamsForUpdate = new HashSet<String>(Arrays.asList("campaignName", "campaignType", "locale", "dateFormat", "businessRuleId", "paramValue", "emailMessage", "recurrenceStartDate", "activationDate", "recurrence"));
    public static final Set<String> ACTIVATION_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "activationDate"));
    public static final Set<String> CLOSE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "closureDate"));
    public static final Set<String> PREVIEW_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("paramValue", "emailMessage"));

    @Autowired
    public EmailCampaignValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParams);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        String campaignName = this.fromApiJsonHelper.extractStringNamed(campaignName, element);
        baseDataValidator.reset().parameter(campaignName).value((Object)campaignName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        Long campaignType = this.fromApiJsonHelper.extractLongNamed(campaignType, element);
        baseDataValidator.reset().parameter(campaignType).value((Object)campaignType).notNull().integerGreaterThanZero();
        if (campaignType.intValue() == EmailCampaignType.SCHEDULE.getValue().intValue()) {
            String recurrenceParamName = this.fromApiJsonHelper.extractStringNamed(recurrenceParamName, element);
            baseDataValidator.reset().parameter(recurrenceParamName).value((Object)recurrenceParamName).notBlank();
            String recurrenceStartDate = this.fromApiJsonHelper.extractStringNamed(recurrenceStartDate, element);
            baseDataValidator.reset().parameter(recurrenceStartDate).value((Object)recurrenceStartDate).notBlank();
        }
        Long businessRuleId = this.fromApiJsonHelper.extractLongNamed(businessRuleId, element);
        baseDataValidator.reset().parameter(businessRuleId).value((Object)businessRuleId).notNull().integerGreaterThanZero();
        String emailSubject = this.fromApiJsonHelper.extractStringNamed(emailSubject, element);
        baseDataValidator.reset().parameter(emailSubject).value((Object)emailSubject).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        String emailMessage = this.fromApiJsonHelper.extractStringNamed(emailMessage, element);
        baseDataValidator.reset().parameter(emailMessage).value((Object)emailMessage).notBlank().notExceedingLengthOf(Integer.valueOf(480));
        String paramValue = this.fromApiJsonHelper.extractStringNamed(paramValue, element);
        baseDataValidator.reset().parameter(paramValue).value((Object)paramValue).notBlank();
        if (this.fromApiJsonHelper.parameterExists(submittedOnDateParamName, element)) {
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed(submittedOnDateParamName, element);
            baseDataValidator.reset().parameter(submittedOnDateParamName).value((Object)submittedOnDate).notNull();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParamsForUpdate);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        String campaignName = this.fromApiJsonHelper.extractStringNamed(campaignName, element);
        baseDataValidator.reset().parameter(campaignName).value((Object)campaignName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        Long campaignType = this.fromApiJsonHelper.extractLongNamed(campaignType, element);
        baseDataValidator.reset().parameter(campaignType).value((Object)campaignType).notNull().integerGreaterThanZero();
        if (campaignType.intValue() == EmailCampaignType.SCHEDULE.getValue().intValue()) {
            String recurrenceParamName = this.fromApiJsonHelper.extractStringNamed(recurrenceParamName, element);
            baseDataValidator.reset().parameter(recurrenceParamName).value((Object)recurrenceParamName).notBlank();
            String recurrenceStartDate = this.fromApiJsonHelper.extractStringNamed(recurrenceStartDate, element);
            baseDataValidator.reset().parameter(recurrenceStartDate).value((Object)recurrenceStartDate).notBlank();
        }
        Long runReportId = this.fromApiJsonHelper.extractLongNamed(businessRuleId, element);
        baseDataValidator.reset().parameter(businessRuleId).value((Object)runReportId).notNull().integerGreaterThanZero();
        String message = this.fromApiJsonHelper.extractStringNamed(emailMessage, element);
        baseDataValidator.reset().parameter(emailMessage).value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(480));
        String paramValue = this.fromApiJsonHelper.extractStringNamed(paramValue, element);
        baseDataValidator.reset().parameter(paramValue).value((Object)paramValue).notBlank();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validatePreviewMessage(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)PREVIEW_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        String paramValue = this.fromApiJsonHelper.extractStringNamed(paramValue, element);
        baseDataValidator.reset().parameter(paramValue).value((Object)paramValue).notBlank();
        String message = this.fromApiJsonHelper.extractStringNamed(emailMessage, element);
        baseDataValidator.reset().parameter(emailMessage).value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(480));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateClosedDate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate closeDate = this.fromApiJsonHelper.extractLocalDateNamed(closureDateParamName, element);
        baseDataValidator.reset().parameter(closureDateParamName).value((Object)closeDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateActivation(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed(activationDateParamName, element);
        baseDataValidator.reset().parameter(activationDateParamName).value((Object)activationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateClosure(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate closeDate = this.fromApiJsonHelper.extractLocalDateNamed(closureDateParamName, element);
        baseDataValidator.reset().parameter(closureDateParamName).value((Object)closeDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

