/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.shareaccount;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.SavingsAccountSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.SharedProductsSheetPopulator;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class SharedAccountWorkBookPopulator
extends AbstractWorkbookPopulator {
    private final SharedProductsSheetPopulator sharedProductsSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;
    private final SavingsAccountSheetPopulator savingsAccountSheetPopulator;

    public SharedAccountWorkBookPopulator(SharedProductsSheetPopulator sharedProductsSheetPopulator, ClientSheetPopulator clientSheetPopulator, SavingsAccountSheetPopulator savingsAccountSheetPopulator) {
        this.sharedProductsSheetPopulator = sharedProductsSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.savingsAccountSheetPopulator = savingsAccountSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet sharedAccountSheet = workbook.createSheet("SharedAccounts");
        this.sharedProductsSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.savingsAccountSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(sharedAccountSheet);
        this.setRules(sharedAccountSheet, dateFormat);
        this.setDefaults(sharedAccountSheet);
    }

    private void setDefaults(Sheet sharedAccountSheet) {
        Integer rowNo = 1;
        while (rowNo < 3000) {
            Row row = sharedAccountSheet.createRow(rowNo.intValue());
            this.writeFormula(4, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"CURRENCY_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"CURRENCY_\",$B" + (rowNo + 1) + ")))");
            this.writeFormula(5, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"DECIMAL_PLACES_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"DECIMAL_PLACES_\",$B" + (rowNo + 1) + ")))");
            this.writeFormula(7, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"TODAYS_PRICE_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"TODAYS_PRICE_\",$B" + (rowNo + 1) + ")))");
            this.writeFormula(8, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"CURRENCY_IN_MULTIPLES_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"CURRENCY_IN_MULTIPLES_\",$B" + (rowNo + 1) + ")))");
            this.writeFormula(15, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"CHARGES_NAME_1_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"CHARGES_NAME_1_\",$B" + (rowNo + 1) + ")))");
            this.writeFormula(17, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"CHARGES_NAME_2_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"CHARGES_NAME_2_\",$B" + (rowNo + 1) + ")))");
            this.writeFormula(19, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"CHARGES_NAME_3_\",$B" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"CHARGES_NAME_3_\",$B" + (rowNo + 1) + ")))");
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }

    private void setRules(Sheet sharedAccountSheet, String dateFormat) {
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList productRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList submittedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList lockingFrequencyTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        CellRangeAddressList applicationDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 13, 13);
        CellRangeAddressList allowDividendCalcRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 14, 14);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)sharedAccountSheet);
        this.setNames(sharedAccountSheet);
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("Clients");
        DataValidationConstraint productNameConstraint = validationHelper.createFormulaListConstraint("Products");
        DataValidationConstraint dateConstraint = validationHelper.createDateConstraint(7, "=TODAY()", null, dateFormat);
        DataValidationConstraint frequencyConstraint = validationHelper.createExplicitListConstraint(new String[]{"Days", "Weeks", "Months", "Years"});
        DataValidationConstraint booleanConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation productValidation = validationHelper.createValidation(productNameConstraint, productRange);
        DataValidation submittedOnValidation = validationHelper.createValidation(dateConstraint, submittedDateRange);
        DataValidation frequencyValidation = validationHelper.createValidation(frequencyConstraint, lockingFrequencyTypeRange);
        DataValidation applicationDateValidation = validationHelper.createValidation(dateConstraint, applicationDateRange);
        DataValidation allowDividendValidation = validationHelper.createValidation(booleanConstraint, allowDividendCalcRange);
        sharedAccountSheet.addValidationData(clientValidation);
        sharedAccountSheet.addValidationData(productValidation);
        sharedAccountSheet.addValidationData(submittedOnValidation);
        sharedAccountSheet.addValidationData(frequencyValidation);
        sharedAccountSheet.addValidationData(applicationDateValidation);
        sharedAccountSheet.addValidationData(allowDividendValidation);
    }

    private void setNames(Sheet sharedAccountSheet) {
        List clients = this.clientSheetPopulator.getClients();
        List products = this.sharedProductsSheetPopulator.getSharedProductDataList();
        Workbook sharedAccountWorkbook = sharedAccountSheet.getWorkbook();
        Name clientsGroup = sharedAccountWorkbook.createName();
        clientsGroup.setNameName("Clients");
        clientsGroup.setRefersToFormula("Clients!$B$2:$B$" + clients.size() + "1");
        Name productGroup = sharedAccountWorkbook.createName();
        productGroup.setNameName("Products");
        productGroup.setRefersToFormula("SharedProducts!$B$2:$B$" + products.size() + "1");
        Integer i = 0;
        while (i < products.size()) {
            Name currecyName = sharedAccountWorkbook.createName();
            Name decimalPlacesName = sharedAccountWorkbook.createName();
            Name todaysPriceName = sharedAccountWorkbook.createName();
            Name currencyInMultiplesName = sharedAccountWorkbook.createName();
            Name chargesName1 = sharedAccountWorkbook.createName();
            Name chargesName2 = sharedAccountWorkbook.createName();
            Name chargesName3 = sharedAccountWorkbook.createName();
            String productName = ((ShareProductData)products.get(i)).getName().replaceAll("[ ]", "_");
            this.setSanitized(currecyName, "CURRENCY_" + productName);
            currecyName.setRefersToFormula("SharedProducts!$C$" + (i + 2));
            this.setSanitized(decimalPlacesName, "DECIMAL_PLACES_" + productName);
            decimalPlacesName.setRefersToFormula("SharedProducts!$D$" + (i + 2));
            this.setSanitized(todaysPriceName, "TODAYS_PRICE_" + productName);
            todaysPriceName.setRefersToFormula("SharedProducts!$E$" + (i + 2));
            this.setSanitized(currencyInMultiplesName, "CURRENCY_IN_MULTIPLES_" + productName);
            currencyInMultiplesName.setRefersToFormula("SharedProducts!$F$" + (i + 2));
            this.setSanitized(chargesName1, "CHARGES_NAME_1_" + productName);
            chargesName1.setRefersToFormula("SharedProducts!$I$" + (i + 2));
            this.setSanitized(chargesName2, "CHARGES_NAME_2_" + productName);
            chargesName2.setRefersToFormula("SharedProducts!$K$" + (i + 2));
            this.setSanitized(chargesName3, "CHARGES_NAME_3_" + productName);
            chargesName3.setRefersToFormula("SharedProducts!$M$" + (i + 2));
            Integer n = i;
            i = i + 1;
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        this.writeString(0, rowHeader, "Client Name *");
        worksheet.setColumnWidth(1, 4000);
        this.writeString(1, rowHeader, "Shared Product *");
        worksheet.setColumnWidth(2, 4000);
        this.writeString(2, rowHeader, "Submitted On Date *");
        worksheet.setColumnWidth(3, 4000);
        this.writeString(3, rowHeader, "External Id ");
        worksheet.setColumnWidth(4, 6000);
        this.writeString(4, rowHeader, "Currency ");
        worksheet.setColumnWidth(5, 4000);
        this.writeString(5, rowHeader, "Decimal places ");
        worksheet.setColumnWidth(6, 6000);
        this.writeString(6, rowHeader, "Total No. of Shares *");
        worksheet.setColumnWidth(7, 4000);
        this.writeString(7, rowHeader, "Today's price *");
        worksheet.setColumnWidth(8, 6000);
        this.writeString(8, rowHeader, "Currency in multiples ");
        worksheet.setColumnWidth(9, 4000);
        this.writeString(9, rowHeader, "Savings account *");
        worksheet.setColumnWidth(10, 6000);
        this.writeString(10, rowHeader, "Minimum active period(in days) ");
        worksheet.setColumnWidth(11, 4000);
        this.writeString(11, rowHeader, "Lock in period ");
        worksheet.setColumnWidth(12, 6000);
        this.writeString(12, rowHeader, "Lock in Period Frequency ");
        worksheet.setColumnWidth(13, 4000);
        this.writeString(13, rowHeader, "Application Date *");
        worksheet.setColumnWidth(14, 8000);
        this.writeString(14, rowHeader, "Allow dividends for inactive clients");
        worksheet.setColumnWidth(15, 4000);
        this.writeString(15, rowHeader, "Charges 1 ");
        worksheet.setColumnWidth(16, 4000);
        this.writeString(16, rowHeader, "Amount 1 ");
        worksheet.setColumnWidth(17, 4000);
        this.writeString(17, rowHeader, "Charge 2");
        worksheet.setColumnWidth(18, 4000);
        this.writeString(18, rowHeader, "Amount 2");
        worksheet.setColumnWidth(19, 4000);
        this.writeString(19, rowHeader, "Charge 3");
        worksheet.setColumnWidth(20, 4000);
        this.writeString(20, rowHeader, "Amount 3 ");
    }
}

