/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.loan;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataValueSerializer;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.data.LoanApprovalData;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanCollateralManagementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidAmountOfCollateralQuantity;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoanImportHandler
implements ImportHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanImportHandler.class);
    public static final String EMPTY_STR = "";
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList loans = new ArrayList();
        ArrayList approvalDates = new ArrayList();
        ArrayList loanRepayments = new ArrayList();
        ArrayList disbursalDates = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, loans, approvalDates, loanRepayments, disbursalDates, statuses, locale, dateFormat);
        return this.importEntity(workbook, loans, approvalDates, loanRepayments, disbursalDates, statuses, dateFormat);
    }

    private void readExcelFile(Workbook workbook, List<LoanAccountData> loans, List<LoanApprovalData> approvalDates, List<LoanTransactionData> loanRepayments, List<DisbursementData> disbursalDates, List<String> statuses, String locale, String dateFormat) {
        Sheet loanSheet = workbook.getSheet("Loans");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)loanSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = loanSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)32)) continue;
            loans.add(this.readLoan(workbook, row, statuses, locale, dateFormat));
            approvalDates.add(this.readLoanApproval(row, locale, dateFormat));
            disbursalDates.add(this.readDisbursalData(row, locale, dateFormat));
            loanRepayments.add(this.readLoanRepayment(workbook, row, locale, dateFormat));
        }
    }

    private LoanTransactionData readLoanRepayment(Workbook workbook, Row row, String locale, String dateFormat) {
        BigDecimal repaymentAmount = null;
        if (ImportHandlerUtils.readAsDouble((int)29, (Row)row) != null) {
            repaymentAmount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)29, (Row)row));
        }
        LocalDate lastRepaymentDate = ImportHandlerUtils.readAsDate((int)30, (Row)row);
        String repaymentType = ImportHandlerUtils.readAsString((int)31, (Row)row);
        Long repaymentTypeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Extras"), (String)repaymentType);
        if (repaymentAmount != null && lastRepaymentDate != null && repaymentType != null && repaymentTypeId != null) {
            return LoanTransactionData.importInstance((BigDecimal)repaymentAmount, (LocalDate)lastRepaymentDate, (Long)repaymentTypeId, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private DisbursementData readDisbursalData(Row row, String locale, String dateFormat) {
        LocalDate disbursedDate = ImportHandlerUtils.readAsDate((int)8, (Row)row);
        String linkAccountId = null;
        if (ImportHandlerUtils.readAsLong((int)46, (Row)row) != null) {
            linkAccountId = Objects.requireNonNull(ImportHandlerUtils.readAsLong((int)46, (Row)row)).toString();
        }
        if (disbursedDate != null) {
            return DisbursementData.importInstance((LocalDate)disbursedDate, (String)linkAccountId, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private LoanApprovalData readLoanApproval(Row row, String locale, String dateFormat) {
        LocalDate approvedDate = ImportHandlerUtils.readAsDate((int)7, (Row)row);
        if (approvedDate != null) {
            return LoanApprovalData.importInstance((LocalDate)approvedDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private LoanAccountData readLoan(Workbook workbook, Row row, List<String> statuses, String locale, String dateFormat) {
        BigDecimal chargeAmount;
        BigDecimal amountOrPercentage;
        ExternalId externalId = ExternalIdFactory.produce((String)ImportHandlerUtils.readAsString((int)35, (Row)row));
        String status = ImportHandlerUtils.readAsString((int)32, (Row)row);
        String productName = ImportHandlerUtils.readAsString((int)4, (Row)row);
        Long productId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Products"), (String)productName);
        String loanOfficerName = ImportHandlerUtils.readAsString((int)5, (Row)row);
        Long loanOfficerId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)loanOfficerName);
        LocalDate submittedOnDate = ImportHandlerUtils.readAsDate((int)6, (Row)row);
        String fundName = ImportHandlerUtils.readAsString((int)10, (Row)row);
        Long fundId = fundName == null ? null : ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Extras"), (String)fundName);
        BigDecimal principal = null;
        if (ImportHandlerUtils.readAsDouble((int)11, (Row)row) != null) {
            principal = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)11, (Row)row));
        }
        Integer numberOfRepayments = ImportHandlerUtils.readAsInt((int)12, (Row)row);
        Integer repaidEvery = ImportHandlerUtils.readAsInt((int)13, (Row)row);
        String repaidEveryFrequency = ImportHandlerUtils.readAsString((int)14, (Row)row);
        String repaidEveryFrequencyId = EMPTY_STR;
        EnumOptionData repaidEveryFrequencyEnums = null;
        if (repaidEveryFrequency != null) {
            if (repaidEveryFrequency.equalsIgnoreCase("Days")) {
                repaidEveryFrequencyId = "0";
            } else if (repaidEveryFrequency.equalsIgnoreCase("Weeks")) {
                repaidEveryFrequencyId = "1";
            } else if (repaidEveryFrequency.equalsIgnoreCase("Months")) {
                repaidEveryFrequencyId = "2";
            } else if (repaidEveryFrequency.equalsIgnoreCase("Semi Month")) {
                repaidEveryFrequencyId = "5";
            }
            repaidEveryFrequencyEnums = new EnumOptionData(null, null, repaidEveryFrequencyId);
        }
        Integer loanTerm = ImportHandlerUtils.readAsInt((int)15, (Row)row);
        String loanTermFrequencyType = ImportHandlerUtils.readAsString((int)16, (Row)row);
        EnumOptionData loanTermFrequencyEnum = null;
        if (loanTermFrequencyType != null) {
            String loanTermFrequencyId = EMPTY_STR;
            if (loanTermFrequencyType.equalsIgnoreCase("Days")) {
                loanTermFrequencyId = "0";
            } else if (loanTermFrequencyType.equalsIgnoreCase("Weeks")) {
                loanTermFrequencyId = "1";
            } else if (loanTermFrequencyType.equalsIgnoreCase("Months")) {
                loanTermFrequencyId = "2";
            }
            loanTermFrequencyEnum = new EnumOptionData(null, null, loanTermFrequencyId);
        }
        BigDecimal nominalInterestRate = null;
        if (ImportHandlerUtils.readAsDouble((int)17, (Row)row) != null) {
            nominalInterestRate = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)17, (Row)row));
        }
        String amortization = ImportHandlerUtils.readAsString((int)19, (Row)row);
        String amortizationId = EMPTY_STR;
        EnumOptionData amortizationEnumOption = null;
        if (amortization != null) {
            if (amortization.equalsIgnoreCase("Equal principal payments")) {
                amortizationId = "0";
            } else if (amortization.equalsIgnoreCase("Equal installments")) {
                amortizationId = "1";
            }
            amortizationEnumOption = new EnumOptionData(null, null, amortizationId);
        }
        String interestMethod = ImportHandlerUtils.readAsString((int)20, (Row)row);
        String interestMethodId = EMPTY_STR;
        EnumOptionData interestMethodEnum = null;
        if (interestMethod != null) {
            if (interestMethod.equalsIgnoreCase("Flat")) {
                interestMethodId = "1";
            } else if (interestMethod.equalsIgnoreCase("Declining Balance")) {
                interestMethodId = "0";
            }
            interestMethodEnum = new EnumOptionData(null, null, interestMethodId);
        }
        String interestCalculationPeriod = ImportHandlerUtils.readAsString((int)21, (Row)row);
        String interestCalculationPeriodId = EMPTY_STR;
        EnumOptionData interestCalculationPeriodEnum = null;
        if (interestCalculationPeriod != null) {
            if (interestCalculationPeriod.equalsIgnoreCase("Daily")) {
                interestCalculationPeriodId = "0";
            } else if (interestCalculationPeriod.equalsIgnoreCase("Same as repayment period")) {
                interestCalculationPeriodId = "1";
            }
            interestCalculationPeriodEnum = new EnumOptionData(null, null, interestCalculationPeriodId);
        }
        BigDecimal arrearsTolerance = null;
        if (ImportHandlerUtils.readAsDouble((int)22, (Row)row) != null) {
            arrearsTolerance = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)22, (Row)row));
        }
        String loanRepaymentScheduleTransactionProcessorStrategy = ImportHandlerUtils.readAsString((int)23, (Row)row);
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(loanRepaymentScheduleTransactionProcessorStrategy);
        String repaymentStrategyCode = "mifos-standard-strategy";
        if (loanRepaymentScheduleTransactionProcessor != null) {
            repaymentStrategyCode = loanRepaymentScheduleTransactionProcessor.getCode();
        }
        Integer graceOnPrincipalPayment = ImportHandlerUtils.readAsInt((int)24, (Row)row);
        Integer graceOnInterestPayment = ImportHandlerUtils.readAsInt((int)25, (Row)row);
        Integer graceOnInterestCharged = ImportHandlerUtils.readAsInt((int)26, (Row)row);
        LocalDate interestChargedFromDate = ImportHandlerUtils.readAsDate((int)27, (Row)row);
        LocalDate firstRepaymentOnDate = ImportHandlerUtils.readAsDate((int)28, (Row)row);
        String loanType = null;
        EnumOptionData loanTypeEnumOption = null;
        if (ImportHandlerUtils.readAsString((int)1, (Row)row) != null) {
            loanType = ImportHandlerUtils.readAsString((int)1, (Row)row).toLowerCase(Locale.ENGLISH);
            loanTypeEnumOption = new EnumOptionData(null, null, loanType);
        }
        String clientOrGroupName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        ArrayList<LoanChargeData> charges = new ArrayList<LoanChargeData>();
        String chargeOneName = ImportHandlerUtils.readAsString((int)36, (Row)row);
        String chargeTwoName = ImportHandlerUtils.readAsString((int)39, (Row)row);
        Long chargeOneId = null;
        if (chargeOneName != null) {
            chargeOneId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Charges"), (String)chargeOneName);
        }
        Long chargeTwoId = null;
        if (chargeTwoName != null) {
            chargeTwoId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Charges"), (String)chargeTwoName);
        }
        Long collateralId = ImportHandlerUtils.readAsLong((int)47, (Row)row);
        Long groupId = ImportHandlerUtils.readAsLong((int)42, (Row)row);
        String linkAccountId = ImportHandlerUtils.readAsString((int)46, (Row)row);
        if (chargeOneId != null) {
            if (ImportHandlerUtils.readAsDouble((int)37, (Row)row) != null) {
                EnumOptionData chargeOneTimeTypeEnum = ImportHandlerUtils.getChargeTimeTypeEmun((Sheet)workbook.getSheet("Charges"), (String)chargeOneName);
                EnumOptionData chargeOneAmountTypeEnum = ImportHandlerUtils.getChargeAmountTypeEnum((String)ImportHandlerUtils.readAsString((int)49, (Row)row));
                amountOrPercentage = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)37, (Row)row));
                chargeAmount = chargeOneAmountTypeEnum.getValue().equalsIgnoreCase("1") ? amountOrPercentage : LoanCharge.percentageOf((BigDecimal)principal, (BigDecimal)amountOrPercentage);
                charges.add(new LoanChargeData(chargeOneId, ImportHandlerUtils.readAsDate((int)38, (Row)row), chargeAmount, chargeOneAmountTypeEnum, chargeOneTimeTypeEnum));
            } else {
                charges.add(new LoanChargeData(chargeOneId, ImportHandlerUtils.readAsDate((int)38, (Row)row), null));
            }
        }
        if (chargeTwoId != null) {
            if (ImportHandlerUtils.readAsDouble((int)40, (Row)row) != null) {
                EnumOptionData chargeTwoTimeTypeEnum = ImportHandlerUtils.getChargeTimeTypeEmun((Sheet)workbook.getSheet("Charges"), (String)chargeTwoName);
                EnumOptionData chargeTwoAmountTypeEnum = ImportHandlerUtils.getChargeAmountTypeEnum((String)ImportHandlerUtils.readAsString((int)50, (Row)row));
                amountOrPercentage = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)40, (Row)row));
                chargeAmount = chargeTwoTimeTypeEnum.getValue().equalsIgnoreCase("1") ? amountOrPercentage : LoanCharge.percentageOf((BigDecimal)principal, (BigDecimal)amountOrPercentage);
                charges.add(new LoanChargeData(chargeTwoId, ImportHandlerUtils.readAsDate((int)41, (Row)row), chargeAmount, chargeTwoAmountTypeEnum, chargeTwoTimeTypeEnum));
            } else {
                charges.add(new LoanChargeData(chargeTwoId, ImportHandlerUtils.readAsDate((int)41, (Row)row), null));
            }
        }
        ArrayList<LoanCollateralManagementData> loanCollateralManagementData = new ArrayList<LoanCollateralManagementData>();
        if (collateralId != null) {
            if (ImportHandlerUtils.readAsDouble((int)48, (Row)row) != null) {
                loanCollateralManagementData.add(new LoanCollateralManagementData(collateralId, BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)48, (Row)row)), null, null, null));
            } else {
                throw new InvalidAmountOfCollateralQuantity(null);
            }
        }
        statuses.add(status);
        if (loanType != null) {
            Long clientId;
            if (loanType.equals("individual")) {
                clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientOrGroupName);
                return LoanAccountData.importInstanceIndividual((EnumOptionData)loanTypeEnumOption, (Long)clientId, (Long)productId, (Long)loanOfficerId, (LocalDate)submittedOnDate, (Long)fundId, (BigDecimal)principal, (Integer)numberOfRepayments, (Integer)repaidEvery, (EnumOptionData)repaidEveryFrequencyEnums, (Integer)loanTerm, (EnumOptionData)loanTermFrequencyEnum, (BigDecimal)nominalInterestRate, (LocalDate)submittedOnDate, (EnumOptionData)amortizationEnumOption, (EnumOptionData)interestMethodEnum, (EnumOptionData)interestCalculationPeriodEnum, (BigDecimal)arrearsTolerance, (String)repaymentStrategyCode, (Integer)graceOnPrincipalPayment, (Integer)graceOnInterestPayment, (Integer)graceOnInterestCharged, (LocalDate)interestChargedFromDate, (LocalDate)firstRepaymentOnDate, (Integer)row.getRowNum(), (ExternalId)externalId, null, charges, (String)linkAccountId, (String)locale, (String)dateFormat, loanCollateralManagementData, null, null);
            }
            if (loanType.equals("jlg")) {
                clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientOrGroupName);
                return LoanAccountData.importInstanceIndividual((EnumOptionData)loanTypeEnumOption, (Long)clientId, (Long)productId, (Long)loanOfficerId, (LocalDate)submittedOnDate, (Long)fundId, (BigDecimal)principal, (Integer)numberOfRepayments, (Integer)repaidEvery, (EnumOptionData)repaidEveryFrequencyEnums, (Integer)loanTerm, (EnumOptionData)loanTermFrequencyEnum, (BigDecimal)nominalInterestRate, (LocalDate)submittedOnDate, (EnumOptionData)amortizationEnumOption, (EnumOptionData)interestMethodEnum, (EnumOptionData)interestCalculationPeriodEnum, (BigDecimal)arrearsTolerance, (String)repaymentStrategyCode, (Integer)graceOnPrincipalPayment, (Integer)graceOnInterestPayment, (Integer)graceOnInterestCharged, (LocalDate)interestChargedFromDate, (LocalDate)firstRepaymentOnDate, (Integer)row.getRowNum(), (ExternalId)externalId, (Long)groupId, charges, (String)linkAccountId, (String)locale, (String)dateFormat, null, null, null);
            }
            Long groupIdforGroupLoan = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Groups"), (String)clientOrGroupName);
            return LoanAccountData.importInstanceGroup((EnumOptionData)loanTypeEnumOption, (Long)groupIdforGroupLoan, (Long)productId, (Long)loanOfficerId, (LocalDate)submittedOnDate, (Long)fundId, (BigDecimal)principal, (Integer)numberOfRepayments, (Integer)repaidEvery, (EnumOptionData)repaidEveryFrequencyEnums, (Integer)loanTerm, (EnumOptionData)loanTermFrequencyEnum, (BigDecimal)nominalInterestRate, (LocalDate)submittedOnDate, (EnumOptionData)amortizationEnumOption, (EnumOptionData)interestMethodEnum, (EnumOptionData)interestCalculationPeriodEnum, (BigDecimal)arrearsTolerance, (String)repaymentStrategyCode, (Integer)graceOnPrincipalPayment, (Integer)graceOnInterestPayment, (Integer)graceOnInterestCharged, (LocalDate)interestChargedFromDate, (LocalDate)firstRepaymentOnDate, (Integer)row.getRowNum(), (ExternalId)externalId, (String)linkAccountId, (String)locale, (String)dateFormat, null);
        }
        return null;
    }

    private Count importEntity(Workbook workbook, List<LoanAccountData> loans, List<LoanApprovalData> approvalDates, List<LoanTransactionData> loanRepayments, List<DisbursementData> disbursalDates, List<String> statuses, String dateFormat) {
        Sheet loanSheet = workbook.getSheet("Loans");
        int successCount = 0;
        int errorCount = 0;
        int progressLevel = 0;
        for (int i = 0; i < loans.size(); ++i) {
            Row row = loanSheet.getRow(loans.get(i).getRowIndex().intValue());
            Cell errorReportCell = row.createCell(34);
            Cell statusCell = row.createCell(32);
            CommandProcessingResult result = null;
            String loanId = EMPTY_STR;
            try {
                String status = statuses.get(i);
                progressLevel = this.getProgressLevel(status);
                if (progressLevel == 0 && loans.get(i) != null) {
                    result = this.importLoan(loans, i, dateFormat);
                    loanId = result.getLoanId().toString();
                    progressLevel = 1;
                } else {
                    loanId = ImportHandlerUtils.readAsString((int)33, (Row)loanSheet.getRow(loans.get(i).getRowIndex().intValue()));
                }
                if (progressLevel <= 1 && approvalDates.get(i) != null) {
                    progressLevel = this.importLoanApproval(approvalDates, result, i, dateFormat);
                }
                if (progressLevel <= 2 && disbursalDates.get(i) != null) {
                    progressLevel = this.importDisbursalData(approvalDates, disbursalDates, result, i, dateFormat);
                }
                if (loanRepayments.get(i) != null) {
                    progressLevel = this.importLoanRepayment(loanRepayments, result, i, dateFormat);
                }
                ++successCount;
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                continue;
            }
            catch (RuntimeException ex) {
                ++errorCount;
                log.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                this.writeLoanErrorMessage(workbook, loanId, errorMessage, progressLevel, statusCell, errorReportCell, row);
            }
        }
        this.setReportHeaders(loanSheet);
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void writeLoanErrorMessage(Workbook workbook, String loanId, String errorMessage, int progressLevel, Cell statusCell, Cell errorReportCell, Row row) {
        String status = EMPTY_STR;
        if (progressLevel == 0) {
            status = "Creation failed";
        } else if (progressLevel == 1) {
            status = "Approval failed";
        } else if (progressLevel == 2) {
            status = "Disbursal failed";
        } else if (progressLevel == 3) {
            status = "Repayment failed";
        }
        statusCell.setCellValue(status);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.RED));
        if (progressLevel > 0) {
            row.createCell(33).setCellValue((double)Integer.parseInt(loanId));
        }
        errorReportCell.setCellValue(errorMessage);
    }

    private void setReportHeaders(Sheet sheet) {
        sheet.setColumnWidth(32, 4000);
        Row rowHeader = sheet.getRow(0);
        ImportHandlerUtils.writeString((int)32, (Row)rowHeader, (String)"Status");
        ImportHandlerUtils.writeString((int)33, (Row)rowHeader, (String)"Loan ID");
        ImportHandlerUtils.writeString((int)34, (Row)rowHeader, (String)"Report");
    }

    private Integer importLoanRepayment(List<LoanTransactionData> loanRepayments, CommandProcessingResult result, int rowIndex, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, loanRepayments.get(rowIndex).getLocale()));
        JsonObject loanRepaymentJsonob = gsonBuilder.create().toJsonTree((Object)loanRepayments.get(rowIndex)).getAsJsonObject();
        loanRepaymentJsonob.remove("manuallyReversed");
        loanRepaymentJsonob.remove("numberOfRepayments");
        loanRepaymentJsonob.remove("reversed");
        String payload = loanRepaymentJsonob.toString();
        CommandWrapper commandRequest = new CommandWrapperBuilder().loanRepaymentTransaction(result.getLoanId()).withJson(payload).build();
        this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return 4;
    }

    private Integer importDisbursalData(List<LoanApprovalData> approvalDates, List<DisbursementData> disbursalDates, CommandProcessingResult result, int rowIndex, String dateFormat) {
        if (approvalDates.get(rowIndex) != null && disbursalDates.get(rowIndex) != null) {
            DisbursementData disbusalData = disbursalDates.get(rowIndex);
            String linkAccountId = disbusalData.getLinkAccountId();
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, approvalDates.get(rowIndex).getLocale()));
            if (linkAccountId != null && !EMPTY_STR.equals(linkAccountId)) {
                String payload = gsonBuilder.create().toJson((Object)disbusalData);
                CommandWrapper commandRequest = new CommandWrapperBuilder().disburseLoanToSavingsApplication(result.getLoanId()).withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            } else {
                String payload = gsonBuilder.create().toJson((Object)disbusalData);
                CommandWrapper commandRequest = new CommandWrapperBuilder().disburseLoanApplication(result.getLoanId()).withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            }
        }
        return 3;
    }

    private Integer importLoanApproval(List<LoanApprovalData> approvalDates, CommandProcessingResult result, int rowIndex, String dateFormat) {
        if (approvalDates.get(rowIndex) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, approvalDates.get(rowIndex).getLocale()));
            String payload = gsonBuilder.create().toJson((Object)approvalDates.get(rowIndex));
            CommandWrapper commandRequest = new CommandWrapperBuilder().approveLoanApplication(result.getLoanId()).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 2;
    }

    private CommandProcessingResult importLoan(List<LoanAccountData> loans, int rowIndex, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, loans.get(rowIndex).getLocale()));
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataValueSerializer());
        JsonObject loanJsonOb = gsonBuilder.create().toJsonTree((Object)loans.get(rowIndex)).getAsJsonObject();
        loanJsonOb.remove("isLoanProductLinkedToFloatingRate");
        loanJsonOb.remove("isInterestRecalculationEnabled");
        loanJsonOb.remove("isFloatingInterestRate");
        loanJsonOb.remove("isRatesEnabled");
        JsonArray chargesJsonAr = loanJsonOb.getAsJsonArray("charges");
        if (chargesJsonAr != null) {
            for (int i = 0; i < chargesJsonAr.size(); ++i) {
                JsonElement chargesJsonElement = chargesJsonAr.get(i);
                JsonObject chargeJsonOb = chargesJsonElement.getAsJsonObject();
                chargeJsonOb.remove("penalty");
                chargeJsonOb.remove("paid");
                chargeJsonOb.remove("waived");
                chargeJsonOb.remove("chargePayable");
            }
        }
        loanJsonOb.remove("isTopup");
        String payload = loanJsonOb.toString();
        CommandWrapper commandRequest = new CommandWrapperBuilder().createLoanApplication().withJson(payload).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private int getProgressLevel(String status) {
        if (status == null || status.equals("Creation failed")) {
            return 0;
        }
        if (status.equals("Approval failed")) {
            return 1;
        }
        if (status.equals("Disbursal failed")) {
            return 2;
        }
        if (status.equals("Repayment failed")) {
            return 3;
        }
        return 0;
    }

    @Generated
    public LoanImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
    }
}

