/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoanInterestRecalculationCOBBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanInterestRecalculationCOBBusinessStep.class);
    private final LoanWritePlatformService loanWritePlatformService;

    public Loan execute(Loan loan) {
        try {
            ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.DEFAULT);
            if (!loan.getStatus().isActive() || loan.isNpa() || loan.isChargedOff() || !loan.isInterestBearingAndInterestRecalculationEnabled() || loan.getLoanInterestRecalculationDetails().disallowInterestCalculationOnPastDue().booleanValue() || !this.hasOverdueInstallment(loan)) {
                log.debug("Skip processing loan interest recalculation [{}] - Possible reasons: Loan is not an interest bearing loan, Loan is not active, Interest recalculation on past due is disabled on this loan", (Object)loan.getId());
                Loan loan2 = loan;
                return loan2;
            }
            log.debug("Start processing loan interest recalculation [{}]", (Object)loan.getId());
            loan = this.loanWritePlatformService.recalculateInterest(loan);
            log.debug("End processing loan interest recalculation [{}]", (Object)loan.getId());
            Loan loan3 = loan;
            return loan3;
        }
        finally {
            ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.COB);
        }
    }

    private boolean hasOverdueInstallment(Loan loan) {
        return loan.getRepaymentScheduleInstallments().stream().anyMatch(installment -> DateUtils.isBeforeBusinessDate((LocalDate)installment.getDueDate()) && !installment.isObligationsMet());
    }

    public String getEnumStyledName() {
        return "LOAN_INTEREST_RECALCULATION";
    }

    public String getHumanReadableName() {
        return "Loan Interest Recalculation";
    }

    @Generated
    public LoanInterestRecalculationCOBBusinessStep(LoanWritePlatformService loanWritePlatformService) {
        this.loanWritePlatformService = loanWritePlatformService;
    }
}

