/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.common;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class InitialisationTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitialisationTasklet.class);
    private final AppUserRepositoryWrapper userRepository;

    public RepeatStatus execute(@NonNull StepContribution contribution, @NonNull ChunkContext chunkContext) throws Exception {
        HashMap businessDates = ThreadLocalContextUtil.getBusinessDates();
        AppUser user = this.userRepository.fetchSystemUser();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.COB);
        String businessDateString = Objects.requireNonNull((String)chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().get("BusinessDate"));
        LocalDate businessDate = LocalDate.parse(businessDateString, DateTimeFormatter.ISO_DATE);
        businessDates.put(BusinessDateType.COB_DATE, businessDate);
        businessDates.put(BusinessDateType.BUSINESS_DATE, businessDate.plusDays(1L));
        ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
        log.debug("Initialized context with Business Date [{}], COB Date [{}] and Action Context [{}]", new Object[]{businessDate.plusDays(1L), businessDate, ThreadLocalContextUtil.getActionContext()});
        return RepeatStatus.FINISHED;
    }

    @Generated
    public InitialisationTasklet(AppUserRepositoryWrapper userRepository) {
        this.userRepository = userRepository;
    }
}

