/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.journalentry.data.AdvancedMappingtDTO;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.GLAccountBalanceHolder;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.data.LoanTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoan;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.accounting.journalentry.service.JournalAmountHolder;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.accounting.producttoaccountmapping.domain.ProductToGLAccountMapping;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.PortfolioProductType;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionEnumData;
import org.springframework.stereotype.Component;

@Component
public class AccrualBasedAccountingProcessorForLoan
implements AccountingProcessorForLoan {
    private final AccountingProcessorHelper helper;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;

    public void createJournalEntriesForLoan(LoanDTO loanDTO) {
        Long officeId = loanDTO.getOfficeId();
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(officeId.longValue());
        Office office = this.helper.getOfficeById(officeId.longValue());
        for (LoanTransactionDTO loanTransactionDTO : loanDTO.getNewLoanTransactions()) {
            LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            LoanTransactionEnumData transactionType = loanTransactionDTO.getTransactionType();
            if (loanTransactionDTO.isReversed()) {
                this.journalEntryWritePlatformService.createJournalEntryForReversedLoanTransaction(transactionDate, loanTransactionDTO.getTransactionId(), officeId);
                continue;
            }
            if (transactionType.isDisbursement()) {
                this.createJournalEntriesForDisbursements(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isAccrual() || transactionType.isAccrualAdjustment()) {
                this.createJournalEntriesForAccruals(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isRepaymentType() && !transactionType.isChargeAdjustment() || transactionType.isRepaymentAtDisbursement() || transactionType.isChargePayment()) {
                this.createJournalEntriesForRepayments(loanDTO, loanTransactionDTO, office, transactionType.isRepaymentAtDisbursement());
            } else if (transactionType.isRecoveryRepayment()) {
                this.createJournalEntriesForRecoveryRepayments(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isRefund()) {
                this.createJournalEntriesForRefund(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isCreditBalanceRefund()) {
                this.createJournalEntriesForCreditBalanceRefund(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isWriteOff() || transactionType.isWaiveInterest() || transactionType.isWaiveCharges()) {
                this.createJournalEntriesForWriteOffs(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isRefundForActiveLoans()) {
                this.createJournalEntriesForRefundForActiveLoan(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isChargeback()) {
                this.createJournalEntriesForChargeback(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isChargeAdjustment()) {
                this.createJournalEntriesForChargeAdjustment(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isChargeoff()) {
                this.createJournalEntriesForChargeOff(loanDTO, loanTransactionDTO, office);
            } else if (transactionType.isInterestPaymentWaiver() || transactionType.isInterestRefund()) {
                this.createJournalEntriesForInterestPaymentWaiverOrInterestRefund(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isCapitalizedIncome()) {
                this.createJournalEntriesForCapitalizedIncome(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isCapitalizedIncomeAmortization()) {
                this.createJournalEntriesForCapitalizedIncomeAmortization(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isCapitalizedIncomeAdjustment()) {
                this.createJournalEntriesForCapitalizedIncomeAdjustment(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isCapitalizedIncomeAmortizationAdjustment()) {
                this.createJournalEntriesForCapitalizedIncomeAmortizationAdjustment(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isBuyDownFee()) {
                this.createJournalEntriesForBuyDownFee(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isBuyDownFeeAdjustment()) {
                this.createJournalEntriesForBuyDownFeeAdjustment(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isBuyDownFeeAmortization()) {
                this.createJournalEntriesForBuyDownFeeAmortization(loanDTO, loanTransactionDTO, office);
            }
            if (!transactionType.isBuyDownFeeAmortizationAdjustment()) continue;
            this.createJournalEntriesForBuyDownFeeAmortizationAdjustment(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForCapitalizedIncome(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForCapitalizedIncomeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal transactionAmount = loanTransactionDTO.getAmount();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (MathUtil.isGreaterThanZero((BigDecimal)transactionAmount)) {
            GLAccount account;
            if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToCredit(account, principalAmount);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToCredit(account, interestAmount);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToCredit(account, feesAmount);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToCredit(account, penaltiesAmount);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToCredit(account, overPaymentAmount);
            }
            GLAccount accountDeferredIncome = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue().intValue(), paymentTypeId);
            glAccountBalanceHolder.addToDebit(accountDeferredIncome, transactionAmount);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForCapitalizedIncomeAmortization(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedAsChargeOff) {
            this.createJournalEntriesForChargeOffLoanCapitalizedIncomeAmortization(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanCapitalizedIncomeAmortization(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForLoanCapitalizedIncomeAmortization(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        AccountingConstants.AccrualAccountsForLoan creditAccountType;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isLoanWrittenOff = loanDTO.isMarkedAsWrittenOff();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        List classificationCodeValues = loanDTO.getCapitalizedIncomeAdvancedMappingData();
        AccountingConstants.AccrualAccountsForLoan accrualAccountsForLoan = creditAccountType = isLoanWrittenOff ? AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF : AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CAPITALIZATION;
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            if (classificationCodeValues.isEmpty()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            } else {
                classificationCodeValues.stream().forEach(classificationCodeValue -> {
                    ProductToGLAccountMapping mapping = null;
                    if (classificationCodeValue.getReferenceValueId() != null) {
                        mapping = this.fetchAdvanceAccountingMappingForCodeValue(loanProductId, classificationCodeValue.getReferenceValueId(), AccountingConstants.LoanProductAccountingParams.CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue());
                    }
                    if (mapping == null) {
                        if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                        } else {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), creditAccountType.getValue(), glAccountBalanceHolder);
                        }
                    } else if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, mapping.getGlAccount(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                    } else {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), mapping.getGlAccount(), glAccountBalanceHolder);
                    }
                });
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            if (classificationCodeValues.isEmpty()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            } else {
                classificationCodeValues.stream().forEach(classificationCodeValue -> {
                    ProductToGLAccountMapping mapping = null;
                    if (classificationCodeValue.getReferenceValueId() != null) {
                        mapping = this.fetchAdvanceAccountingMappingForCodeValue(loanProductId, classificationCodeValue.getReferenceValueId(), AccountingConstants.LoanProductAccountingParams.CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue());
                    }
                    if (mapping == null) {
                        if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                        } else {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), creditAccountType.getValue(), glAccountBalanceHolder);
                        }
                    } else if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, mapping.getGlAccount(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                    } else {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), mapping.getGlAccount(), glAccountBalanceHolder);
                    }
                });
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private ProductToGLAccountMapping fetchAdvanceAccountingMappingForCodeValue(Long loanProductId, Long codeValueId, String codeName) {
        return this.helper.getClassificationMappingByCodeValue(loanProductId, PortfolioProductType.LOAN, codeValueId, codeName);
    }

    private void createJournalEntriesForChargeOffLoanCapitalizedIncomeAmortization(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        ProductToGLAccountMapping mapping;
        Long loanProductId = loanDTO.getLoanProductId();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        Long chargeOffReasonCodeValue = loanDTO.getChargeOffReasonCodeValue();
        ProductToGLAccountMapping productToGLAccountMapping = mapping = chargeOffReasonCodeValue != null ? this.helper.getChargeOffMappingByCodeValue(loanProductId, PortfolioProductType.LOAN, chargeOffReasonCodeValue) : null;
        if (mapping != null) {
            GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue().intValue(), paymentTypeId);
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                glAccountBalanceHolder.addToCredit(mapping.getGlAccount(), interestAmount);
                glAccountBalanceHolder.addToDebit(accountDebit, interestAmount);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                glAccountBalanceHolder.addToCredit(mapping.getGlAccount(), feesAmount);
                glAccountBalanceHolder.addToDebit(accountDebit, feesAmount);
            }
        } else {
            AccountingConstants.AccrualAccountsForLoan creditAccountType;
            AccountingConstants.AccrualAccountsForLoan accrualAccountsForLoan = creditAccountType = isMarkedFraud ? AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE : AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE;
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForCapitalizedIncomeAmortizationAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (MathUtil.isGreaterThanZero((BigDecimal)loanTransactionDTO.getAmount())) {
            this.populateCreditDebitMaps(loanDTO.getLoanProductId(), loanTransactionDTO.getAmount(), loanTransactionDTO.getPaymentTypeId(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CAPITALIZATION.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, loanDTO.getCurrencyCode(), loanDTO.getLoanId(), loanTransactionDTO.getTransactionId(), loanTransactionDTO.getTransactionDate(), (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, loanDTO.getCurrencyCode(), loanDTO.getLoanId(), loanTransactionDTO.getTransactionId(), loanTransactionDTO.getTransactionDate(), (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForBuyDownFee(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        AccountingConstants.AccrualAccountsForLoan debitAccountType;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        AccountingConstants.AccrualAccountsForLoan accrualAccountsForLoan = debitAccountType = loanDTO.isMerchantBuyDownFee() ? AccountingConstants.AccrualAccountsForLoan.BUY_DOWN_EXPENSE : AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE;
        if (MathUtil.isGreaterThanZero((BigDecimal)amount)) {
            this.helper.createJournalEntriesForLoan(office, currencyCode, debitAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
        }
    }

    private void createJournalEntriesForBuyDownFeeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        AccountingConstants.AccrualAccountsForLoan debitAccountType;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        AccountingConstants.AccrualAccountsForLoan accrualAccountsForLoan = debitAccountType = loanDTO.isMerchantBuyDownFee() ? AccountingConstants.AccrualAccountsForLoan.BUY_DOWN_EXPENSE : AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE;
        if (MathUtil.isGreaterThanZero((BigDecimal)amount)) {
            this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), debitAccountType.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
        }
    }

    private void createJournalEntriesForBuyDownFeeAmortization(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedAsChargeOff) {
            this.createJournalEntriesForChargeOffLoanBuyDownFeeAmortization(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanBuyDownFeeAmortization(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForLoanBuyDownFeeAmortization(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        AccountingConstants.AccrualAccountsForLoan creditAccountType;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isLoanWrittenOff = loanDTO.isMarkedAsWrittenOff();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        List classificationCodeValues = loanDTO.getBuydownFeeAdvancedMappingData();
        AccountingConstants.AccrualAccountsForLoan accrualAccountsForLoan = creditAccountType = isLoanWrittenOff ? AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF : AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_BUY_DOWN;
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            if (classificationCodeValues.isEmpty()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            } else {
                classificationCodeValues.forEach(classificationCodeValue -> {
                    ProductToGLAccountMapping mapping = null;
                    if (classificationCodeValue.getReferenceValueId() != null) {
                        mapping = this.fetchAdvanceAccountingMappingForCodeValue(loanProductId, classificationCodeValue.getReferenceValueId(), AccountingConstants.LoanProductAccountingParams.BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue());
                    }
                    if (mapping == null) {
                        if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                        } else {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), creditAccountType.getValue(), glAccountBalanceHolder);
                        }
                    } else if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, mapping.getGlAccount(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                    } else {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), mapping.getGlAccount(), glAccountBalanceHolder);
                    }
                });
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            if (classificationCodeValues.isEmpty()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            } else {
                classificationCodeValues.stream().forEach(classificationCodeValue -> {
                    ProductToGLAccountMapping mapping = null;
                    if (classificationCodeValue.getReferenceValueId() != null) {
                        mapping = this.fetchAdvanceAccountingMappingForCodeValue(loanProductId, classificationCodeValue.getReferenceValueId(), AccountingConstants.LoanProductAccountingParams.BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue());
                    }
                    if (mapping == null) {
                        if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                        } else {
                            this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), creditAccountType.getValue(), glAccountBalanceHolder);
                        }
                    } else if (MathUtil.isGreaterThanZero((BigDecimal)classificationCodeValue.getAmount())) {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount(), paymentTypeId, mapping.getGlAccount(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
                    } else {
                        this.populateCreditDebitMaps(loanProductId, classificationCodeValue.getAmount().negate(), paymentTypeId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), mapping.getGlAccount(), glAccountBalanceHolder);
                    }
                });
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForChargeOffLoanBuyDownFeeAmortization(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        ProductToGLAccountMapping mapping;
        Long loanProductId = loanDTO.getLoanProductId();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        Long chargeOffReasonCodeValue = loanDTO.getChargeOffReasonCodeValue();
        ProductToGLAccountMapping productToGLAccountMapping = mapping = chargeOffReasonCodeValue != null ? this.helper.getChargeOffMappingByCodeValue(loanProductId, PortfolioProductType.LOAN, chargeOffReasonCodeValue) : null;
        if (mapping != null) {
            GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue().intValue(), paymentTypeId);
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                glAccountBalanceHolder.addToCredit(mapping.getGlAccount(), interestAmount);
                glAccountBalanceHolder.addToDebit(accountDebit, interestAmount);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                glAccountBalanceHolder.addToCredit(mapping.getGlAccount(), feesAmount);
                glAccountBalanceHolder.addToDebit(accountDebit, feesAmount);
            }
        } else {
            AccountingConstants.AccrualAccountsForLoan creditAccountType;
            AccountingConstants.AccrualAccountsForLoan accrualAccountsForLoan = creditAccountType = isMarkedFraud ? AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE : AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE;
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, creditAccountType.getValue(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForBuyDownFeeAmortizationAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (MathUtil.isGreaterThanZero((BigDecimal)loanTransactionDTO.getAmount())) {
            this.populateCreditDebitMaps(loanDTO.getLoanProductId(), loanTransactionDTO.getAmount(), loanTransactionDTO.getPaymentTypeId(), AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_BUY_DOWN.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, loanDTO.getCurrencyCode(), loanDTO.getLoanId(), loanTransactionDTO.getTransactionId(), loanTransactionDTO.getTransactionDate(), (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, loanDTO.getCurrencyCode(), loanDTO.getLoanId(), loanTransactionDTO.getTransactionId(), loanTransactionDTO.getTransactionDate(), (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForInterestPaymentWaiverOrInterestRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPayment = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (isMarkedAsChargeOff) {
            if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)overPayment)) {
                this.populateCreditDebitMaps(loanProductId, overPayment, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
        } else {
            if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (MathUtil.isGreaterThanZero((BigDecimal)overPayment)) {
                this.populateCreditDebitMaps(loanProductId, overPayment, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void createJournalEntriesForChargeOff(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        ProductToGLAccountMapping mapping;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        Long chargeOffReasonCodeValue = loanDTO.getChargeOffReasonCodeValue();
        ProductToGLAccountMapping productToGLAccountMapping = mapping = chargeOffReasonCodeValue != null ? this.helper.getChargeOffMappingByCodeValue(loanProductId, PortfolioProductType.LOAN, chargeOffReasonCodeValue) : null;
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            if (mapping != null) {
                GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToCredit(accountCredit, principalAmount);
                glAccountBalanceHolder.addToDebit(mapping.getGlAccount(), principalAmount);
            } else if (isMarkedFraud) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), glAccountBalanceHolder);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), glAccountBalanceHolder);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), glAccountBalanceHolder);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)debitEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void populateCreditDebitMaps(Long loanProductId, BigDecimal transactionPartAmount, Long paymentTypeId, Integer creditAccountType, Integer debitAccountType, GLAccountBalanceHolder glAccountBalanceHolder) {
        if (MathUtil.isGreaterThanZero((BigDecimal)transactionPartAmount)) {
            GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, creditAccountType.intValue(), paymentTypeId);
            glAccountBalanceHolder.addToCredit(accountCredit, transactionPartAmount);
            GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, debitAccountType.intValue(), paymentTypeId);
            glAccountBalanceHolder.addToDebit(accountDebit, transactionPartAmount);
        }
    }

    private void populateCreditDebitMaps(Long loanProductId, BigDecimal transactionPartAmount, Long paymentTypeId, GLAccount accountCredit, Integer debitAccountType, GLAccountBalanceHolder glAccountBalanceHolder) {
        if (MathUtil.isGreaterThanZero((BigDecimal)transactionPartAmount)) {
            glAccountBalanceHolder.addToCredit(accountCredit, transactionPartAmount);
            GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, debitAccountType.intValue(), paymentTypeId);
            glAccountBalanceHolder.addToDebit(accountDebit, transactionPartAmount);
        }
    }

    private void populateCreditDebitMaps(Long loanProductId, BigDecimal transactionPartAmount, Long paymentTypeId, Integer creditAccountType, GLAccount accountDebit, GLAccountBalanceHolder glAccountBalanceHolder) {
        if (MathUtil.isGreaterThanZero((BigDecimal)transactionPartAmount)) {
            GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, creditAccountType.intValue(), paymentTypeId);
            glAccountBalanceHolder.addToCredit(accountCredit, transactionPartAmount);
            glAccountBalanceHolder.addToDebit(accountDebit, transactionPartAmount);
        }
    }

    private void createJournalEntriesForChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedAsChargeOff) {
            this.createJournalEntriesForChargeOffLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForChargeOffLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Object account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<Object, BigDecimal> accountMap = new LinkedHashMap<Object, BigDecimal>();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)entry.getValue()))) continue;
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), (GLAccount)entry.getKey());
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            void var18_29;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, var18_29.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Object account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<Object, BigDecimal> accountMap = new LinkedHashMap<Object, BigDecimal>();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)entry.getValue()))) continue;
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), (GLAccount)entry.getKey());
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            void var18_29;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, var18_29.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void createJournalEntriesForChargeback(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        BigDecimal penaltyPaid;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal overpaidAmount = Objects.isNull(loanTransactionDTO.getOverPayment()) ? BigDecimal.ZERO : loanTransactionDTO.getOverPayment();
        BigDecimal principalCredited = Objects.isNull(loanTransactionDTO.getPrincipal()) ? BigDecimal.ZERO : loanTransactionDTO.getPrincipal();
        BigDecimal feeCredited = Objects.isNull(loanTransactionDTO.getFees()) ? BigDecimal.ZERO : loanTransactionDTO.getFees();
        BigDecimal penaltyCredited = Objects.isNull(loanTransactionDTO.getPenalties()) ? BigDecimal.ZERO : loanTransactionDTO.getPenalties();
        BigDecimal principalPaid = Objects.isNull(loanTransactionDTO.getPrincipalPaid()) ? BigDecimal.ZERO : loanTransactionDTO.getPrincipalPaid();
        BigDecimal feePaid = Objects.isNull(loanTransactionDTO.getFeePaid()) ? BigDecimal.ZERO : loanTransactionDTO.getFeePaid();
        BigDecimal bigDecimal = penaltyPaid = Objects.isNull(loanTransactionDTO.getPenaltyPaid()) ? BigDecimal.ZERO : loanTransactionDTO.getPenaltyPaid();
        if (MathUtil.isGreaterThanZero((BigDecimal)amount)) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overpaidAmount)) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overpaidAmount);
        }
        if (principalCredited.compareTo(principalPaid) > 0) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, this.getPrincipalAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalCredited.subtract(principalPaid));
        } else if (principalCredited.compareTo(principalPaid) < 0) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, this.getPrincipalAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalPaid.subtract(principalCredited));
        }
        if (feeCredited.compareTo(feePaid) > 0) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, this.getFeeAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, feeCredited.subtract(feePaid));
        } else if (feeCredited.compareTo(feePaid) < 0) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, this.getFeeAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, feePaid.subtract(feeCredited));
        }
        if (penaltyCredited.compareTo(penaltyPaid) > 0) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, this.getPenaltyAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, penaltyCredited.subtract(penaltyPaid));
        } else if (penaltyCredited.compareTo(penaltyPaid) < 0) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, this.getPenaltyAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, penaltyPaid.subtract(penaltyCredited));
        }
    }

    private Integer getFeeAccount(LoanDTO loanDTO) {
        Integer account = AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue();
        if (loanDTO.isMarkedAsChargeOff()) {
            account = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue();
        }
        return account;
    }

    private Integer getPenaltyAccount(LoanDTO loanDTO) {
        Integer account = AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue();
        if (loanDTO.isMarkedAsChargeOff()) {
            account = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue();
        }
        return account;
    }

    private Integer getPrincipalAccount(LoanDTO loanDTO) {
        if (loanDTO.isMarkedAsFraud() && loanDTO.isMarkedAsChargeOff()) {
            return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue();
        }
        if (!loanDTO.isMarkedAsFraud() && loanDTO.isMarkedAsChargeOff()) {
            return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue();
        }
        return AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue();
    }

    private void createJournalEntriesForDisbursements(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal overpaymentPortion = loanTransactionDTO.getOverPayment() != null ? loanTransactionDTO.getOverPayment() : BigDecimal.ZERO;
        BigDecimal loanTransactionDTOAmount = loanTransactionDTO.getAmount();
        BigDecimal principalPortion = loanTransactionDTOAmount.subtract(overpaymentPortion);
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalPortion)) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalPortion);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overpaymentPortion)) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overpaymentPortion);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)loanTransactionDTOAmount)) {
            if (loanTransactionDTO.isLoanToLoanTransfer()) {
                this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTOAmount);
            } else if (loanTransactionDTO.isAccountTransfer()) {
                this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTOAmount);
            } else {
                this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTOAmount);
            }
        }
    }

    private void createJournalEntriesForRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean isIncomeFromFee) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedChargeOff) {
            this.createJournalEntriesForRepaymentWhenLoanIsChargedOff(loanDTO, loanTransactionDTO, office, isIncomeFromFee);
        } else {
            this.createJournalEntriesForLoanRepayments(loanDTO, loanTransactionDTO, office, isIncomeFromFee);
        }
    }

    private void createJournalEntriesForWriteOffs(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedChargeOff) {
            this.createJournalEntriesForWriteOffsWhenLoanIsChargedOff(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanWriteOffs(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForRepaymentWhenLoanIsChargedOff(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean isIncomeFromFee) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (isIncomeFromFee) {
                this.helper.createCreditJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, loanTransactionDTO.getFeePayments());
                GLAccount debitAccount = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToDebit(debitAccount, feesAmount);
            } else {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (isIncomeFromFee) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            if (loanTransactionDTO.isLoanToLoanTransfer()) {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
            } else if (loanTransactionDTO.isAccountTransfer()) {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
            } else {
                for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
                    glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
                    this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
                }
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount) && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesForLoan(office, currencyCode, incomeAccount, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void createJournalEntriesForWriteOffsWhenLoanIsChargedOff(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            if (isMarkedFraud) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)creditEntry.getValue()))) continue;
            GLAccount glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void createJournalEntriesForLoanRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean isIncomeFromFee) {
        Object account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<Object, BigDecimal> accountMap = new LinkedHashMap<Object, BigDecimal>();
        LinkedHashMap debitAccountMapForGoodwillCredit = new LinkedHashMap();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, principalAmount, AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, interestAmount, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            if (isIncomeFromFee) {
                this.helper.createCreditJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, loanTransactionDTO.getFeePayments());
            } else {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue(), paymentTypeId);
                if (accountMap.containsKey(account)) {
                    BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                    accountMap.put(account, bigDecimal);
                } else {
                    accountMap.put(account, feesAmount);
                }
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, feesAmount, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            if (isIncomeFromFee) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), paymentTypeId);
                if (accountMap.containsKey(account)) {
                    BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                    accountMap.put(account, bigDecimal);
                } else {
                    accountMap.put(account, penaltiesAmount);
                }
            } else {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue(), paymentTypeId);
                if (accountMap.containsKey(account)) {
                    BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                    accountMap.put(account, bigDecimal);
                } else {
                    accountMap.put(account, penaltiesAmount);
                }
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, penaltiesAmount, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, overPaymentAmount, AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)entry.getValue()))) continue;
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), (GLAccount)entry.getKey());
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            if (loanTransactionDTO.isLoanToLoanTransfer()) {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
            } else if (loanTransactionDTO.isAccountTransfer()) {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                for (Map.Entry entry : debitAccountMapForGoodwillCredit.entrySet()) {
                    this.helper.createDebitJournalEntryForLoan(office, currencyCode, ((Integer)entry.getKey()).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue());
                }
            } else {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount) && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesForLoan(office, currencyCode, incomeAccount, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void createJournalEntriesForLoanWriteOffs(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Object account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<Object, BigDecimal> accountMap = new LinkedHashMap<Object, BigDecimal>();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            if (!MathUtil.isGreaterThanZero((BigDecimal)((BigDecimal)entry.getValue()))) continue;
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), (GLAccount)entry.getKey());
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            ProductToGLAccountMapping productToGLAccountMapping;
            AdvancedMappingtDTO writeAdvancedMappingtDTO = loanDTO.getWriteOffReasonAdvancedMappingData();
            ProductToGLAccountMapping productToGLAccountMapping2 = productToGLAccountMapping = writeAdvancedMappingtDTO != null && writeAdvancedMappingtDTO.getReferenceValueId() != null ? this.helper.getWriteOffMappingByCodeValue(loanProductId, PortfolioProductType.LOAN, writeAdvancedMappingtDTO.getReferenceValueId()) : null;
            if (productToGLAccountMapping == null) {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
            } else {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, productToGLAccountMapping.getGlAccount(), loanId, transactionId, transactionDate, totalDebitAmount);
            }
        }
    }

    private void populateDebitAccountEntry(Long loanProductId, BigDecimal transactionPartAmount, Integer debitAccountType, Map<Integer, BigDecimal> accountMapForDebit, Long paymentTypeId) {
        Integer accountDebit = this.returnExistingDebitAccountInMapMatchingGLAccount(loanProductId, paymentTypeId, debitAccountType, accountMapForDebit);
        if (accountMapForDebit.containsKey(accountDebit)) {
            BigDecimal amount = accountMapForDebit.get(accountDebit).add(transactionPartAmount);
            accountMapForDebit.put(accountDebit, amount);
        } else {
            accountMapForDebit.put(accountDebit, transactionPartAmount);
        }
    }

    private Integer returnExistingDebitAccountInMapMatchingGLAccount(Long loanProductId, Long paymentTypeId, Integer accountType, Map<Integer, BigDecimal> accountMap) {
        GLAccount glAccount = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, accountType.intValue(), paymentTypeId);
        Integer accountEntry = accountMap.entrySet().stream().filter(account -> this.helper.getLinkedGLAccountForLoanProduct(loanProductId, ((Integer)account.getKey()).intValue(), paymentTypeId).getGlCode().equals(glAccount.getGlCode())).map(Map.Entry::getKey).findFirst().orElse(accountType);
        return accountEntry;
    }

    private void createJournalEntriesForRecoveryRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)amount)) {
            this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
        }
    }

    private void createJournalEntriesForAccruals(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        LoanTransactionEnumData transactionType = loanTransactionDTO.getTransactionType();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            if (transactionType.isAccrualAdjustment()) {
                this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount);
            } else {
                this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount);
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            if (transactionType.isAccrualAdjustment()) {
                this.helper.createJournalEntriesForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue(), AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, loanTransactionDTO.getFeePayments());
            } else {
                this.helper.createJournalEntriesForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, loanTransactionDTO.getFeePayments());
            }
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            if (transactionType.isAccrualAdjustment()) {
                this.helper.createJournalEntriesForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, loanTransactionDTO.getPenaltyPayments());
            } else {
                this.helper.createJournalEntriesForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, loanTransactionDTO.getPenaltyPayments());
            }
        }
    }

    private void createJournalEntriesForRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal refundAmount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)refundAmount)) {
            if (loanTransactionDTO.isAccountTransfer()) {
                this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount);
            } else {
                this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount);
            }
        }
    }

    private void createJournalEntriesForCreditBalanceRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        this.createJournalEntriesForLoanCreditBalanceRefund(loanDTO, loanTransactionDTO, office, isMarkedChargeOff);
    }

    private void createJournalEntriesForLoanCreditBalanceRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean isMarkedChargeOff) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal overpaymentAmount = loanTransactionDTO.getOverPayment();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<JournalAmountHolder> journalAmountHolders = new ArrayList<JournalAmountHolder>();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalAmount = totalAmount.add(principalAmount);
            journalAmountHolders.add(new JournalAmountHolder(this.determineAccrualAccountForCBR(isMarkedChargeOff, isMarkedFraud, false), principalAmount));
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overpaymentAmount)) {
            totalAmount = totalAmount.add(overpaymentAmount);
            journalAmountHolders.add(new JournalAmountHolder(this.determineAccrualAccountForCBR(isMarkedChargeOff, isMarkedFraud, true), overpaymentAmount));
        }
        JournalAmountHolder totalAmountHolder = new JournalAmountHolder(AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), totalAmount);
        this.helper.createSplitJournalEntriesForLoan(office, currencyCode, journalAmountHolders, totalAmountHolder, loanProductId, paymentTypeId, loanId, transactionId, transactionDate);
    }

    private Integer determineAccrualAccountForCBR(boolean isMarkedChargeOff, boolean isMarkedFraud, boolean isOverpayment) {
        if (isOverpayment) {
            return AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue();
        }
        if (isMarkedChargeOff) {
            if (isMarkedFraud) {
                return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue();
            }
            return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue();
        }
        return AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue();
    }

    private void createJournalEntriesForRefundForActiveLoan(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        ArrayList<ChargePaymentDTO> chargePaymentDTOs;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (MathUtil.isGreaterThanZero((BigDecimal)principalAmount)) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)interestAmount)) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feesAmount)) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            chargePaymentDTOs = new ArrayList<ChargePaymentDTO>();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getFeePayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, chargePaymentDTOs);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)penaltiesAmount)) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            chargePaymentDTOs = new ArrayList();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getPenaltyPayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, chargePaymentDTOs);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overPaymentAmount)) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overPaymentAmount);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)totalDebitAmount)) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    @Generated
    public AccrualBasedAccountingProcessorForLoan(AccountingProcessorHelper helper, JournalEntryWritePlatformService journalEntryWritePlatformService) {
        this.helper = helper;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
    }
}

