/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import lombok.Generated;
import org.apache.fineract.accounting.journalentry.data.SavingsDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForSavings;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AccountingProcessorForSavingsFactory {
    private final ApplicationContext applicationContext;

    public AccountingProcessorForSavings determineProcessor(SavingsDTO savingsDTO) {
        AccountingProcessorForSavings accountingProcessorForSavings = null;
        if (savingsDTO.isCashBasedAccountingEnabled()) {
            accountingProcessorForSavings = (AccountingProcessorForSavings)this.applicationContext.getBean("cashBasedAccountingProcessorForSavings", AccountingProcessorForSavings.class);
        } else if (savingsDTO.isAccrualBasedAccountingEnabled()) {
            accountingProcessorForSavings = (AccountingProcessorForSavings)this.applicationContext.getBean("accrualBasedAccountingProcessorForSavings", AccountingProcessorForSavings.class);
        }
        return accountingProcessorForSavings;
    }

    @Generated
    public AccountingProcessorForSavingsFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

