/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.data;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;

public class GLAccountBalanceHolder {
    private final Map<Long, GLAccount> glAccountMap = new LinkedHashMap();
    private final Map<Long, BigDecimal> debitBalances = new LinkedHashMap();
    private final Map<Long, BigDecimal> creditBalances = new LinkedHashMap();

    public void addToCredit(@NotNull GLAccount creditAccount, @NotNull BigDecimal amount) {
        this.addToProperBalance(this.creditBalances, creditAccount, amount);
    }

    public void addToDebit(@NotNull GLAccount debitAccount, @NotNull BigDecimal amount) {
        this.addToProperBalance(this.debitBalances, debitAccount, amount);
    }

    private void addToProperBalance(@NotNull Map<Long, BigDecimal> balanceMap, @NotNull.List(value={@NotNull, @NotNull}) @NotNull.List(value={@NotNull, @NotNull}) GLAccount account, @NotNull BigDecimal amount) {
        this.glAccountMap.putIfAbsent((Long)account.getId(), account);
        if (balanceMap.containsKey(account.getId())) {
            BigDecimal totalAmount = balanceMap.get(account.getId()).add(amount);
            balanceMap.put((Long)account.getId(), totalAmount);
        } else {
            balanceMap.put((Long)account.getId(), amount);
        }
    }

    @Generated
    public GLAccountBalanceHolder() {
    }

    @Generated
    public Map<Long, GLAccount> getGlAccountMap() {
        return this.glAccountMap;
    }

    @Generated
    public Map<Long, BigDecimal> getDebitBalances() {
        return this.debitBalances;
    }

    @Generated
    public Map<Long, BigDecimal> getCreditBalances() {
        return this.creditBalances;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GLAccountBalanceHolder)) {
            return false;
        }
        GLAccountBalanceHolder other = (GLAccountBalanceHolder)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$glAccountMap = this.getGlAccountMap();
        Map other$glAccountMap = other.getGlAccountMap();
        if (this$glAccountMap == null ? other$glAccountMap != null : !((Object)this$glAccountMap).equals(other$glAccountMap)) {
            return false;
        }
        Map this$debitBalances = this.getDebitBalances();
        Map other$debitBalances = other.getDebitBalances();
        if (this$debitBalances == null ? other$debitBalances != null : !((Object)this$debitBalances).equals(other$debitBalances)) {
            return false;
        }
        Map this$creditBalances = this.getCreditBalances();
        Map other$creditBalances = other.getCreditBalances();
        return !(this$creditBalances == null ? other$creditBalances != null : !((Object)this$creditBalances).equals(other$creditBalances));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GLAccountBalanceHolder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $glAccountMap = this.getGlAccountMap();
        result = result * 59 + ($glAccountMap == null ? 43 : ((Object)$glAccountMap).hashCode());
        Map $debitBalances = this.getDebitBalances();
        result = result * 59 + ($debitBalances == null ? 43 : ((Object)$debitBalances).hashCode());
        Map $creditBalances = this.getCreditBalances();
        result = result * 59 + ($creditBalances == null ? 43 : ((Object)$creditBalances).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GLAccountBalanceHolder(glAccountMap=" + String.valueOf(this.getGlAccountMap()) + ", debitBalances=" + String.valueOf(this.getDebitBalances()) + ", creditBalances=" + String.valueOf(this.getCreditBalances()) + ")";
    }
}

