/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.journalentry.api.JournalEntriesApiResourceSwagger;
import org.apache.fineract.accounting.journalentry.command.JournalEntryCommand;
import org.apache.fineract.accounting.journalentry.data.JournalEntryAssociationParametersData;
import org.apache.fineract.accounting.journalentry.data.JournalEntryData;
import org.apache.fineract.accounting.journalentry.data.OfficeOpeningBalancesData;
import org.apache.fineract.accounting.journalentry.service.JournalEntryReadPlatformService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.PortfolioProductType;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/journalentries")
@Component
@Tag(name="Journal Entries", description="A journal entry refers to the logging of transactions against general ledger accounts. A journal entry may consist of several line items, each of which is either a \"debit\" or a \"credit\". The total amount of the debits must equal the total amount of the credits or the journal entry is said to be \"unbalanced\" \n\nA journal entry directly changes the account balances on the general ledger")
public class JournalEntriesApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "officeId", "officeName", "glAccountName", "glAccountId", "glAccountCode", "glAccountType", "transactionDate", "entryType", "amount", "transactionId", "manualEntry", "entityType", "entityId", "createdByUserId", "createdDate", "submittedOnDate", "createdByUserName", "comments", "reversed", "referenceNumber", "currency", "transactionDetails"));
    private static final String RESOURCE_NAME_FOR_PERMISSION = "JOURNALENTRY";
    private final PlatformSecurityContext context;
    private final JournalEntryReadPlatformService journalEntryReadPlatformService;
    private final DefaultToApiJsonSerializer<Object> apiJsonSerializerService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Journal Entries", description="The list capability of journal entries can support pagination and sorting.\n\nExample Requests:\n\njournalentries\n\njournalentries?transactionId=PB37X8Y21EQUY4S\n\njournalentries?officeId=1&manualEntriesOnly=true&fromDate=1 July 2013&toDate=15 July 2013&dateFormat=dd MMMM yyyy&locale=en\n\njournalentries?fields=officeName,glAccountName,transactionDate\n\njournalentries?offset=10&limit=50\n\njournalentries?orderBy=transactionId&sortOrder=DESC\n\njournalentries?runningBalance=true\n\njournalentries?transactionDetails=true\n\njournalentries?loanId=12\n\njournalentries?savingsId=24")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=JournalEntriesApiResourceSwagger.GetJournalEntriesTransactionIdResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @QueryParam(value="glAccountId") @Parameter(description="glAccountId") Long glAccountId, @QueryParam(value="manualEntriesOnly") @Parameter(description="manualEntriesOnly") Boolean onlyManualEntries, @QueryParam(value="fromDate") @Parameter(description="fromDate") DateParam fromDateParam, @QueryParam(value="toDate") @Parameter(description="toDate") DateParam toDateParam, @QueryParam(value="submittedOnDateFrom") @Parameter(description="submittedOnDateFrom") DateParam submittedOnDateFromParam, @QueryParam(value="submittedOnDateTo") @Parameter(description="submittedOnDateTo") DateParam submittedOnDateToParam, @QueryParam(value="transactionId") @Parameter(description="transactionId") String transactionId, @QueryParam(value="entityType") @Parameter(description="entityType") Integer entityType, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="locale") @Parameter(description="locale") String locale, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String rawDateFormat, @QueryParam(value="loanId") @Parameter(description="loanId") Long loanId, @QueryParam(value="savingsId") @Parameter(description="savingsId") Long savingsId, @QueryParam(value="runningBalance") @Parameter(description="runningBalance") boolean runningBalance, @QueryParam(value="transactionDetails") @Parameter(description="transactionDetails") boolean transactionDetails) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        DateFormat dateFormat = StringUtils.isBlank((CharSequence)rawDateFormat) ? null : new DateFormat(rawDateFormat);
        LocalDate fromDate = null;
        if (fromDateParam != null) {
            fromDate = fromDateParam.getDate("fromDate", dateFormat, locale);
        }
        LocalDate toDate = null;
        if (toDateParam != null) {
            toDate = toDateParam.getDate("toDate", dateFormat, locale);
        }
        LocalDate submittedOnDateFrom = null;
        if (submittedOnDateFromParam != null) {
            submittedOnDateFrom = submittedOnDateFromParam.getDate("submittedOnDateFrom", dateFormat, locale);
        }
        LocalDate submittedOnDateTo = null;
        if (submittedOnDateToParam != null) {
            submittedOnDateTo = submittedOnDateToParam.getDate("submittedOnDateTo", dateFormat, locale);
        }
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).officeId(officeId).offset(offset).orderBy(orderBy).sortOrder(sortOrder).loanId(loanId).savingsId(savingsId).build();
        JournalEntryAssociationParametersData associationParametersData = new JournalEntryAssociationParametersData(transactionDetails, runningBalance);
        Page glJournalEntries = this.journalEntryReadPlatformService.retrieveAll(searchParameters, glAccountId, onlyManualEntries, fromDate, toDate, submittedOnDateFrom, submittedOnDateTo, transactionId, entityType, associationParametersData);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.apiJsonSerializerService.serialize(settings, (Object)glJournalEntries, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{journalEntryId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a single Entry", description="Example Requests:\n\njournalentries/1\n\n\n\njournalentries/1?fields=officeName,glAccountId,entryType,amount\n\njournalentries/1?runningBalance=true\n\njournalentries/1?transactionDetails=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=JournalEntriesApiResourceSwagger.JournalEntryTransactionItem.class))})})
    public String retrieveJournalEntryById(@PathParam(value="journalEntryId") @Parameter(description="journalEntryId") Long journalEntryId, @Context UriInfo uriInfo, @QueryParam(value="runningBalance") @Parameter(description="runningBalance") boolean runningBalance, @QueryParam(value="transactionDetails") @Parameter(description="transactionDetails") boolean transactionDetails) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        JournalEntryAssociationParametersData associationParametersData = new JournalEntryAssociationParametersData(transactionDetails, runningBalance);
        JournalEntryData glJournalEntryData = this.journalEntryReadPlatformService.retrieveGLJournalEntryById(journalEntryId.longValue(), associationParametersData);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.apiJsonSerializerService.serialize(settings, (Object)glJournalEntryData, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create \"Balanced\" Journal Entries", description="Note: A Balanced (simple) Journal entry would have atleast one \"Debit\" and one \"Credit\" entry whose amounts are equal \nCompound Journal entries may have \"n\" debits and \"m\" credits where both \"m\" and \"n\" are greater than 0 and the net sum or all debits and credits are equal \n\n\nMandatory Fields\nofficeId, transactionDate\n\n\ncredits- glAccountId, amount, comments\n\n \ndebits-  glAccountId, amount, comments\n\n \nOptional Fields\npaymentTypeId, accountNumber, checkNumber, routingCode, receiptNumber, bankNumber")
    @RequestBody(content={@Content(schema=@Schema(implementation=JournalEntryCommand.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=JournalEntriesApiResourceSwagger.PostJournalEntriesResponse.class))})})
    public String createGLJournalEntry(@Parameter(hidden=true) String jsonRequestBody, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        CommandProcessingResult result;
        if (this.is(commandParam, "updateRunningBalance")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().updateRunningBalanceForJournalEntry().withJson(jsonRequestBody).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "defineOpeningBalance")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().defineOpeningBalanceForJournalEntry().withJson(jsonRequestBody).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else {
            CommandWrapper commandRequest = new CommandWrapperBuilder().createJournalEntry().withJson(jsonRequestBody).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return this.apiJsonSerializerService.serialize((Object)result);
    }

    @POST
    @Path(value="{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Running balances for Journal Entries", description="This API calculates the running balances for office. If office ID not provided this API calculates running balances for all offices. \nMandatory Fields\nofficeId")
    @RequestBody(content={@Content(schema=@Schema(implementation=JournalEntriesApiResourceSwagger.PostJournalEntriesTransactionIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=JournalEntriesApiResourceSwagger.PostJournalEntriesTransactionIdResponse.class))})})
    public String createReversalJournalEntry(@Parameter(hidden=true) String jsonRequestBody, @PathParam(value="transactionId") @Parameter(description="transactionId") String transactionId, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        if (!this.is(commandParam, "reverse")) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        CommandWrapper commandRequest = new CommandWrapperBuilder().reverseJournalEntry(transactionId).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializerService.serialize((Object)result);
    }

    @GET
    @Path(value="provisioning")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveJournalEntries(@QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="entryId") Long entryId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser();
        String transactionId = "P" + entryId;
        SearchParameters params = SearchParameters.builder().limit(limit).offset(offset).build();
        Page entries = this.journalEntryReadPlatformService.retrieveAll(params, null, null, null, null, null, null, transactionId, PortfolioProductType.PROVISIONING.getValue(), null);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.apiJsonSerializerService.serialize(settings, (Object)entries, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="openingbalance")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveOpeningBalance(@Context UriInfo uriInfo, @QueryParam(value="officeId") Long officeId, @QueryParam(value="currencyCode") String currencyCode) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        OfficeOpeningBalancesData officeOpeningBalancesData = this.journalEntryReadPlatformService.retrieveOfficeOpeningBalances(officeId, currencyCode);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.apiJsonSerializerService.serialize(settings, (Object)officeOpeningBalancesData);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getJournalEntriesTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.GL_JOURNAL_ENTRIES.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload journal entries template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postJournalEntriesTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.GL_JOURNAL_ENTRIES.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.apiJsonSerializerService.serialize((Object)importDocumentId);
    }

    @Generated
    public JournalEntriesApiResource(PlatformSecurityContext context, JournalEntryReadPlatformService journalEntryReadPlatformService, DefaultToApiJsonSerializer<Object> apiJsonSerializerService, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, SqlValidator sqlValidator) {
        this.context = context;
        this.journalEntryReadPlatformService = journalEntryReadPlatformService;
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.sqlValidator = sqlValidator;
    }
}

