/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.fineract.client.models.ExtensionData;
import org.apache.fineract.client.models.GeoCodeData;
import org.apache.fineract.client.models.InteropTransactionTypeData;
import org.apache.fineract.client.models.MoneyData;

public class InteropTransferRequestData {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
    @SerializedName(value="accountId")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private MoneyData amount;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private OffsetDateTime expiration;
    public static final String SERIALIZED_NAME_EXPIRATION_LOCAL_DATE = "expirationLocalDate";
    @SerializedName(value="expirationLocalDate")
    private LocalDate expirationLocalDate;
    public static final String SERIALIZED_NAME_EXTENSION_LIST = "extensionList";
    @SerializedName(value="extensionList")
    private List<ExtensionData> extensionList;
    public static final String SERIALIZED_NAME_FSP_COMMISSION = "fspCommission";
    @SerializedName(value="fspCommission")
    private MoneyData fspCommission;
    public static final String SERIALIZED_NAME_FSP_FEE = "fspFee";
    @SerializedName(value="fspFee")
    private MoneyData fspFee;
    public static final String SERIALIZED_NAME_GEO_CODE = "geoCode";
    @SerializedName(value="geoCode")
    private GeoCodeData geoCode;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_REQUEST_CODE = "requestCode";
    @SerializedName(value="requestCode")
    private String requestCode;
    public static final String SERIALIZED_NAME_TRANSACTION_CODE = "transactionCode";
    @SerializedName(value="transactionCode")
    private String transactionCode;
    public static final String SERIALIZED_NAME_TRANSACTION_ROLE = "transactionRole";
    @SerializedName(value="transactionRole")
    private TransactionRoleEnum transactionRole;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
    @SerializedName(value="transactionType")
    private InteropTransactionTypeData transactionType;
    public static final String SERIALIZED_NAME_TRANSFER_CODE = "transferCode";
    @SerializedName(value="transferCode")
    private String transferCode;

    public InteropTransferRequestData accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public InteropTransferRequestData amount(MoneyData amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    public MoneyData getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyData amount) {
        this.amount = amount;
    }

    public InteropTransferRequestData expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public InteropTransferRequestData expirationLocalDate(LocalDate expirationLocalDate) {
        this.expirationLocalDate = expirationLocalDate;
        return this;
    }

    @Nullable
    public LocalDate getExpirationLocalDate() {
        return this.expirationLocalDate;
    }

    public void setExpirationLocalDate(LocalDate expirationLocalDate) {
        this.expirationLocalDate = expirationLocalDate;
    }

    public InteropTransferRequestData extensionList(List<ExtensionData> extensionList) {
        this.extensionList = extensionList;
        return this;
    }

    public InteropTransferRequestData addExtensionListItem(ExtensionData extensionListItem) {
        if (this.extensionList == null) {
            this.extensionList = new ArrayList<ExtensionData>();
        }
        this.extensionList.add(extensionListItem);
        return this;
    }

    @Nullable
    public List<ExtensionData> getExtensionList() {
        return this.extensionList;
    }

    public void setExtensionList(List<ExtensionData> extensionList) {
        this.extensionList = extensionList;
    }

    public InteropTransferRequestData fspCommission(MoneyData fspCommission) {
        this.fspCommission = fspCommission;
        return this;
    }

    @Nullable
    public MoneyData getFspCommission() {
        return this.fspCommission;
    }

    public void setFspCommission(MoneyData fspCommission) {
        this.fspCommission = fspCommission;
    }

    public InteropTransferRequestData fspFee(MoneyData fspFee) {
        this.fspFee = fspFee;
        return this;
    }

    @Nullable
    public MoneyData getFspFee() {
        return this.fspFee;
    }

    public void setFspFee(MoneyData fspFee) {
        this.fspFee = fspFee;
    }

    public InteropTransferRequestData geoCode(GeoCodeData geoCode) {
        this.geoCode = geoCode;
        return this;
    }

    @Nullable
    public GeoCodeData getGeoCode() {
        return this.geoCode;
    }

    public void setGeoCode(GeoCodeData geoCode) {
        this.geoCode = geoCode;
    }

    public InteropTransferRequestData note(String note) {
        this.note = note;
        return this;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public InteropTransferRequestData requestCode(String requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    @Nullable
    public String getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public InteropTransferRequestData transactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
        return this;
    }

    @Nonnull
    public String getTransactionCode() {
        return this.transactionCode;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    public InteropTransferRequestData transactionRole(TransactionRoleEnum transactionRole) {
        this.transactionRole = transactionRole;
        return this;
    }

    @Nonnull
    public TransactionRoleEnum getTransactionRole() {
        return this.transactionRole;
    }

    public void setTransactionRole(TransactionRoleEnum transactionRole) {
        this.transactionRole = transactionRole;
    }

    public InteropTransferRequestData transactionType(InteropTransactionTypeData transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Nullable
    public InteropTransactionTypeData getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(InteropTransactionTypeData transactionType) {
        this.transactionType = transactionType;
    }

    public InteropTransferRequestData transferCode(String transferCode) {
        this.transferCode = transferCode;
        return this;
    }

    @Nonnull
    public String getTransferCode() {
        return this.transferCode;
    }

    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InteropTransferRequestData interopTransferRequestData = (InteropTransferRequestData)o;
        return Objects.equals(this.accountId, interopTransferRequestData.accountId) && Objects.equals(this.amount, interopTransferRequestData.amount) && Objects.equals(this.expiration, interopTransferRequestData.expiration) && Objects.equals(this.expirationLocalDate, interopTransferRequestData.expirationLocalDate) && Objects.equals(this.extensionList, interopTransferRequestData.extensionList) && Objects.equals(this.fspCommission, interopTransferRequestData.fspCommission) && Objects.equals(this.fspFee, interopTransferRequestData.fspFee) && Objects.equals(this.geoCode, interopTransferRequestData.geoCode) && Objects.equals(this.note, interopTransferRequestData.note) && Objects.equals(this.requestCode, interopTransferRequestData.requestCode) && Objects.equals(this.transactionCode, interopTransferRequestData.transactionCode) && Objects.equals((Object)this.transactionRole, (Object)interopTransferRequestData.transactionRole) && Objects.equals(this.transactionType, interopTransferRequestData.transactionType) && Objects.equals(this.transferCode, interopTransferRequestData.transferCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.amount, this.expiration, this.expirationLocalDate, this.extensionList, this.fspCommission, this.fspFee, this.geoCode, this.note, this.requestCode, this.transactionCode, this.transactionRole, this.transactionType, this.transferCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InteropTransferRequestData {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    expirationLocalDate: ").append(this.toIndentedString(this.expirationLocalDate)).append("\n");
        sb.append("    extensionList: ").append(this.toIndentedString(this.extensionList)).append("\n");
        sb.append("    fspCommission: ").append(this.toIndentedString(this.fspCommission)).append("\n");
        sb.append("    fspFee: ").append(this.toIndentedString(this.fspFee)).append("\n");
        sb.append("    geoCode: ").append(this.toIndentedString(this.geoCode)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    requestCode: ").append(this.toIndentedString(this.requestCode)).append("\n");
        sb.append("    transactionCode: ").append(this.toIndentedString(this.transactionCode)).append("\n");
        sb.append("    transactionRole: ").append(this.toIndentedString((Object)this.transactionRole)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    transferCode: ").append(this.toIndentedString(this.transferCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionRoleEnum {
        PAYER("PAYER"),
        PAYEE("PAYEE");

        private String value;

        private TransactionRoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionRoleEnum fromValue(String value) {
            for (TransactionRoleEnum b : TransactionRoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionRoleEnum> {
            public void write(JsonWriter jsonWriter, TransactionRoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionRoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionRoleEnum.fromValue(value);
            }
        }
    }
}

