/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.fineract.client.models.ExtensionData;
import org.apache.fineract.client.models.GeoCodeData;
import org.apache.fineract.client.models.InteropTransactionTypeData;
import org.apache.fineract.client.models.MoneyData;

public class InteropTransactionRequestData {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
    @SerializedName(value="accountId")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private MoneyData amount;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private OffsetDateTime expiration;
    public static final String SERIALIZED_NAME_EXPIRATION_LOCAL_DATE = "expirationLocalDate";
    @SerializedName(value="expirationLocalDate")
    private LocalDate expirationLocalDate;
    public static final String SERIALIZED_NAME_EXTENSION_LIST = "extensionList";
    @SerializedName(value="extensionList")
    private List<ExtensionData> extensionList;
    public static final String SERIALIZED_NAME_GEO_CODE = "geoCode";
    @SerializedName(value="geoCode")
    private GeoCodeData geoCode;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_REQUEST_CODE = "requestCode";
    @SerializedName(value="requestCode")
    private String requestCode;
    public static final String SERIALIZED_NAME_TRANSACTION_CODE = "transactionCode";
    @SerializedName(value="transactionCode")
    private String transactionCode;
    public static final String SERIALIZED_NAME_TRANSACTION_ROLE = "transactionRole";
    @SerializedName(value="transactionRole")
    private TransactionRoleEnum transactionRole;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
    @SerializedName(value="transactionType")
    private InteropTransactionTypeData transactionType;

    public InteropTransactionRequestData accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public InteropTransactionRequestData amount(MoneyData amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    public MoneyData getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyData amount) {
        this.amount = amount;
    }

    public InteropTransactionRequestData expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public InteropTransactionRequestData expirationLocalDate(LocalDate expirationLocalDate) {
        this.expirationLocalDate = expirationLocalDate;
        return this;
    }

    @Nullable
    public LocalDate getExpirationLocalDate() {
        return this.expirationLocalDate;
    }

    public void setExpirationLocalDate(LocalDate expirationLocalDate) {
        this.expirationLocalDate = expirationLocalDate;
    }

    public InteropTransactionRequestData extensionList(List<ExtensionData> extensionList) {
        this.extensionList = extensionList;
        return this;
    }

    public InteropTransactionRequestData addExtensionListItem(ExtensionData extensionListItem) {
        if (this.extensionList == null) {
            this.extensionList = new ArrayList<ExtensionData>();
        }
        this.extensionList.add(extensionListItem);
        return this;
    }

    @Nullable
    public List<ExtensionData> getExtensionList() {
        return this.extensionList;
    }

    public void setExtensionList(List<ExtensionData> extensionList) {
        this.extensionList = extensionList;
    }

    public InteropTransactionRequestData geoCode(GeoCodeData geoCode) {
        this.geoCode = geoCode;
        return this;
    }

    @Nullable
    public GeoCodeData getGeoCode() {
        return this.geoCode;
    }

    public void setGeoCode(GeoCodeData geoCode) {
        this.geoCode = geoCode;
    }

    public InteropTransactionRequestData note(String note) {
        this.note = note;
        return this;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public InteropTransactionRequestData requestCode(String requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    @Nullable
    public String getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public InteropTransactionRequestData transactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
        return this;
    }

    @Nonnull
    public String getTransactionCode() {
        return this.transactionCode;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    public InteropTransactionRequestData transactionRole(TransactionRoleEnum transactionRole) {
        this.transactionRole = transactionRole;
        return this;
    }

    @Nonnull
    public TransactionRoleEnum getTransactionRole() {
        return this.transactionRole;
    }

    public void setTransactionRole(TransactionRoleEnum transactionRole) {
        this.transactionRole = transactionRole;
    }

    public InteropTransactionRequestData transactionType(InteropTransactionTypeData transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Nullable
    public InteropTransactionTypeData getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(InteropTransactionTypeData transactionType) {
        this.transactionType = transactionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InteropTransactionRequestData interopTransactionRequestData = (InteropTransactionRequestData)o;
        return Objects.equals(this.accountId, interopTransactionRequestData.accountId) && Objects.equals(this.amount, interopTransactionRequestData.amount) && Objects.equals(this.expiration, interopTransactionRequestData.expiration) && Objects.equals(this.expirationLocalDate, interopTransactionRequestData.expirationLocalDate) && Objects.equals(this.extensionList, interopTransactionRequestData.extensionList) && Objects.equals(this.geoCode, interopTransactionRequestData.geoCode) && Objects.equals(this.note, interopTransactionRequestData.note) && Objects.equals(this.requestCode, interopTransactionRequestData.requestCode) && Objects.equals(this.transactionCode, interopTransactionRequestData.transactionCode) && Objects.equals((Object)this.transactionRole, (Object)interopTransactionRequestData.transactionRole) && Objects.equals(this.transactionType, interopTransactionRequestData.transactionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.amount, this.expiration, this.expirationLocalDate, this.extensionList, this.geoCode, this.note, this.requestCode, this.transactionCode, this.transactionRole, this.transactionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InteropTransactionRequestData {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    expirationLocalDate: ").append(this.toIndentedString(this.expirationLocalDate)).append("\n");
        sb.append("    extensionList: ").append(this.toIndentedString(this.extensionList)).append("\n");
        sb.append("    geoCode: ").append(this.toIndentedString(this.geoCode)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    requestCode: ").append(this.toIndentedString(this.requestCode)).append("\n");
        sb.append("    transactionCode: ").append(this.toIndentedString(this.transactionCode)).append("\n");
        sb.append("    transactionRole: ").append(this.toIndentedString((Object)this.transactionRole)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionRoleEnum {
        PAYER("PAYER"),
        PAYEE("PAYEE");

        private String value;

        private TransactionRoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionRoleEnum fromValue(String value) {
            for (TransactionRoleEnum b : TransactionRoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionRoleEnum> {
            public void write(JsonWriter jsonWriter, TransactionRoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionRoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionRoleEnum.fromValue(value);
            }
        }
    }
}

