/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.")
public class V1FlockerVolumeSource {
    public static final String SERIALIZED_NAME_DATASET_NAME = "datasetName";
    @SerializedName(value="datasetName")
    private String datasetName;
    public static final String SERIALIZED_NAME_DATASET_U_U_I_D = "datasetUUID";
    @SerializedName(value="datasetUUID")
    private String datasetUUID;

    public V1FlockerVolumeSource datasetName(String datasetName) {
        this.datasetName = datasetName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated")
    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public V1FlockerVolumeSource datasetUUID(String datasetUUID) {
        this.datasetUUID = datasetUUID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UUID of the dataset. This is unique identifier of a Flocker dataset")
    public String getDatasetUUID() {
        return this.datasetUUID;
    }

    public void setDatasetUUID(String datasetUUID) {
        this.datasetUUID = datasetUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FlockerVolumeSource v1FlockerVolumeSource = (V1FlockerVolumeSource)o;
        return Objects.equals(this.datasetName, v1FlockerVolumeSource.datasetName) && Objects.equals(this.datasetUUID, v1FlockerVolumeSource.datasetUUID);
    }

    public int hashCode() {
        return Objects.hash(this.datasetName, this.datasetUUID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FlockerVolumeSource {\n");
        sb.append("    datasetName: ").append(this.toIndentedString(this.datasetName)).append("\n");
        sb.append("    datasetUUID: ").append(this.toIndentedString(this.datasetUUID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

