/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.v2.FillConcat;
import com.qcloud.cos.model.ciModel.job.v2.FillInput;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class FillConcatJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        FillConcatJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws JsonProcessingException {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("FillConcat");
        MediaJobOperation operation = request.getOperation();
        FillConcat fillConcat = operation.getFillConcat();
        fillConcat.setFormat("mp4");
        List<FillInput> fillInputList = fillConcat.getFillInput();
        FillInput fillInput = new FillInput();
        fillInput.setUrl("https://demo-1234567890.cos.ap-singapore.com/files/1.mp4");
        fillInputList.add(fillInput);
        fillInput = new FillInput();
        fillInput.setUrl("https://demo-1234567890.cos.ap-singapore.com/files/2.mp4");
        fillInputList.add(fillInput);
        MediaOutputObject output = request.getOperation().getOutput();
        output.setBucket("demo-1234567890");
        output.setRegion("ap-chongqing");
        output.setObject("media/out.${ext}");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(response.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setJobId("j5d15810e77e111eeaf41e735259*****");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

