/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.security.keyvault.keys.cryptography.implementation.SecretProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SecretRequestAttributes {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="nbf")
    private Long notBefore;
    @JsonProperty(value="exp")
    private Long expires;
    @JsonProperty(value="created", access=JsonProperty.Access.WRITE_ONLY)
    private Long created;
    @JsonProperty(value="updated", access=JsonProperty.Access.WRITE_ONLY)
    private Long updated;

    public SecretRequestAttributes(SecretProperties secretProperties) {
        if (secretProperties.getNotBefore() != null) {
            this.notBefore = secretProperties.getNotBefore().toEpochSecond();
        }
        if (secretProperties.getExpiresOn() != null) {
            this.expires = secretProperties.getExpiresOn().toEpochSecond();
        }
        this.enabled = secretProperties.isEnabled();
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public SecretRequestAttributes getEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.notBefore * 1000L), ZoneOffset.UTC);
    }

    public SecretRequestAttributes setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(OffsetDateTime.ofInstant(notBefore.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    public OffsetDateTime getExpires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.expires * 1000L), ZoneOffset.UTC);
    }

    public SecretRequestAttributes setExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(OffsetDateTime.ofInstant(expires.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.created * 1000L), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.updated * 1000L), ZoneOffset.UTC);
    }
}

